/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity;

import com.google.common.base.Optional;
import info.ata4.minecraft.dragon.client.model.anim.DragonAnimator;
import info.ata4.minecraft.dragon.server.entity.ai.path.PathNavigateFlying;
import info.ata4.minecraft.dragon.server.entity.breeds.DragonBreed;
import info.ata4.minecraft.dragon.server.entity.breeds.EnumDragonBreed;
import info.ata4.minecraft.dragon.server.entity.helper.DragonBodyHelper;
import info.ata4.minecraft.dragon.server.entity.helper.DragonBrain;
import info.ata4.minecraft.dragon.server.entity.helper.DragonBreedHelper;
import info.ata4.minecraft.dragon.server.entity.helper.DragonHelper;
import info.ata4.minecraft.dragon.server.entity.helper.DragonInteractHelper;
import info.ata4.minecraft.dragon.server.entity.helper.DragonLifeStageHelper;
import info.ata4.minecraft.dragon.server.entity.helper.DragonMoveHelper;
import info.ata4.minecraft.dragon.server.entity.helper.DragonParticleHelper;
import info.ata4.minecraft.dragon.server.entity.helper.DragonReproductionHelper;
import info.ata4.minecraft.dragon.server.entity.helper.DragonSoundManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketAnimation;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityTameableDragon
extends EntityTameable {
    private static final Logger L = LogManager.getLogger();
    public static final IAttribute MOVEMENT_SPEED_AIR = new RangedAttribute(null, "generic.movementSpeedAir", 1.5, 0.0, Double.MAX_VALUE).func_111117_a("Movement Speed Air").func_111112_a(true);
    public static final double BASE_SPEED_GROUND = 0.3;
    public static final double BASE_SPEED_AIR = 0.4;
    public static final double BASE_DAMAGE = 8.0;
    public static final double BASE_HEALTH = 60.0;
    public static final float BASE_WIDTH = 2.75f;
    public static final float BASE_HEIGHT = 2.75f;
    public static final double BASE_FOLLOW_RANGE = 16.0;
    public static final double BASE_FOLLOW_RANGE_FLYING = 32.0;
    public static final int HOME_RADIUS = 64;
    public static final double ALTITUDE_FLYING_THRESHOLD = 2.0;
    private static final DataParameter<Boolean> DATA_FLYING = EntityDataManager.func_187226_a(EntityTameableDragon.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DATA_SADDLED = EntityDataManager.func_187226_a(EntityTameableDragon.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Optional<UUID>> DATA_BREEDER = EntityDataManager.func_187226_a(EntityTameableDragon.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<String> DATA_BREED = EntityDataManager.func_187226_a(EntityTameableDragon.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> DATA_REPRO_COUNT = EntityDataManager.func_187226_a(EntityTameableDragon.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DATA_TICKS_SINCE_CREATION = EntityDataManager.func_187226_a(EntityTameableDragon.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final String NBT_SADDLED = "Saddle";
    private final Map<Class, DragonHelper> helpers = new HashMap<Class, DragonHelper>();
    private final DragonBodyHelper bodyHelper = new DragonBodyHelper(this);

    public EntityTameableDragon(World world) {
        super(world);
        this.func_70105_a(2.75f, 2.75f);
        this.field_70138_W = 1.0f;
        this.addHelper(new DragonBreedHelper(this, DATA_BREED));
        this.addHelper(new DragonLifeStageHelper(this, DATA_TICKS_SINCE_CREATION));
        this.addHelper(new DragonReproductionHelper(this, DATA_BREEDER, DATA_REPRO_COUNT));
        this.addHelper(new DragonSoundManager(this));
        this.addHelper(new DragonInteractHelper(this));
        if (this.isClient()) {
            this.addHelper(new DragonParticleHelper(this));
            this.addHelper(new DragonAnimator(this));
        } else {
            this.addHelper(new DragonBrain(this));
        }
        this.field_70765_h = new DragonMoveHelper(this);
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.helpers.values().forEach(DragonHelper::applyEntityAttributes);
    }

    protected float func_110146_f(float p_110146_1_, float p_110146_2_) {
        this.bodyHelper.func_75664_a();
        return p_110146_2_;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_FLYING, (Object)false);
        this.field_70180_af.func_187214_a(DATA_SADDLED, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110140_aT().func_111150_b(MOVEMENT_SPEED_AIR);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(MOVEMENT_SPEED_AIR).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    public boolean isSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_SADDLED);
    }

    public void setSaddled(boolean saddled) {
        L.trace("setSaddled({})", new Object[]{saddled});
        this.field_70180_af.func_187227_b(DATA_SADDLED, (Object)saddled);
    }

    public boolean canFly() {
        return !this.isEgg() && !this.isHatchling();
    }

    public boolean isFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_FLYING);
    }

    public void setFlying(boolean flying) {
        L.trace("setFlying({})", new Object[]{flying});
        this.field_70180_af.func_187227_b(DATA_FLYING, (Object)flying);
    }

    public double getAltitude() {
        BlockPos groundPos = this.field_70170_p.func_175645_m(this.func_180425_c());
        return this.field_70163_u - (double)groundPos.func_177956_o();
    }

    public void liftOff() {
        L.trace("liftOff");
        if (this.canFly()) {
            this.func_70664_aZ();
        }
    }

    protected float func_175134_bD() {
        return this.canFly() ? 1.0f : super.func_175134_bD();
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (!this.canFly()) {
            super.func_180430_e(distance, damageMultiplier);
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a(NBT_SADDLED, this.isSaddled());
        this.helpers.values().forEach(helper -> helper.writeToNBT(nbt));
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setSaddled(nbt.func_74767_n(NBT_SADDLED));
        this.helpers.values().forEach(helper -> helper.readFromNBT(nbt));
    }

    public void func_70636_d() {
        this.helpers.values().forEach(DragonHelper::onLivingUpdate);
        if (this.isServer()) {
            boolean flying;
            EntityLivingBase owner;
            if (this.func_70909_n() && (owner = this.func_70902_q()) != null) {
                this.func_175449_a(owner.func_180425_c(), 64);
            }
            boolean bl = flying = this.canFly() && this.getAltitude() > 2.0;
            if (flying != this.isFlying()) {
                this.setFlying(flying);
                this.getBrain().clearTasks();
                this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(flying ? 32.0 : 16.0);
                this.field_70699_by = flying ? new PathNavigateFlying((EntityLiving)this, this.field_70170_p) : new PathNavigateGround((EntityLiving)this, this.field_70170_p);
                this.getBrain().updateAITasks();
            }
        }
        super.func_70636_d();
    }

    public void func_70612_e(float strafe, float forward) {
        if (!this.isFlying()) {
            super.func_70612_e(strafe, forward);
        }
    }

    protected void func_70609_aI() {
        this.helpers.values().forEach(DragonHelper::onDeathUpdate);
        this.func_184226_ay();
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        this.field_70177_z = this.field_70126_B;
        this.field_70759_as = this.field_70758_at;
        if (this.isEgg()) {
            this.func_70106_y();
        } else if (this.field_70725_aQ >= this.getMaxDeathTime()) {
            this.func_70106_y();
        }
        ++this.field_70725_aQ;
    }

    public void func_70106_y() {
        this.helpers.values().forEach(DragonHelper::onDeath);
        super.func_70106_y();
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        String entName = EntityList.func_75621_b((Entity)this);
        String breedName = this.getBreedType().func_176610_l().toLowerCase();
        return I18n.func_74838_a((String)("entity." + entName + "." + breedName + ".name"));
    }

    protected SoundEvent func_184639_G() {
        return this.getSoundManager().getLivingSound();
    }

    protected SoundEvent func_184601_bQ() {
        return this.getSoundManager().getHurtSound();
    }

    protected SoundEvent func_184615_bR() {
        return this.getSoundManager().getDeathSound();
    }

    public void func_70642_aH() {
        this.getSoundManager().playLivingSound();
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        this.getSoundManager().playSound(soundIn, volume, pitch);
    }

    protected void func_180429_a(BlockPos entityPos, Block block) {
        this.getSoundManager().playStepSound(entityPos, block);
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    protected float func_70647_i() {
        return 1.0f;
    }

    public int func_70627_aG() {
        return this.getSoundManager().getTalkInterval();
    }

    public EnumCreatureAttribute func_70668_bt() {
        return this.getBreed().getCreatureAttribute();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, ItemStack item) {
        if (this.isEgg()) {
            return false;
        }
        if (super.func_184645_a(player, hand, item)) {
            return true;
        }
        return this.getInteractHelper().interact(player, item);
    }

    public void tamedFor(EntityPlayer player, boolean successful) {
        if (successful) {
            this.func_70903_f(true);
            this.field_70699_by.func_75499_g();
            this.func_70624_b(null);
            this.func_184754_b(player.func_110124_au());
            this.func_70908_e(true);
            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
        } else {
            this.func_70908_e(false);
            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
        }
    }

    public boolean isTamedFor(EntityPlayer player) {
        return this.func_70909_n() && this.func_152114_e((EntityLivingBase)player);
    }

    public boolean func_70877_b(ItemStack item) {
        return this.getBreed().getBreedingItem() == item.func_77973_b();
    }

    public float func_70047_e() {
        float eyeHeight = super.func_70047_e();
        if (this.func_70906_o()) {
            eyeHeight *= 0.8f;
        }
        return eyeHeight;
    }

    public double func_70042_X() {
        return (this.func_70906_o() ? 1.7f : 2.2f) * this.getScale();
    }

    public float func_70603_bj() {
        return this.getScale();
    }

    public boolean func_70104_M() {
        return super.func_70104_M() && this.isEgg();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70617_f_() {
        return false;
    }

    protected void func_70628_a(boolean par1, int par2) {
        super.func_70628_a(par1, par2);
        if (this.isSaddled()) {
            this.func_145779_a(Items.field_151141_av, 1);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean attacked = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
        if (attacked) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return attacked;
    }

    public void func_184609_a(EnumHand hand) {
        this.func_184185_a(this.getSoundManager().getAttackSound(), 1.0f, 0.7f);
        if (this.field_70170_p instanceof WorldServer) {
            ((WorldServer)this.field_70170_p).func_73039_n().func_151247_a((Entity)this, (Packet)new SPacketAnimation((Entity)this, 0));
        }
    }

    public boolean func_70097_a(DamageSource src, float par2) {
        if (this.isInvulnerableTo(src)) {
            return false;
        }
        this.field_70911_d.func_75270_a(false);
        return super.func_70097_a(src, par2);
    }

    public boolean func_90999_ad() {
        return super.func_90999_ad() && !this.getBreed().isImmuneToDamage(DamageSource.field_76372_a);
    }

    public boolean func_70878_b(EntityAnimal mate) {
        return this.getReproductionHelper().canMateWith(mate);
    }

    public EntityAgeable func_90011_a(EntityAgeable mate) {
        return this.getReproductionHelper().createChild(mate);
    }

    private void addHelper(DragonHelper helper) {
        L.trace("addHelper({})", new Object[]{helper.getClass().getName()});
        this.helpers.put(helper.getClass(), helper);
    }

    private <T extends DragonHelper> T getHelper(Class<T> clazz) {
        return (T)this.helpers.get(clazz);
    }

    public DragonBreedHelper getBreedHelper() {
        return this.getHelper(DragonBreedHelper.class);
    }

    public DragonLifeStageHelper getLifeStageHelper() {
        return this.getHelper(DragonLifeStageHelper.class);
    }

    public DragonReproductionHelper getReproductionHelper() {
        return this.getHelper(DragonReproductionHelper.class);
    }

    public DragonParticleHelper getParticleHelper() {
        return this.getHelper(DragonParticleHelper.class);
    }

    public DragonAnimator getAnimator() {
        return this.getHelper(DragonAnimator.class);
    }

    public DragonSoundManager getSoundManager() {
        return this.getHelper(DragonSoundManager.class);
    }

    public DragonBrain getBrain() {
        return this.getHelper(DragonBrain.class);
    }

    public DragonInteractHelper getInteractHelper() {
        return this.getHelper(DragonInteractHelper.class);
    }

    public EnumDragonBreed getBreedType() {
        return this.getBreedHelper().getBreedType();
    }

    public void setBreedType(EnumDragonBreed type) {
        this.getBreedHelper().setBreedType(type);
    }

    public DragonBreed getBreed() {
        return this.getBreedType().getBreed();
    }

    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public boolean func_184186_bw() {
        return false;
    }

    public EntityPlayer getRidingPlayer() {
        Entity entity = this.func_184179_bs();
        if (entity instanceof EntityPlayer) {
            return (EntityPlayer)entity;
        }
        return null;
    }

    public void setRidingPlayer(EntityPlayer player) {
        L.trace("setRidingPlayer({})", new Object[]{player.func_70005_c_()});
        player.field_70177_z = this.field_70177_z;
        player.field_70125_A = this.field_70125_A;
        player.func_184220_m((Entity)this);
    }

    public boolean isInvulnerableTo(DamageSource src) {
        Entity srcEnt = src.func_76346_g();
        if (srcEnt != null) {
            if (srcEnt == this) {
                return true;
            }
            if (this.func_184196_w(srcEnt)) {
                return true;
            }
        }
        if (src.field_76373_n.equals("drown") && this.isEgg()) {
            return true;
        }
        return this.getBreed().isImmuneToDamage(src);
    }

    public double getHealthRelative() {
        return (double)this.func_110143_aJ() / (double)this.func_110138_aP();
    }

    public int getDeathTime() {
        return this.field_70725_aQ;
    }

    public int getMaxDeathTime() {
        return 120;
    }

    public void setImmuneToFire(boolean isImmuneToFire) {
        L.trace("setImmuneToFire({})", new Object[]{isImmuneToFire});
        this.field_70178_ae = isImmuneToFire;
    }

    public void setAttackDamage(double damage) {
        L.trace("setAttackDamage({})", new Object[]{damage});
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(damage);
    }

    public void setScalePublic(float scale) {
        double posXTmp = this.field_70165_t;
        double posYTmp = this.field_70163_u;
        double posZTmp = this.field_70161_v;
        boolean onGroundTmp = this.field_70122_E;
        this.func_98055_j(scale);
        this.func_70107_b(posXTmp, posYTmp, posZTmp);
        this.field_70122_E = onGroundTmp;
    }

    public int func_70874_b() {
        return this.isAdult() ? 0 : -1;
    }

    public void func_70873_a(int age) {
    }

    public void func_98054_a(boolean p_98054_1_) {
    }

    public float getScale() {
        return this.getLifeStageHelper().getScale();
    }

    public boolean isEgg() {
        return this.getLifeStageHelper().isEgg();
    }

    public boolean isHatchling() {
        return this.getLifeStageHelper().isHatchling();
    }

    public boolean isJuvenile() {
        return this.getLifeStageHelper().isJuvenile();
    }

    public boolean isAdult() {
        return this.getLifeStageHelper().isAdult();
    }

    public boolean func_70631_g_() {
        return !this.isAdult();
    }

    public final boolean isClient() {
        return this.field_70170_p.field_72995_K;
    }

    public final boolean isServer() {
        return !this.field_70170_p.field_72995_K;
    }
}

