/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity.breeds;

import info.ata4.minecraft.dragon.DragonMountsSoundEvents;
import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public abstract class DragonBreed {
    private final String skin;
    private final int color;
    private final Set<String> immunities = new HashSet<String>();
    private final Set<Block> breedBlocks = new HashSet<Block>();
    private final Set<Biome> biomes = new HashSet<Biome>();
    protected final Random rand = new Random();

    DragonBreed(String skin, int color) {
        this.skin = skin;
        this.color = color;
        this.addImmunity(DamageSource.field_76369_e);
        this.addImmunity(DamageSource.field_76368_d);
        this.addImmunity(DamageSource.field_76367_g);
        this.addImmunity(DamageSource.field_188407_q);
    }

    public String getSkin() {
        return this.skin;
    }

    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.UNDEFINED;
    }

    public int getColor() {
        return this.color;
    }

    public float getColorR() {
        return (float)(this.color >> 16 & 0xFF) / 255.0f;
    }

    public float getColorG() {
        return (float)(this.color >> 8 & 0xFF) / 255.0f;
    }

    public float getColorB() {
        return (float)(this.color & 0xFF) / 255.0f;
    }

    protected final void addImmunity(DamageSource dmg) {
        this.immunities.add(dmg.field_76373_n);
    }

    public boolean isImmuneToDamage(DamageSource dmg) {
        if (this.immunities.isEmpty()) {
            return false;
        }
        return this.immunities.contains(dmg.field_76373_n);
    }

    protected final void addHabitatBlock(Block block) {
        this.breedBlocks.add(block);
    }

    public boolean isHabitatBlock(Block block) {
        return this.breedBlocks.contains(block);
    }

    protected final void addHabitatBiome(Biome biome) {
        this.biomes.add(biome);
    }

    public boolean isHabitatBiome(Biome biome) {
        return this.biomes.contains(biome);
    }

    public boolean isHabitatEnvironment(EntityTameableDragon dragon) {
        return false;
    }

    public Item[] getFoodItems() {
        return new Item[]{Items.field_151147_al, Items.field_151082_bd, Items.field_151076_bf};
    }

    public Item getBreedingItem() {
        return Items.field_151115_aP;
    }

    public void onUpdate(EntityTameableDragon dragon) {
        this.placeFootprintBlocks(dragon);
    }

    protected void placeFootprintBlocks(EntityTameableDragon dragon) {
        if (!dragon.isServer()) {
            return;
        }
        if (!dragon.isAdult() || dragon.isFlying()) {
            return;
        }
        float footprintChance = this.getFootprintChance();
        if (footprintChance == 0.0f) {
            return;
        }
        World world = dragon.field_70170_p;
        for (int i = 0; i < 4; ++i) {
            double bz;
            double by;
            double bx;
            BlockPos pos;
            if (world.field_73012_v.nextFloat() > footprintChance || world.func_175623_d(pos = new BlockPos(bx = dragon.field_70165_t + (double)(i % 2 * 2 - 1) * 0.25, by = dragon.field_70163_u + 0.5, bz = dragon.field_70161_v + (double)(i / 2 % 2 * 2 - 1) * 0.25))) continue;
            this.placeFootprintBlock(dragon, pos);
        }
    }

    protected void placeFootprintBlock(EntityTameableDragon dragon, BlockPos blockPos) {
    }

    protected float getFootprintChance() {
        return 0.0f;
    }

    public abstract void onEnable(EntityTameableDragon var1);

    public abstract void onDisable(EntityTameableDragon var1);

    public abstract void onDeath(EntityTameableDragon var1);

    public SoundEvent getLivingSound() {
        if (this.rand.nextInt(3) == 0) {
            return SoundEvents.field_187525_aO;
        }
        return DragonMountsSoundEvents.ENTITY_DRAGON_MOUNT_BREATHE;
    }

    public SoundEvent getHurtSound() {
        return SoundEvents.field_187526_aP;
    }

    public SoundEvent getDeathSound() {
        return DragonMountsSoundEvents.ENTITY_DRAGON_MOUNT_DEATH;
    }

    public SoundEvent getWingsSound() {
        return SoundEvents.field_187524_aN;
    }

    public SoundEvent getStepSound() {
        return DragonMountsSoundEvents.ENTITY_DRAGON_MOUNT_STEP;
    }

    public SoundEvent getEatSound() {
        return SoundEvents.field_187537_bA;
    }

    public SoundEvent getAttackSound() {
        return SoundEvents.field_187537_bA;
    }

    public float getSoundPitch(SoundEvent sound) {
        return 1.0f;
    }

    public float getSoundVolume(SoundEvent sound) {
        return 1.0f;
    }
}

