/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.item.ItemWrittenBook;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import noppes.npcs.api.entity.IEntityLiving;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.ItemBookWrapper;

public class ItemStackWrapper
implements IItemStack {
    public ItemStack item;

    protected ItemStackWrapper(ItemStack item) {
        this.item = item;
    }

    @Override
    public int getStackSize() {
        return this.item.field_77994_a;
    }

    @Override
    public void setStackSize(int size) {
        if (size < 0) {
            size = 1;
        } else if (size > 64) {
            size = 64;
        }
        this.item.field_77994_a = size;
    }

    @Override
    public int getItemDamage() {
        return this.item.func_77952_i();
    }

    @Override
    public void setItemDamage(int value) {
        this.item.func_77964_b(value);
    }

    @Override
    public void setTag(String key, Object value) {
        if (value instanceof Number) {
            this.getTag().func_74780_a(key, ((Number)value).doubleValue());
        } else if (value instanceof String) {
            this.getTag().func_74778_a(key, (String)value);
        }
    }

    @Override
    public boolean hasTag(String key) {
        return this.getTag().func_74764_b(key);
    }

    @Override
    public Object getTag(String key) {
        NBTBase tag = this.getTag().func_74781_a(key);
        if (tag == null) {
            return null;
        }
        if (tag instanceof NBTPrimitive) {
            return ((NBTPrimitive)tag).func_150286_g();
        }
        if (tag instanceof NBTTagString) {
            return ((NBTTagString)tag).func_150285_a_();
        }
        return tag;
    }

    @Override
    public boolean isEnchanted() {
        return this.item.func_77948_v();
    }

    @Override
    public boolean hasEnchant(int id) {
        if (!this.isEnchanted()) {
            return false;
        }
        NBTTagList list = this.item.func_77986_q();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            if (compound.func_74765_d("id") != id) continue;
            return true;
        }
        return false;
    }

    private NBTTagCompound getTag() {
        if (!this.item.func_77942_o()) {
            this.item.func_77982_d(new NBTTagCompound());
        }
        return this.item.func_77978_p();
    }

    @Override
    public boolean isBlock() {
        Block block = Block.func_149634_a((Item)this.item.func_77973_b());
        return block != null && block != Blocks.field_150350_a;
    }

    @Override
    public boolean hasCustomName() {
        return this.item.func_82837_s();
    }

    @Override
    public void setCustomName(String name) {
        this.item.func_151001_c(name);
    }

    @Override
    public String getDisplayName() {
        return this.item.func_82833_r();
    }

    @Override
    public String getItemName() {
        return this.item.func_77973_b().func_77653_i(this.item);
    }

    @Override
    public String getName() {
        return Item.field_150901_e.func_177774_c((Object)this.item.func_77973_b()) + "";
    }

    @Override
    public ItemStack getMCItemStack() {
        return this.item;
    }

    public static ItemStack MCItem(IItemStack item) {
        if (item == null) {
            return null;
        }
        return item.getMCItemStack();
    }

    @Override
    public void damageItem(int damage, IEntityLiving living) {
        this.item.func_77972_a(damage, living == null ? null : (EntityLivingBase)living.getMCEntity());
    }

    @Override
    public boolean isBook() {
        return false;
    }

    public static ItemStackWrapper create(ItemStack item) {
        if (item == null || item.func_77973_b() == null) {
            return null;
        }
        if (item.func_77973_b() == Items.field_151164_bB || item.func_77973_b() == Items.field_151099_bA || item.func_77973_b() instanceof ItemWritableBook || item.func_77973_b() instanceof ItemWrittenBook) {
            return new ItemBookWrapper(item);
        }
        return new ItemStackWrapper(item);
    }

    @Override
    public IItemStack copy() {
        return ItemStackWrapper.create(this.item.func_77946_l());
    }
}

