/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import noppes.npcs.api.CommandNoppesBase;
import noppes.npcs.controllers.Faction;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerFactionData;

public class CmdFaction
extends CommandNoppesBase {
    public Faction selectedFaction;
    public List<PlayerData> data;

    public String func_71517_b() {
        return "faction";
    }

    @Override
    public String getDescription() {
        return "Faction operations";
    }

    @Override
    public String getUsage() {
        return "<player> <faction> <command>";
    }

    @Override
    public boolean runSubCommands() {
        return false;
    }

    @Override
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String playername = args[0];
        String factionname = args[1];
        this.data = PlayerDataController.instance.getPlayersData(sender, playername);
        if (this.data.isEmpty()) {
            throw new CommandException("Unknow player '%s'", new Object[]{playername});
        }
        try {
            this.selectedFaction = FactionController.getInstance().getFaction(Integer.parseInt(factionname));
        }
        catch (NumberFormatException e) {
            this.selectedFaction = FactionController.getInstance().getFactionFromName(factionname);
        }
        if (this.selectedFaction == null) {
            throw new CommandException("Unknow facion '%s", new Object[]{factionname});
        }
        this.executeSub(server, sender, args[2], Arrays.copyOfRange(args, 3, args.length));
        for (PlayerData playerdata : this.data) {
            playerdata.save();
        }
    }

    @CommandNoppesBase.SubCommand(desc="Add points", usage="<points>")
    public void add(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int points;
        try {
            points = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException ex) {
            throw new CommandException("Must be an integer", new Object[0]);
        }
        int factionid = this.selectedFaction.id;
        for (PlayerData playerdata : this.data) {
            PlayerFactionData playerfactiondata = playerdata.factionData;
            playerfactiondata.increasePoints(factionid, points);
        }
    }

    @CommandNoppesBase.SubCommand(desc="Substract points", usage="<points>")
    public void subtract(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int points;
        try {
            points = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException ex) {
            throw new CommandException("Must be an integer", new Object[0]);
        }
        int factionid = this.selectedFaction.id;
        for (PlayerData playerdata : this.data) {
            PlayerFactionData playerfactiondata = playerdata.factionData;
            playerfactiondata.increasePoints(factionid, -points);
        }
    }

    @CommandNoppesBase.SubCommand(desc="Reset points to default")
    public void reset(MinecraftServer server, ICommandSender sender, String[] args) {
        for (PlayerData playerdata : this.data) {
            playerdata.factionData.factionData.put(this.selectedFaction.id, this.selectedFaction.defaultPoints);
        }
    }

    @CommandNoppesBase.SubCommand(desc="Set points", usage="<points>")
    public void set(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int points;
        try {
            points = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException ex) {
            throw new CommandException("Must be an integer", new Object[0]);
        }
        for (PlayerData playerdata : this.data) {
            PlayerFactionData playerfactiondata = playerdata.factionData;
            playerfactiondata.factionData.put(this.selectedFaction.id, points);
        }
    }

    @CommandNoppesBase.SubCommand(desc="Drop relationship")
    public void drop(MinecraftServer server, ICommandSender sender, String[] args) {
        for (PlayerData playerdata : this.data) {
            playerdata.factionData.factionData.remove(this.selectedFaction.id);
        }
    }

    public List func_184883_a(MinecraftServer server, ICommandSender par1, String[] args, BlockPos pos) {
        if (args.length == 3) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"add", "subtract", "set", "reset", "drop", "create"});
        }
        return null;
    }
}

