/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import noppes.npcs.Server;
import noppes.npcs.api.CommandNoppesBase;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.Quest;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.QuestData;

public class CmdQuest
extends CommandNoppesBase {
    public String func_71517_b() {
        return "quest";
    }

    @Override
    public String getDescription() {
        return "Quest operations";
    }

    @CommandNoppesBase.SubCommand(desc="Start a quest", usage="<player> <quest>")
    public void start(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int questid;
        String playername = args[0];
        try {
            questid = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            throw new CommandException("QuestID must be an integer", new Object[0]);
        }
        List<PlayerData> data = PlayerDataController.instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            throw new CommandException("Unknow player '%s'", new Object[]{playername});
        }
        Quest quest = QuestController.instance.quests.get(questid);
        if (quest == null) {
            throw new CommandException("Unknown QuestID", new Object[0]);
        }
        for (PlayerData playerdata : data) {
            QuestData questdata = new QuestData(quest);
            playerdata.questData.activeQuests.put(questid, questdata);
            playerdata.save();
            Server.sendData((EntityPlayerMP)playerdata.player, EnumPacketClient.MESSAGE, "quest.newquest", quest.title);
            Server.sendData((EntityPlayerMP)playerdata.player, EnumPacketClient.CHAT, "quest.newquest", ": ", quest.title);
        }
    }

    @CommandNoppesBase.SubCommand(desc="Finish a quest", usage="<player> <quest>")
    public void finish(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int questid;
        String playername = args[0];
        try {
            questid = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            throw new CommandException("QuestID must be an integer", new Object[0]);
        }
        List<PlayerData> data = PlayerDataController.instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            throw new CommandException(String.format("Unknow player '%s'", playername), new Object[0]);
        }
        Quest quest = QuestController.instance.quests.get(questid);
        if (quest == null) {
            throw new CommandException("Unknown QuestID", new Object[0]);
        }
        for (PlayerData playerdata : data) {
            playerdata.questData.finishedQuests.put(questid, System.currentTimeMillis());
            playerdata.save();
        }
    }

    @CommandNoppesBase.SubCommand(desc="Stop a started quest", usage="<player> <quest>")
    public void stop(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int questid;
        String playername = args[0];
        try {
            questid = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            throw new CommandException("QuestID must be an integer", new Object[0]);
        }
        List<PlayerData> data = PlayerDataController.instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            throw new CommandException(String.format("Unknow player '%s'", playername), new Object[0]);
        }
        Quest quest = QuestController.instance.quests.get(questid);
        if (quest == null) {
            throw new CommandException("Unknown QuestID", new Object[0]);
        }
        for (PlayerData playerdata : data) {
            playerdata.questData.activeQuests.remove(questid);
            playerdata.save();
        }
    }

    @CommandNoppesBase.SubCommand(desc="Removes a quest from finished and active quests", usage="<player> <quest>")
    public void remove(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int questid;
        String playername = args[0];
        try {
            questid = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            throw new CommandException("QuestID must be an integer", new Object[0]);
        }
        List<PlayerData> data = PlayerDataController.instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            throw new CommandException(String.format("Unknow player '%s'", playername), new Object[0]);
        }
        Quest quest = QuestController.instance.quests.get(questid);
        if (quest == null) {
            throw new CommandException("Unknown QuestID", new Object[0]);
        }
        for (PlayerData playerdata : data) {
            playerdata.questData.activeQuests.remove(questid);
            playerdata.questData.finishedQuests.remove(questid);
            playerdata.save();
        }
    }

    @CommandNoppesBase.SubCommand(desc="reload quests from disk", permission=4)
    public void reload(MinecraftServer server, ICommandSender sender, String[] args) {
        new DialogController();
    }
}

