/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import noppes.npcs.LogWriter;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobSpawner;
import org.apache.logging.log4j.LogManager;

public class PixelmonHelper {
    public static boolean Enabled = false;
    private static Object PokeballManager = null;
    private static Method getPlayerStorage = null;
    private static Object ComputerManager = null;
    private static Method getPlayerComputerStorage = null;
    private static Constructor attackByID = null;
    private static Constructor attackByName = null;
    private static Field baseAttack = null;
    private static Field getAttackID = null;
    private static Field getAttackName = null;
    private static Method getPixelmonModel = null;

    public static void load() {
        Class<?> c;
        Enabled = Loader.isModLoaded((String)"pixelmon");
        if (!Enabled) {
            return;
        }
        try {
            c = Class.forName("com.pixelmonmod.pixelmon.entities.pixelmon.Entity2HasModel");
            getPixelmonModel = c.getMethod("getModel", new Class[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            c = Class.forName("com.pixelmonmod.pixelmon.storage.PixelmonStorage");
            PokeballManager = c.getField("pokeBallManager").get(null);
            ComputerManager = c.getField("computerManager").get(null);
            getPlayerStorage = PokeballManager.getClass().getMethod("getPlayerStorage", EntityPlayerMP.class);
            getPlayerComputerStorage = ComputerManager.getClass().getMethod("getPlayerStorage", EntityPlayerMP.class);
            c = Class.forName("com.pixelmonmod.pixelmon.battles.attacks.Attack");
            attackByID = c.getConstructor(Integer.TYPE);
            attackByName = c.getConstructor(String.class);
            baseAttack = c.getField("baseAttack");
            c = Class.forName("com.pixelmonmod.pixelmon.battles.attacks.AttackBase");
            getAttackID = c.getField("attackIndex");
            getAttackName = c.getDeclaredField("attackName");
            getAttackName.setAccessible(true);
        }
        catch (Exception e) {
            LogWriter.except(e);
        }
    }

    public static List<String> getPixelmonList() {
        ArrayList<String> list = new ArrayList<String>();
        if (!Enabled) {
            return list;
        }
        try {
            ?[] array;
            Class<?> c = Class.forName("com.pixelmonmod.pixelmon.enums.EnumPokemon");
            for (Object ob : array = c.getEnumConstants()) {
                list.add(ob.toString());
            }
        }
        catch (Exception e) {
            LogManager.getLogger().error("getPixelmonList", (Throwable)e);
        }
        return list;
    }

    public static boolean isPixelmon(Entity entity) {
        if (!Enabled) {
            return false;
        }
        String s = EntityList.func_75621_b((Entity)entity);
        if (s == null) {
            return false;
        }
        return s.equals("pixelmon.Pixelmon");
    }

    public static void setName(EntityLivingBase entity, String name) {
        if (!Enabled || !PixelmonHelper.isPixelmon((Entity)entity)) {
            return;
        }
        try {
            Method m = entity.getClass().getMethod("init", String.class);
            m.invoke((Object)entity, name);
            Class<?> c = Class.forName("com.pixelmonmod.pixelmon.entities.pixelmon.Entity2HasModel");
            m = c.getDeclaredMethod("loadModel", new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)entity, new Object[0]);
        }
        catch (Exception e) {
            LogManager.getLogger().error("setName", (Throwable)e);
        }
    }

    public static String getName(EntityLivingBase entity) {
        if (!Enabled || !PixelmonHelper.isPixelmon((Entity)entity)) {
            return "";
        }
        try {
            Method m = entity.getClass().getMethod("getName", new Class[0]);
            return m.invoke((Object)entity, new Object[0]).toString();
        }
        catch (Exception e) {
            LogManager.getLogger().error("getName", (Throwable)e);
            return "";
        }
    }

    public static Object getModel(EntityLivingBase entity) {
        try {
            return getPixelmonModel.invoke((Object)entity, new Object[0]);
        }
        catch (Exception e) {
            LogManager.getLogger().error("getModel", (Throwable)e);
            return null;
        }
    }

    public static void debug(EntityLivingBase entity) {
        if (!Enabled || !PixelmonHelper.isPixelmon((Entity)entity)) {
            return;
        }
        try {
            Method m = entity.getClass().getMethod("getModel", new Class[0]);
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString((String)m.invoke((Object)entity, new Object[0])));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isTrainer(EntityLivingBase entity) {
        if (!Enabled) {
            return false;
        }
        String s = EntityList.func_75621_b((Entity)entity);
        if (s == null) {
            return false;
        }
        return s.equals("pixelmon.Trainer");
    }

    public static boolean isBattling(EntityPlayerMP player) {
        if (!Enabled) {
            return false;
        }
        try {
            Class<?> c = Class.forName("com.pixelmonmod.pixelmon.battles.BattleRegistry");
            Method m = c.getMethod("getBattle", EntityPlayer.class);
            return m.invoke(null, player) == null;
        }
        catch (Exception e) {
            LogManager.getLogger().error("canBattle", (Throwable)e);
            return false;
        }
    }

    public static boolean isBattling(EntityLivingBase trainer) {
        if (!Enabled || !PixelmonHelper.isTrainer(trainer)) {
            return false;
        }
        try {
            Field f = trainer.getClass().getField("battleController");
            return f.get(trainer) != null;
        }
        catch (Exception e) {
            LogManager.getLogger().error("canBattle", (Throwable)e);
            return false;
        }
    }

    public static boolean canBattle(EntityPlayerMP player, EntityNPCInterface npc) {
        if (!Enabled || npc.advanced.job != 6 || PixelmonHelper.isBattling(player)) {
            return false;
        }
        try {
            JobSpawner spawner = (JobSpawner)npc.jobInterface;
            if (spawner.isOnCooldown(player.func_70005_c_())) {
                return false;
            }
            Object ob = getPlayerStorage.invoke(PokeballManager, player);
            Method m = ob.getClass().getMethod("countAblePokemon", new Class[0]);
            return (Integer)m.invoke(ob, new Object[0]) != 0;
        }
        catch (Exception e) {
            LogManager.getLogger().error("canBattle", (Throwable)e);
            return false;
        }
    }

    public static EntityTameable pixelmonFromNBT(NBTTagCompound compound, EntityPlayer player) {
        if (!Enabled) {
            return null;
        }
        try {
            Object ob = getPlayerStorage.invoke(PokeballManager, player);
            return (EntityTameable)ob.getClass().getMethod("sendOut", NBTTagCompound.class, World.class).invoke(ob, compound, player);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static NBTTagCompound getPartySlot(int i, EntityPlayer player) {
        if (!Enabled) {
            return null;
        }
        try {
            Object ob = getPlayerStorage.invoke(PokeballManager, player);
            NBTTagCompound[] party = (NBTTagCompound[])ob.getClass().getFields()[0].get(ob);
            return party[i];
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean startBattle(EntityPlayerMP player, EntityLivingBase trainer) {
        if (!Enabled) {
            return false;
        }
        try {
            Object ob = getPlayerStorage.invoke(PokeballManager, player);
            Class<?> c = ob.getClass();
            Method m = c.getMethod("getFirstAblePokemon", World.class);
            Entity pixelmon = (Entity)m.invoke(ob, player.field_70170_p);
            Class<?> cEntity = Class.forName("com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon");
            m = c.getMethod("EntityAlreadyExists", cEntity);
            if (!((Boolean)m.invoke(ob, pixelmon)).booleanValue()) {
                m = cEntity.getMethod("releaseFromPokeball", new Class[0]);
                pixelmon.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, 0.0f);
            }
            c = Class.forName("com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant");
            Object parTrainer = c.getConstructor(trainer.getClass(), EntityPlayer.class, Integer.TYPE).newInstance(trainer, player, 1);
            Object[] pixelmonArray = (Object[])Array.newInstance(cEntity, 1);
            pixelmonArray[0] = pixelmon;
            c = Class.forName("com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant");
            Object parPlayer = c.getConstructor(EntityPlayerMP.class, pixelmonArray.getClass()).newInstance(player, pixelmonArray);
            cEntity = Class.forName("com.pixelmonmod.pixelmon.entities.pixelmon.Entity6CanBattle");
            c = Class.forName("com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant");
            m = cEntity.getMethod("StartBattle", c, c);
            m.invoke((Object)pixelmon, parTrainer, parPlayer);
            return true;
        }
        catch (Exception e) {
            LogManager.getLogger().error("startBattle", (Throwable)e);
            return false;
        }
    }

    public static int countPCPixelmon(EntityPlayerMP player) {
        try {
            Object ob = getPlayerComputerStorage.invoke((Object)player, new Object[0]);
            return (Integer)ob.getClass().getMethod("count", new Class[0]).invoke(ob, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String getAttackName(int id) {
        try {
            Object ob = attackByID.newInstance(id);
            if (ob == null) {
                return null;
            }
            return getAttackName.get(baseAttack.get(ob)) + "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getAttackID(String name) {
        try {
            Object ob = attackByName.newInstance(name);
            if (ob == null) {
                return -1;
            }
            return getAttackName.getInt(baseAttack.get(ob));
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }
}

