/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.constants.AnimationType;
import noppes.npcs.api.constants.EntityType;
import noppes.npcs.api.constants.JobType;
import noppes.npcs.api.constants.ParticleType;
import noppes.npcs.api.constants.PotionEffectType;
import noppes.npcs.api.constants.RoleType;
import noppes.npcs.api.constants.SideType;
import noppes.npcs.api.constants.TacticalType;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.ScriptController;

public class ScriptContainer {
    private static final AnimationType animations = new AnimationType();
    private static final EntityType entities = new EntityType();
    private static final JobType jobs = new JobType();
    private static final SideType sides = new SideType();
    private static final RoleType roles = new RoleType();
    private static final TacticalType tacticalVariantTypes = new TacticalType();
    private static final PotionEffectType potionEffectTypes = new PotionEffectType();
    private static final ParticleType particleTypes = new ParticleType();
    public String fullscript = "";
    public String script = "";
    public Map<Long, String> console = new HashMap<Long, String>();
    public boolean errored = false;
    public List<String> scripts = new ArrayList<String>();
    private List<Integer> unknownFunctions = new ArrayList<Integer>();
    public long lastCreated = 0L;
    private String currentScriptLanguage = null;
    public ScriptEngine engine = null;
    private IScriptHandler handler = null;
    private boolean init = false;

    public ScriptContainer(IScriptHandler handler) {
        this.handler = handler;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.script = compound.func_74779_i("Script");
        this.console = NBTTags.GetLongStringMap(compound.func_150295_c("Console", 10));
        this.scripts = NBTTags.getStringList(compound.func_150295_c("ScriptList", 10));
        this.lastCreated = 0L;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("Script", this.script);
        compound.func_74782_a("Console", (NBTBase)NBTTags.NBTLongStringMap(this.console));
        compound.func_74782_a("ScriptList", (NBTBase)NBTTags.nbtStringList(this.scripts));
        return compound;
    }

    private String getFullCode() {
        if (!this.init) {
            this.fullscript = this.script;
            if (!this.fullscript.isEmpty()) {
                this.fullscript = this.fullscript + "\n";
            }
            for (String loc : this.scripts) {
                String code = ScriptController.Instance.scripts.get(loc);
                if (code == null || code.isEmpty()) continue;
                this.fullscript = this.fullscript + code + "\n";
            }
            this.unknownFunctions = new ArrayList<Integer>();
        }
        return this.fullscript;
    }

    public void run(EnumScriptType type, Event event, IScriptHandler handler) {
        if (this.errored || !this.hasCode() || this.unknownFunctions.contains(type.ordinal())) {
            return;
        }
        this.setEngine(handler.getLanguage());
        if (this.engine == null) {
            return;
        }
        if (ScriptController.Instance.lastLoaded > this.lastCreated) {
            this.lastCreated = ScriptController.Instance.lastLoaded;
            this.init = false;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.engine.getContext().setWriter(pw);
        this.engine.getContext().setErrorWriter(pw);
        try {
            if (!this.init) {
                this.engine.eval(this.getFullCode());
                this.init = true;
            }
            if (this.engine.getFactory().getLanguageName().equals("lua")) {
                Object ob = this.engine.get(type.function);
                if (ob != null) {
                    this.engine.put("event", event);
                    Method m = ob.getClass().getMethod("call", new Class[0]);
                    m.invoke(ob, new Object[0]);
                } else {
                    this.unknownFunctions.add(type.ordinal());
                }
            } else {
                ((Invocable)((Object)this.engine)).invokeFunction(type.function, event);
            }
        }
        catch (NoSuchMethodException e) {
            this.unknownFunctions.add(type.ordinal());
        }
        catch (Exception e) {
            this.errored = true;
            e.printStackTrace(pw);
            NoppesUtilServer.NotifyOPs(handler.noticeString() + " script errored", new Object[0]);
        }
        this.appandConsole(sw.getBuffer().toString().trim());
        pw.close();
    }

    public void appandConsole(String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        this.console.put(System.currentTimeMillis(), message);
    }

    public boolean hasCode() {
        return !this.getFullCode().isEmpty();
    }

    public void setEngine(String scriptLanguage) {
        if (this.currentScriptLanguage != null && this.currentScriptLanguage.equals(scriptLanguage)) {
            return;
        }
        this.engine = ScriptController.Instance.getEngineByName(scriptLanguage);
        if (this.engine == null) {
            this.errored = true;
            return;
        }
        this.engine.put("AnimationType", animations);
        this.engine.put("EntityType", entities);
        this.engine.put("RoleType", roles);
        this.engine.put("JobType", jobs);
        this.engine.put("SideType", sides);
        this.engine.put("TacticalVariantType", tacticalVariantTypes);
        this.engine.put("PotionEffectType", potionEffectTypes);
        this.engine.put("ParticleType", particleTypes);
        this.currentScriptLanguage = scriptLanguage;
        this.init = false;
    }
}

