/*
 * Decompiled with CFR 0.152.
 */
package lellson.roughMobs.events;

import lellson.roughMobs.misc.RoughConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public abstract class DefaultEvents<T> {
    Class<T> t;
    private boolean first = false;

    public DefaultEvents(Class<T> t) {
        this.t = t;
        if (RoughConfig.outputToConsole) {
            FMLLog.info((String)"Intialize %s Events...", (Object[])new Object[]{t.getSimpleName()});
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void eventAttack(LivingAttackEvent event) {
        Entity attacker = event.getSource().func_76364_f();
        if (attacker != null && this.isInstance(attacker) && event.getEntityLiving() instanceof EntityPlayer) {
            if (!this.first) {
                this.onAttack(attacker, (EntityPlayer)event.getEntityLiving());
                this.first = true;
            } else {
                this.first = false;
            }
        }
    }

    protected abstract void onAttack(T var1, EntityPlayer var2);

    @SubscribeEvent
    public void eventDefend(AttackEntityEvent event) {
        if (this.isInstance(event.getTarget())) {
            this.onDefend(event.getEntityPlayer(), event.getTarget());
        }
    }

    protected abstract void onDefend(EntityPlayer var1, T var2);

    @SubscribeEvent
    public void eventUpdate(LivingEvent.LivingUpdateEvent event) {
        if (this.isInstance(event.getEntity())) {
            this.onUpdate(event.getEntity());
        }
    }

    protected abstract void onUpdate(T var1);

    @SubscribeEvent(priority=EventPriority.LOW)
    public void eventDeath(LivingDeathEvent event) {
        if (this.isInstance(event.getEntity())) {
            this.onDeath(event.getEntity(), event.getSource());
        }
    }

    protected abstract void onDeath(T var1, DamageSource var2);

    @SubscribeEvent
    public void eventJoinWorld(EntityJoinWorldEvent event) {
        if (this.isInstance(event.getEntity())) {
            this.onWorldJoin(event.getWorld(), event.getEntity());
        }
    }

    protected abstract void onWorldJoin(World var1, T var2);

    @SubscribeEvent
    public void eventConstructing(EntityEvent.EntityConstructing event) {
        if (this.isInstance(event.getEntity())) {
            this.onCreated(event.getEntity());
        }
    }

    protected abstract void onCreated(T var1);

    private boolean isInstance(Entity entity) {
        if (this.isEntityInOption(entity, RoughConfig.notAffectedEntities)) {
            return false;
        }
        return this.t.isAssignableFrom(entity.getClass());
    }

    protected boolean isEntityInOption(Entity entity, String[] option) {
        for (String name : option) {
            if (!EntityList.func_180123_a((Entity)entity, (String)name)) continue;
            return true;
        }
        return false;
    }
}

