/*
 * Decompiled with CFR 0.152.
 */
package lellson.roughMobs.events;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lellson.roughMobs.RoughMobs;
import lellson.roughMobs.events.DefaultEvents;
import lellson.roughMobs.misc.RoughConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class GeneralEvents
extends DefaultEvents<Entity> {
    public GeneralEvents() {
        super(Entity.class);
        String[] mobs;
        for (String mob : mobs = RoughConfig.mobSpawning) {
            String[] strings = mob.split(",");
            boolean flag = true;
            if (strings.length >= 5) {
                Class entityClass = (Class)EntityList.field_75625_b.get(strings[0]);
                EnumCreatureType type = GeneralEvents.getType(strings[4]);
                if (strings.length == 5) {
                    if (entityClass != null && type != null) {
                        try {
                            this.addSpawnEntryAll(entityClass, Integer.parseInt(strings[1]), Integer.parseInt(strings[2]), Integer.parseInt(strings[3]), type);
                        }
                        catch (Exception e) {
                            flag = false;
                            e.printStackTrace();
                        }
                    } else {
                        flag = false;
                    }
                } else {
                    Biome biome = Biome.func_150568_d((int)Integer.parseInt(strings[5]));
                    if (entityClass != null && biome != null && type != null) {
                        try {
                            this.addSpawnEntry(entityClass, Integer.parseInt(strings[1]), Integer.parseInt(strings[2]), Integer.parseInt(strings[3]), type, biome);
                        }
                        catch (Exception e) {
                            flag = false;
                            e.printStackTrace();
                        }
                    } else {
                        flag = false;
                    }
                }
            } else if (strings.length > 0) {
                flag = false;
            } else {
                FMLLog.bigWarning((String)"RoughMobs: Invalid mob spawn entry! (%s)", (Object[])new Object[]{mob});
            }
            if (flag) continue;
            FMLLog.bigWarning((String)"RoughMobs: Couldn't add '%s' to the mob spawning list.", (Object[])new Object[]{strings[0]});
        }
    }

    private void addSpawnEntry(Class entityClass, int weight, int min, int max, EnumCreatureType type, Biome ... biomes) {
        EntityRegistry.addSpawn((Class)entityClass, (int)weight, (int)min, (int)max, (EnumCreatureType)type, (Biome[])biomes);
    }

    private void addSpawnEntryAll(Class entityClass, int weight, int min, int max, EnumCreatureType type) {
        ArrayList<Biome> list = new ArrayList<Biome>();
        for (Biome biome : Biome.field_185377_q) {
            if (biome == null) continue;
            list.add(biome);
        }
        this.addSpawnEntry(entityClass, weight, min, max, type, list.toArray(new Biome[list.size()]));
    }

    @SubscribeEvent
    public void reduceSpawnRates(LivingSpawnEvent.CheckSpawn event) {
        String[] entries = RoughConfig.reduceSpawnRates;
        Random rnd = event.getWorld().field_73012_v;
        for (String entry : entries) {
            String[] strings = entry.split(",");
            if (!EntityList.func_180123_a((Entity)event.getEntity(), (String)strings[0])) continue;
            if (strings.length == 2) {
                try {
                    if (!(rnd.nextFloat() <= Float.valueOf(strings[1]).floatValue() * 0.01f)) continue;
                    event.setResult(Event.Result.DENY);
                }
                catch (NumberFormatException e) {
                    FMLLog.bigWarning((String)"RoughMobs: %s is not a valid number", (Object[])new Object[]{strings[1]});
                }
                continue;
            }
            if (strings.length <= 2) continue;
            try {
                if (!(rnd.nextFloat() <= Float.valueOf(strings[1]).floatValue() * 0.01f) || Integer.valueOf(strings[2]) != event.getEntity().field_71093_bK) continue;
                event.setResult(Event.Result.DENY);
            }
            catch (NumberFormatException e) {
                FMLLog.bigWarning((String)"RoughMobs: %1$s or %2$s are not valid numbers", (Object[])new Object[]{strings[1], strings[2]});
            }
        }
    }

    @Override
    protected void onAttack(Entity attacker, EntityPlayer target) {
    }

    @Override
    protected void onDefend(EntityPlayer attacker, Entity target) {
    }

    @Override
    protected void onUpdate(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase entityLiv = (EntityLivingBase)entity;
            if (this.isEntityInOption(entity, RoughConfig.mobsAttackEachOther)) {
                double range = entityLiv.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
                List list = entityLiv.field_70170_p.func_72872_a(EntityPlayer.class, entityLiv.func_174813_aQ().func_72314_b(range, range, range));
                if (!list.isEmpty() && !((EntityPlayer)list.get(0)).func_184812_l_()) {
                    entityLiv.func_70604_c((EntityLivingBase)list.get(0));
                } else if (RoughConfig.mobsAttackPassives) {
                    List villagerList = entityLiv.field_70170_p.func_72872_a(EntityVillager.class, entityLiv.func_174813_aQ().func_72314_b(range, range, range));
                    List animalList = entityLiv.field_70170_p.func_72872_a(EntityAnimal.class, entityLiv.func_174813_aQ().func_72314_b(range, range, range));
                    if (!villagerList.isEmpty()) {
                        entityLiv.func_70604_c((EntityLivingBase)villagerList.get(0));
                    } else if (!animalList.isEmpty()) {
                        entityLiv.func_70604_c((EntityLivingBase)animalList.get(0));
                    }
                }
            }
        }
        if (this.isEntityInOption(entity, RoughConfig.mobsImmuneToFire) && entity.func_70027_ad()) {
            entity.func_70066_B();
        }
    }

    @Override
    protected void onDeath(Entity entity, DamageSource source) {
    }

    @Override
    protected void onWorldJoin(World world, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            IAttributeInstance attribute;
            float value;
            NBTTagCompound nbt = entity.getEntityData();
            if (nbt != null && !nbt.func_74767_n("healthBoosted") && !world.field_72995_K) {
                value = this.getConfigValueFloat((EntityLivingBase)entity, RoughConfig.healthBoost) / 100.0f;
                if (value > 0.0f) {
                    attribute = ((EntityLivingBase)entity).func_110148_a(SharedMonsterAttributes.field_111267_a);
                    RoughMobs.applyModifier((EntityLivingBase)entity, SharedMonsterAttributes.field_111267_a, "HealthBoost", attribute.func_111125_b() * (double)value);
                }
                nbt.func_74757_a("healthBoosted", true);
            }
            if (nbt != null && !nbt.func_74767_n("followRangeBoosted") && !world.field_72995_K) {
                int value2 = this.getConfigValueInt((EntityLivingBase)entity, RoughConfig.followRangeBoost);
                if (value2 > 0) {
                    if (value2 > 2000) {
                        value2 = 2000;
                    }
                    RoughMobs.applyModifier((EntityLivingBase)entity, SharedMonsterAttributes.field_111265_b, "FollowRangeBoost", value2);
                }
                nbt.func_74757_a("followRangeBoosted", true);
            }
            if (nbt != null && !nbt.func_74767_n("speedBoosted") && !world.field_72995_K) {
                value = this.getConfigValueFloat((EntityLivingBase)entity, RoughConfig.speedBoost) / 100.0f;
                if (value > 0.0f) {
                    attribute = ((EntityLivingBase)entity).func_110148_a(SharedMonsterAttributes.field_111263_d);
                    RoughMobs.applyModifier((EntityLivingBase)entity, SharedMonsterAttributes.field_111263_d, "SpeedBoost", attribute.func_111125_b() * (double)value);
                }
                nbt.func_74757_a("speedBoosted", true);
            }
            if (nbt != null && !nbt.func_74767_n("knockbackBoosted") && !world.field_72995_K) {
                value = this.getConfigValueFloat((EntityLivingBase)entity, RoughConfig.knockbackBoost);
                if (value > 0.0f) {
                    if (value > 1.0f) {
                        value = 1.0f;
                    }
                    RoughMobs.applyModifier((EntityLivingBase)entity, SharedMonsterAttributes.field_111266_c, "KnockbackBoost", value);
                }
                nbt.func_74757_a("knockbackBoosted", true);
            }
            if (nbt != null && !nbt.func_74767_n("damageBoosted") && !world.field_72995_K) {
                int value3 = this.getConfigValueInt((EntityLivingBase)entity, RoughConfig.damageBoost);
                if (value3 > 0) {
                    RoughMobs.applyModifier((EntityLivingBase)entity, SharedMonsterAttributes.field_111264_e, "DamageBoost", value3);
                }
                nbt.func_74757_a("damageBoosted", true);
            }
        }
        if (entity instanceof EntitySnowball && ((EntitySnowball)entity).field_71093_bK == -1 && RoughConfig.snowballMeltInNether) {
            entity.func_70106_y();
            RoughMobs.spawnParticle(entity, EnumParticleTypes.SMOKE_NORMAL, 4);
            entity.field_70170_p.func_184134_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187659_cY, SoundCategory.NEUTRAL, 0.5f, 1.0f, false);
        }
    }

    private int getConfigValueInt(EntityLivingBase entity, String[] strings) {
        for (String string : strings) {
            String[] pieces = string.split(",");
            if (!EntityList.func_180123_a((Entity)entity, (String)pieces[0])) continue;
            int value = Integer.parseInt(pieces[1]);
            if (pieces.length == 2) {
                return value;
            }
            if (pieces.length != 3) continue;
            return entity.field_71093_bK == Integer.parseInt(pieces[2]) ? value : 0;
        }
        return 0;
    }

    private float getConfigValueFloat(EntityLivingBase entity, String[] strings) {
        for (String string : strings) {
            String[] pieces = string.split(",");
            if (!EntityList.func_180123_a((Entity)entity, (String)pieces[0])) continue;
            float value = Float.parseFloat(pieces[1]);
            if (pieces.length == 2) {
                return value;
            }
            if (pieces.length != 3) continue;
            return entity.field_71093_bK == Integer.parseInt(pieces[2]) ? value : 0.0f;
        }
        return 0.0f;
    }

    private static EnumCreatureType getType(String string) {
        if (string.equals("MOB")) {
            return EnumCreatureType.MONSTER;
        }
        if (string.equals("ANIMAL")) {
            return EnumCreatureType.CREATURE;
        }
        if (string.equals("WATER")) {
            return EnumCreatureType.WATER_CREATURE;
        }
        return EnumCreatureType.MONSTER;
    }

    @Override
    protected void onCreated(Entity entity) {
    }
}

