/*
 * Decompiled with CFR 0.152.
 */
package lellson.roughMobs.events;

import java.util.List;
import java.util.Random;
import lellson.roughMobs.RoughMobs;
import lellson.roughMobs.events.DefaultEvents;
import lellson.roughMobs.misc.RoughConfig;
import lellson.roughMobs.misc.RoughEquipment;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.HorseType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class SkeletonEvents
extends DefaultEvents<EntitySkeleton> {
    public SkeletonEvents() {
        super(EntitySkeleton.class);
    }

    @Override
    protected void onAttack(EntitySkeleton attacker, EntityPlayer target) {
        if (this.isBossSkeleton((EntityLivingBase)attacker)) {
            target.field_70170_p.func_72876_a((Entity)target, target.field_70165_t, target.field_70163_u, target.field_70161_v, RoughConfig.skeletonBossExplosion, true);
        }
    }

    @Override
    protected void onDefend(EntityPlayer attacker, EntitySkeleton target) {
    }

    @Override
    protected void onUpdate(EntitySkeleton entity) {
        List list = entity.func_130014_f_().func_72872_a(EntityPlayer.class, entity.func_174813_aQ().func_72314_b(5.0, 0.0, 5.0));
        ItemStack mainHand = entity.func_184582_a(EntityEquipmentSlot.MAINHAND);
        ItemStack offHand = entity.func_184582_a(EntityEquipmentSlot.OFFHAND);
        if (mainHand != null && offHand != null && RoughConfig.skeletonSwitchWeapons) {
            if (list.isEmpty()) {
                if ((mainHand.func_77973_b() instanceof ItemSword || mainHand.func_77973_b() instanceof ItemTool) && offHand.func_77973_b() instanceof ItemBow) {
                    entity.func_184201_a(EntityEquipmentSlot.MAINHAND, offHand);
                    entity.func_184201_a(EntityEquipmentSlot.OFFHAND, mainHand);
                }
            } else if ((offHand.func_77973_b() instanceof ItemSword || offHand.func_77973_b() instanceof ItemTool) && mainHand.func_77973_b() instanceof ItemBow) {
                entity.func_184201_a(EntityEquipmentSlot.MAINHAND, offHand);
                entity.func_184201_a(EntityEquipmentSlot.OFFHAND, mainHand);
            }
        }
    }

    @Override
    protected void onDeath(EntitySkeleton entity, DamageSource source) {
        if (this.isBossSkeleton((EntityLivingBase)entity) && RoughConfig.skeletonBossShouldDrop && !entity.field_70170_p.field_72995_K) {
            Random rnd = entity.func_130014_f_().field_73012_v;
            EntityEquipmentSlot slot = EntityEquipmentSlot.values()[rnd.nextInt(EntityEquipmentSlot.values().length)];
            ItemStack item = entity.func_184582_a(slot);
            if (item != null) {
                EntityItem entityItem = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u + (double)0.1f, entity.field_70161_v, item);
                entity.field_70170_p.func_72838_d((Entity)entityItem);
            }
            entity.func_145779_a(Items.field_151103_aS, rnd.nextInt(8) + 8);
            entity.func_145779_a(Items.field_151032_g, rnd.nextInt(8) + 8);
        }
    }

    @Override
    protected void onWorldJoin(World world, EntitySkeleton entity) {
        NBTTagCompound nbt = entity.getEntityData();
        Random rnd = world.field_73012_v;
        if (nbt != null && !nbt.func_74767_n("equipAdded") && !world.field_72995_K) {
            if (RoughConfig.skeletonBossChance > 0 && rnd.nextInt(RoughConfig.skeletonBossChance) == 0 && entity.field_71093_bK == 0) {
                this.setBossSkeleton(entity, rnd);
                return;
            }
            if (entity.func_189771_df() != SkeletonType.WITHER && entity.field_71093_bK == -1 && RoughConfig.skeletonToWither) {
                entity.func_189768_a(SkeletonType.WITHER);
            }
            if (this.isAllowedType(entity.func_189771_df())) {
                this.addEquip(entity);
            }
            if (RoughConfig.skeletonHorseChance > 0 && entity.field_70170_p.func_175678_i(entity.func_180425_c()) && rnd.nextInt(RoughConfig.skeletonHorseChance) == 0) {
                this.setHorse(world, entity);
            }
            nbt.func_74757_a("equipAdded", true);
        }
        if (RoughConfig.skeletonBowCooldown != 20) {
            entity.field_70714_bg.func_85156_a((EntityAIBase)ReflectionHelper.getPrivateValue(EntitySkeleton.class, (Object)entity, (String[])new String[]{"aiArrowAttack", "field_85037_d"}));
            entity.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackRangedBow(entity, 1.0, RoughConfig.skeletonBowCooldown, 15.0f));
        }
    }

    private void setHorse(World world, EntitySkeleton entity) {
        EntityHorse horse = new EntityHorse(entity.field_70170_p);
        horse.func_184778_a(HorseType.SKELETON);
        horse.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        horse.field_70172_ad = 60;
        horse.func_110163_bv();
        horse.func_110234_j(true);
        horse.func_70873_a(0);
        entity.field_70170_p.func_72838_d((Entity)horse);
        entity.func_184220_m((Entity)horse);
    }

    private boolean isBossSkeleton(EntityLivingBase entity) {
        return entity instanceof EntitySkeleton && entity.getEntityData().func_74767_n("isBossZombie");
    }

    private void setBossSkeleton(EntitySkeleton entity, Random rnd) {
        entity.getEntityData().func_74757_a("isBossZombie", true);
        String[] names = new String[]{"Stallord", "Skeletron", "Krosis", "Wolnir", "Skeleton King"};
        entity.func_96094_a(names[rnd.nextInt(names.length)]);
        RoughMobs.applyModifier((EntityLivingBase)entity, SharedMonsterAttributes.field_111267_a, "ExtraHealthBoss", 80.0);
        RoughMobs.applyModifier((EntityLivingBase)entity, SharedMonsterAttributes.field_111266_c, "NoKnockbackBoss", 1.0);
        entity.func_70690_d(new PotionEffect(MobEffects.field_76424_c, Integer.MAX_VALUE, 0));
        entity.func_70690_d(new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, 0));
        if (entity.field_70170_p.func_175678_i(entity.func_180425_c())) {
            this.setHorse(entity.field_70170_p, entity);
        }
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack item;
            if (slot.func_188453_a() == EntityEquipmentSlot.Type.ARMOR && (item = RoughEquipment.getArmorItemForSlotBoss(rnd, slot)) != null && item.func_77973_b() != null) {
                item.func_77966_a(RoughEquipment.getRandomEnchantment(rnd, item.func_77973_b()), rnd.nextInt(3) + 1);
                entity.func_184201_a(slot, item);
            }
            if (slot.func_188453_a() == EntityEquipmentSlot.Type.HAND) {
                if (slot == EntityEquipmentSlot.MAINHAND) {
                    item = RoughEquipment.getRandomBossWeapon(rnd);
                    if (item != null && item.func_77973_b() != null) {
                        item.func_77966_a(RoughEquipment.getRandomEnchantment(rnd, item.func_77973_b()), rnd.nextInt(3) + 1);
                        entity.func_184201_a(slot, item);
                    }
                } else {
                    item = new ItemStack((Item)Items.field_151031_f);
                    if (item != null && item.func_77973_b() != null) {
                        item.func_77966_a(RoughEquipment.getRandomEnchantment(rnd, item.func_77973_b()), rnd.nextInt(3) + 1);
                        entity.func_184201_a(slot, item);
                    }
                }
            }
            entity.func_184642_a(slot, 0.0f);
        }
    }

    private boolean isAllowedType(SkeletonType skeletonType) {
        for (String type : RoughConfig.skeletonType) {
            if (this.getTypeForInt(Integer.parseInt(type)) != skeletonType) continue;
            return true;
        }
        return false;
    }

    private SkeletonType getTypeForInt(int type) {
        switch (type) {
            case 1: {
                return SkeletonType.WITHER;
            }
            case 2: {
                return SkeletonType.STRAY;
            }
        }
        return SkeletonType.NORMAL;
    }

    private void addEquip(EntitySkeleton entity) {
        Random rnd = entity.field_70170_p.field_73012_v;
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            Enchantment enchant;
            ItemStack item;
            if (slot.func_188453_a() == EntityEquipmentSlot.Type.ARMOR && RoughConfig.skeletonArmor > 0 && entity.func_184582_a(slot) == null && rnd.nextInt(RoughConfig.skeletonArmor) == 0 && (item = RoughEquipment.getArmorItemForSlot(rnd, slot)) != null && item.func_77973_b() != null) {
                enchant = RoughEquipment.getRandomEnchantment(rnd, item.func_77973_b());
                if (RoughConfig.skeletonEnchantChance > 0 && enchant != null && rnd.nextInt(RoughConfig.skeletonEnchantChance) == 0) {
                    item.func_77966_a(enchant, rnd.nextInt(3) + 1);
                }
                if (item != null) {
                    entity.func_184201_a(slot, item);
                }
                entity.func_184642_a(slot, (float)RoughConfig.skeletonDropChance * 0.01f);
            }
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.HAND || !RoughConfig.skeletonWeapons || (item = slot == EntityEquipmentSlot.OFFHAND ? RoughEquipment.getRandomWeapon(rnd) : new ItemStack((Item)Items.field_151031_f)) == null || item.func_77973_b() == null) continue;
            enchant = RoughEquipment.getRandomEnchantment(rnd, item.func_77973_b());
            if (RoughConfig.skeletonEnchantChance > 0 && enchant != null && rnd.nextInt(RoughConfig.skeletonEnchantChance) == 0) {
                item.func_77966_a(enchant, rnd.nextInt(3) + 1);
            }
            entity.func_184201_a(slot, item);
            entity.func_184642_a(slot, (float)RoughConfig.skeletonDropChance * 0.01f);
        }
    }

    @Override
    protected void onCreated(EntitySkeleton entity) {
    }
}

