/*
 * Decompiled with CFR 0.152.
 */
package lellson.roughMobs.events;

import java.util.Random;
import lellson.roughMobs.events.DefaultEvents;
import lellson.roughMobs.misc.RoughConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class SpiderEvents
extends DefaultEvents<EntitySpider> {
    public SpiderEvents() {
        super(EntitySpider.class);
    }

    @Override
    protected void onAttack(EntitySpider attacker, EntityPlayer target) {
        if (RoughConfig.spiderSlowdown > 0 && attacker.field_70170_p.field_73012_v.nextInt(RoughConfig.spiderSlowdown) == 0) {
            PotionEffect active = target.func_70660_b(MobEffects.field_76421_d);
            int amplifier = active == null ? 0 : (active.func_76458_c() < 4 ? active.func_76458_c() + 1 : 4);
            target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, amplifier));
            if (active != null && active.func_76458_c() >= 4 && target.field_70170_p.func_180495_p(target.func_180425_c()).func_177230_c() != Blocks.field_150321_G) {
                target.field_70170_p.func_175656_a(target.func_180425_c(), Blocks.field_150321_G.func_176223_P());
                target.func_184596_c(MobEffects.field_76421_d);
            }
        }
    }

    @Override
    protected void onDefend(EntityPlayer attacker, EntitySpider target) {
    }

    @Override
    protected void onUpdate(EntitySpider entity) {
        if (RoughConfig.spiderNoFallDamage) {
            entity.field_70143_R = 0.0f;
        }
    }

    @Override
    protected void onDeath(EntitySpider entity, DamageSource source) {
    }

    @Override
    protected void onWorldJoin(World world, EntitySpider entity) {
        NBTTagCompound nbt = entity.getEntityData();
        Random rnd = world.field_73012_v;
        if (!(nbt.func_74767_n("roughMobsExtras") || world.field_72995_K || entity instanceof EntityCaveSpider || RoughConfig.spiderRiderChance <= 0 || RoughConfig.spiderRiderEntities.length <= 0)) {
            Entity rider;
            if (rnd.nextInt(RoughConfig.spiderRiderChance) == 0 && (rider = this.getRandomRider(rnd, world)) != null) {
                rider.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                rider.field_70172_ad = 60;
                entity.field_70170_p.func_72838_d(rider);
                rider.func_184220_m((Entity)entity);
            }
            nbt.func_74757_a("roughMobsExtras", true);
        }
    }

    private Entity getRandomRider(Random rnd, World world) {
        String name = RoughConfig.spiderRiderEntities[rnd.nextInt(RoughConfig.spiderRiderEntities.length)];
        Entity entity = EntityList.func_75620_a((String)name, (World)world);
        if (entity == null) {
            System.err.println("The entity '" + name + "' is not a valid entity!");
        }
        return entity;
    }

    @Override
    protected void onCreated(EntitySpider entity) {
    }
}

