/*
 * Decompiled with CFR 0.152.
 */
package lellson.roughMobs.events;

import java.util.List;
import java.util.Random;
import lellson.roughMobs.RoughMobs;
import lellson.roughMobs.events.DefaultEvents;
import lellson.roughMobs.misc.RoughConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public class WitchEvents
extends DefaultEvents<EntityWitch> {
    public WitchEvents() {
        super(EntityWitch.class);
    }

    @Override
    protected void onAttack(EntityWitch attacker, EntityPlayer target) {
    }

    @Override
    protected void onDefend(EntityPlayer attacker, EntityWitch target) {
    }

    @Override
    protected void onUpdate(EntityWitch entity) {
        if (RoughConfig.witchBoost != 0) {
            List list = entity.field_70170_p.func_72872_a(EntityLivingBase.class, entity.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0));
            Random rnd = entity.field_70170_p.field_73012_v;
            for (EntityLivingBase mob : list) {
                Potion regen;
                if (this.isBlacklisted(mob) || !(mob instanceof EntityMob) && !(mob instanceof EntitySlime) && (RoughConfig.witchBoost != 2 || mob instanceof EntityPlayer)) continue;
                Potion potion = regen = mob.func_70662_br() ? MobEffects.field_76436_u : MobEffects.field_76428_l;
                if (mob.func_70660_b(regen) != null || mob.func_70660_b(MobEffects.field_76424_c) != null || mob.func_70660_b(MobEffects.field_76420_g) != null) {
                    RoughMobs.spawnParticle((Entity)mob, EnumParticleTypes.SPELL_WITCH, 0.5f, 1);
                    continue;
                }
                switch (rnd.nextInt(3)) {
                    case 0: {
                        mob.func_70690_d(new PotionEffect(regen, 400, 0));
                        break;
                    }
                    case 1: {
                        mob.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 400, 0));
                        break;
                    }
                    case 2: {
                        mob.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 400, 0));
                    }
                }
            }
        }
    }

    private boolean isBlacklisted(EntityLivingBase mob) {
        for (String name : RoughConfig.witchBoostBlacklist) {
            if (!EntityList.func_180123_a((Entity)mob, (String)name)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void onDeath(EntityWitch entity, DamageSource source) {
        if (RoughConfig.witchBatsOnDeath) {
            Random rnd = entity.field_70170_p.field_73012_v;
            int amount = rnd.nextInt(5) + 3;
            for (int i = 0; i < amount; ++i) {
                EntityBat bat = new EntityBat(entity.field_70170_p);
                int x = rnd.nextInt(3) - rnd.nextInt(3);
                int z = rnd.nextInt(3) - rnd.nextInt(3);
                bat.func_70107_b(entity.field_70165_t + (double)x, entity.field_70163_u, entity.field_70161_v + (double)z);
                if (entity.field_70170_p.field_72995_K) continue;
                entity.field_70170_p.func_72838_d((Entity)bat);
            }
        }
    }

    @Override
    protected void onWorldJoin(World world, EntityWitch entity) {
    }

    @Override
    protected void onCreated(EntityWitch entity) {
    }
}

