/*
 * Decompiled with CFR 0.152.
 */
package lellson.roughMobs.events;

import java.util.Random;
import lellson.roughMobs.RoughMobs;
import lellson.roughMobs.events.DefaultEvents;
import lellson.roughMobs.misc.RoughConfig;
import lellson.roughMobs.misc.RoughEquipment;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.HorseType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ZombieEvents
extends DefaultEvents<EntityZombie> {
    public ZombieEvents() {
        super(EntityZombie.class);
    }

    @Override
    protected void onAttack(EntityZombie attacker, EntityPlayer target) {
        if (RoughConfig.zombieApplyHunger && !attacker.field_70170_p.field_72995_K) {
            PotionEffect active = target.func_70660_b(MobEffects.field_76438_s);
            int amplifier = active == null ? 0 : (active.func_76458_c() < 3 ? active.func_76458_c() + 1 : 3);
            target.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 200, amplifier));
        }
    }

    @Override
    protected void onDefend(EntityPlayer attacker, EntityZombie target) {
        Random rnd = target.field_70170_p.field_73012_v;
        if (RoughConfig.zombieBossBabyChance > 0 && this.isBossZombie(target) && rnd.nextInt(RoughConfig.zombieBossBabyChance) == 0) {
            if (target instanceof EntityPigZombie) {
                EntityPigZombie entity = new EntityPigZombie(target.field_70170_p);
                entity.func_82227_f(true);
                entity.func_70107_b(target.field_70165_t + (double)rnd.nextInt(3) - (double)rnd.nextInt(3), target.field_70163_u, target.field_70161_v + (double)rnd.nextInt(3) - (double)rnd.nextInt(3));
                target.field_70170_p.func_72838_d((Entity)entity);
            } else {
                EntityZombie entity = new EntityZombie(target.field_70170_p);
                entity.func_82227_f(true);
                entity.func_70107_b(target.field_70165_t + (double)rnd.nextInt(3) - (double)rnd.nextInt(3), target.field_70163_u, target.field_70161_v + (double)rnd.nextInt(3) - (double)rnd.nextInt(3));
                target.field_70170_p.func_72838_d((Entity)entity);
            }
        }
    }

    @Override
    protected void onUpdate(EntityZombie entity) {
        if (entity.field_70170_p.func_72935_r() && !entity.field_70170_p.field_72995_K && entity.func_70631_g_() && RoughConfig.zombieBabyBurn && !this.isEntityInOption((Entity)entity, RoughConfig.mobsImmuneToFire)) {
            BlockPos blockpos;
            float f = entity.func_70013_c(1.0f);
            BlockPos blockPos = blockpos = entity.func_184187_bx() instanceof EntityBoat ? new BlockPos(entity.field_70165_t, (double)Math.round(entity.field_70163_u), entity.field_70161_v).func_177984_a() : new BlockPos(entity.field_70165_t, (double)Math.round(entity.field_70163_u), entity.field_70161_v);
            if (f > 0.5f && entity.field_70170_p.field_73012_v.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && entity.field_70170_p.func_175678_i(blockpos)) {
                boolean flag = true;
                ItemStack itemstack = entity.func_184582_a(EntityEquipmentSlot.HEAD);
                if (itemstack != null) {
                    if (itemstack.func_77984_f()) {
                        itemstack.func_77964_b(itemstack.func_77952_i() + entity.field_70170_p.field_73012_v.nextInt(2));
                        if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                            entity.func_70669_a(itemstack);
                            entity.func_184201_a(EntityEquipmentSlot.HEAD, (ItemStack)null);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    entity.func_70015_d(8);
                }
            }
        }
        if (ZombieEvents.canDestroy(entity.field_70170_p.func_180495_p(entity.func_180425_c()).func_177230_c())) {
            entity.field_70170_p.func_175655_b(entity.func_180425_c(), true);
        }
    }

    public static boolean canDestroy(Block block) {
        for (String blockId : RoughConfig.zombieBlocks) {
            if (Block.field_149771_c.func_82594_a((Object)new ResourceLocation(blockId)) != block) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void onDeath(EntityZombie entity, DamageSource source) {
        if (this.isBossZombie(entity) && RoughConfig.zombieBossShouldDrop && !entity.field_70170_p.field_72995_K) {
            Random rnd = entity.func_130014_f_().field_73012_v;
            EntityEquipmentSlot slot = EntityEquipmentSlot.values()[rnd.nextInt(EntityEquipmentSlot.values().length)];
            ItemStack item = entity.func_184582_a(slot);
            if (item != null) {
                EntityItem entityItem = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u + (double)0.1f, entity.field_70161_v, item);
                entity.field_70170_p.func_72838_d((Entity)entityItem);
            }
            entity.func_145779_a(Items.field_151078_bh, rnd.nextInt(8) + 8);
        }
    }

    @Override
    protected void onWorldJoin(World world, EntityZombie entity) {
        NBTTagCompound nbt = entity.getEntityData();
        if (!nbt.func_74767_n("roughMobsExtrasApplied") && !world.field_72995_K) {
            nbt.func_74757_a("roughMobsExtrasApplied", true);
            Random rnd = world.field_73012_v;
            if (RoughConfig.zombieBossChance > 0 && rnd.nextInt(RoughConfig.zombieBossChance) == 0 && !entity.func_70631_g_()) {
                this.setBossZombie(entity, rnd);
                return;
            }
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                ItemStack item;
                boolean flag = false;
                if (slot.func_188453_a() == EntityEquipmentSlot.Type.ARMOR) {
                    flag = RoughConfig.zombieArmorChance > 0 && rnd.nextInt(RoughConfig.zombieArmorChance) == 0;
                } else {
                    boolean bl = flag = RoughConfig.zombieWeaponChance > 0 && rnd.nextInt(RoughConfig.zombieWeaponChance) == 0;
                }
                if (!flag || entity.func_184582_a(slot) != null) continue;
                ItemStack itemStack = item = slot.func_188453_a() == EntityEquipmentSlot.Type.ARMOR ? RoughEquipment.getArmorItemForSlot(rnd, slot) : RoughEquipment.getRandomWeapon(rnd);
                if (item == null || item.func_77973_b() == null) continue;
                Enchantment enchant = RoughEquipment.getRandomEnchantment(rnd, item.func_77973_b());
                if (RoughConfig.zombieEnchantChance > 0 && rnd.nextInt(RoughConfig.zombieEnchantChance) == 0) {
                    item.func_77966_a(enchant, rnd.nextInt(3) + 1);
                }
                entity.func_184201_a(slot, item);
                entity.func_184642_a(slot, RoughConfig.zombieDropChance * 0.01f);
            }
            if (RoughConfig.zombieHorseChance > 0 && entity.field_70170_p.func_175678_i(entity.func_180425_c()) && rnd.nextInt(RoughConfig.zombieHorseChance) == 0 && !entity.func_70631_g_() && !(entity instanceof EntityPigZombie)) {
                this.setHorse(world, entity);
            }
        }
    }

    private void setHorse(World world, EntityZombie entity) {
        EntityHorse horse = new EntityHorse(world);
        horse.func_184778_a(HorseType.ZOMBIE);
        horse.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        horse.field_70172_ad = 60;
        horse.func_110163_bv();
        horse.func_110234_j(true);
        horse.func_70873_a(0);
        world.func_72838_d((Entity)horse);
        entity.func_184220_m((Entity)horse);
    }

    private void setBossZombie(EntityZombie entity, Random rnd) {
        String[] names = new String[]{"Zombie King", "Flesh King", "Dr. Zomboss", "Azog"};
        entity.func_96094_a(names[rnd.nextInt(names.length)]);
        entity.func_146070_a(true);
        entity.getEntityData().func_74757_a("isBossZombie", true);
        RoughMobs.applyModifier((EntityLivingBase)entity, SharedMonsterAttributes.field_111267_a, "ExtraHealthBoss", 80.0);
        RoughMobs.applyModifier((EntityLivingBase)entity, SharedMonsterAttributes.field_111266_c, "NoKnockbackBoss", 1.0);
        entity.func_70690_d(new PotionEffect(MobEffects.field_76424_c, Integer.MAX_VALUE, 0));
        entity.func_70690_d(new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, 0));
        if (entity.field_70170_p.func_175678_i(entity.func_180425_c())) {
            this.setHorse(entity.field_70170_p, entity);
        }
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack item;
            if (slot.func_188453_a() == EntityEquipmentSlot.Type.ARMOR && (item = RoughEquipment.getArmorItemForSlotBoss(rnd, slot)) != null && item.func_77973_b() != null) {
                item.func_77966_a(RoughEquipment.getRandomEnchantment(rnd, item.func_77973_b()), rnd.nextInt(3) + 1);
                entity.func_184201_a(slot, item);
            }
            if (slot.func_188453_a() == EntityEquipmentSlot.Type.HAND) {
                if (slot == EntityEquipmentSlot.MAINHAND) {
                    item = RoughEquipment.getRandomBossWeapon(rnd);
                    if (item != null && item.func_77973_b() != null) {
                        item.func_77966_a(RoughEquipment.getRandomEnchantment(rnd, item.func_77973_b()), rnd.nextInt(3) + 1);
                        entity.func_184201_a(slot, item);
                    }
                } else {
                    item = new ItemStack((Item)Items.field_151031_f);
                    if (item != null && item.func_77973_b() != null) {
                        item.func_77966_a(RoughEquipment.getRandomEnchantment(rnd, item.func_77973_b()), rnd.nextInt(3) + 1);
                        entity.func_184201_a(slot, item);
                    }
                }
            }
            entity.func_184642_a(slot, 0.0f);
        }
    }

    private boolean isBossZombie(EntityZombie entity) {
        return entity.getEntityData().func_74767_n("isBossZombie");
    }

    @Override
    protected void onCreated(EntityZombie entity) {
    }
}

