/*
 * Decompiled with CFR 0.152.
 */
package lellson.roughMobs.misc;

import lellson.roughMobs.RoughMobs;

public class RoughConfig {
    private static final String GENERAL = "_GENERAL";
    private static final String EQUIPMENT = "_EQUIPMENT";
    private static final String MOBSPAWNING = "_MOBSPAWNING";
    private static final String HEALTHBOOST = "_HEALTHBOOST";
    private static final String FOLLOWRANGEBOOST = "_FOLLOWRANGEBOOST";
    private static final String SPEEDBOOST = "_SPEEDBOOST";
    public static final String KNOCKBACKBOOST = "_KNOCKBACKBOOST";
    private static final String DAMAGEBOOST = "_DAMAGEBOOST";
    private static final String MOBSATTACKEACHOTHER = "_mobsAttackEachOther";
    private static final String MOBSIMMUNETOFIRE = "_immuneToFire";
    private static final String EVENTS = "_EVENTS";
    private static final String NOTAFFECTEDENTITIES = "_notAffectedEntities";
    private static final String HORSE = "HORSE";
    private static final String BAT = "BAT";
    private static final String ZOMBIE = "ZOMBIE";
    private static final String SKELETON = "SKELETON";
    private static final String CREEPER = "CREEPER";
    private static final String SPIDER = "SPIDER";
    private static final String SLIME = "SLIME";
    private static final String ENDERMAN = "ENDERMAN";
    private static final String WITCH = "WITCH";
    private static final String SILVERFISH = "SILVERFISH";
    private static final String BLAZE = "BLAZE";
    private static final String ZOMBIEPIGMAN = "ZOMBIE_PIGMAN";
    private static final String GHAST = "GHAST";
    private static final String MAGMACUBE = "MAGMA_CUBE";
    private static final String WITHER = "WITHER";
    private static final int MAX = Short.MAX_VALUE;
    public static String[] mobSpawning;
    private static String[] mobSpawningDefault;
    public static String[] healthBoost;
    private static String[] healthBoostDefault;
    public static String[] followRangeBoost;
    private static String[] followRangeBoostDefault;
    public static String[] speedBoost;
    private static String[] speedBoostDefault;
    public static String[] knockbackBoost;
    private static String[] knockbackBoostDefault;
    public static String[] damageBoost;
    private static String[] damageBoostDefault;
    public static String[] mobsAttackEachOther;
    public static String[] mobsAttackEachOtherDefault;
    private static String[] notAffectedEntitiesDefault;
    public static boolean mobsAttackPassives;
    public static String[] armorEnchants;
    public static String[] swordEnchants;
    public static String[] bowEnchants;
    public static String[] weapons;
    public static String[] bossWeapons;
    public static String[] helmets;
    public static String[] chestplates;
    public static String[] leggings;
    public static String[] boots;
    public static String[] bossHelmets;
    public static String[] bossChestplates;
    public static String[] bossLeggings;
    public static String[] bossBoots;
    public static String[] armorEnchantsDefault;
    public static String[] swordEnchantsDefault;
    public static String[] bowEnchantsDefault;
    public static String[] weaponsDefault;
    public static String[] bossWeaponsDefault;
    public static String[] helmetsDefault;
    public static String[] chestplatesDefault;
    public static String[] leggingsDefault;
    public static String[] bootsDefault;
    public static String[] bossHelmetsDefault;
    public static String[] bossChestplatesDefault;
    public static String[] bossLeggingsDefault;
    public static String[] bossBootsDefault;
    public static boolean batEvents;
    public static boolean horseEvents;
    public static boolean zombieEvents;
    public static boolean skeletonEvents;
    public static boolean creeperEvents;
    public static boolean spiderEvents;
    public static boolean slimeEvents;
    public static boolean endermanEvents;
    public static boolean witchEvents;
    public static boolean silverfishEvents;
    public static boolean blazeEvents;
    public static boolean pigmanEvents;
    public static boolean ghastEvents;
    public static boolean magmacubeEvents;
    public static boolean witherEvents;
    public static boolean magmaCubeDropLava;
    public static boolean magmaCubeRegeneration;
    public static float blazeExplosionOnDeath;
    public static boolean blazeMeeleDebuffs;
    public static int blazeFireSkin;
    public static boolean ghastProjectileBlock;
    public static boolean ghastTNTDrop;
    public static boolean pigmanAngryOnTouch;
    public static int pigmanAngryOnBlockBreak;
    public static int skeletonArmor;
    public static boolean skeletonWeapons;
    public static int skeletonEnchantChance;
    public static int skeletonDropChance;
    public static int skeletonBossChance;
    public static boolean skeletonBossShouldDrop;
    public static String[] skeletonType;
    public static String[] skeletonTypesDefault;
    public static boolean skeletonToWither;
    public static float skeletonBossExplosion;
    public static boolean skeletonSwitchWeapons;
    public static int skeletonHorseChance;
    public static boolean snowballMeltInNether;
    public static boolean outputToConsole;
    public static boolean endermanExtraDrop;
    public static boolean endermanPlayerTeleport;
    public static int endermanPotionChance;
    public static boolean endermanStealItem;
    public static int spiderSlowdown;
    public static boolean spiderNoFallDamage;
    public static int spiderRiderChance;
    public static String[] spiderRiderEntities;
    public static String[] spiderRiderEntitiesDefault;
    public static String[] witchBoostBlacklist;
    public static String[] witchBoostBlacklistDefault;
    public static boolean witchBatsOnDeath;
    public static int witchBoost;
    public static boolean zombieApplyHunger;
    public static int zombieBossBabyChance;
    public static boolean zombieBabyBurn;
    public static boolean zombieBossShouldDrop;
    public static float zombieDropChance;
    public static int zombieHorseChance;
    public static int zombieBossChance;
    public static int zombieEnchantChance;
    public static int zombieArmorChance;
    public static int zombieWeaponChance;
    public static float slimeKnockback;
    public static boolean slimeOnHead;
    public static boolean slimeNausea;
    public static int silverfishSplitChance;
    public static boolean batVampire;
    public static boolean horseUndeadBurn;
    public static boolean witherKnockback;
    public static boolean witherSkeletonSummon;
    public static double creeperRange;
    public static int creeperParticle;
    public static boolean creeperFireExplosion;
    public static boolean creeperBurn;
    public static int creeperFuseTime;
    public static int creeperExplosionRadius;
    public static int ghastFireballStrength;
    public static int skeletonBowCooldown;
    public static String[] reduceSpawnRates;
    private static String[] reduceSpawnRatesDefault;
    public static String[] mobsImmuneToFire;
    public static String[] notAffectedEntities;
    public static String[] zombieBlocks;
    private static String[] zombieBlocksDefault;

    public static void init() {
        RoughMobs.config.load();
        RoughMobs.config.addCustomCategoryComment(MOBSPAWNING, "mobSpawning: Add Entities to the Spawn List. Takes 5-6 values seperated by ',' per Entity:\n1. value: Entity Name/Savegame ID (http://minecraft.gamepedia.com/Data_values/Entity_IDs). Modded Entities normally need their Mod ID too.\n2. value: Spawn chance.\n3. value: Minimal group size. Should be greater than 0.\n4. value: Maximal group size.\n5. value: Spawn Type. MOB = only at night, ANIMAL = day and night but rarer, WATER = only in water.\n6. value: Biome ID (OPTIONAL). Left this blank if you want that your entity spawns in every biome.\nTo make another entry simply go to a new line.\n##########################################################################################################\nreduceSpawnRates: Reduces the spawn rates of entities. Takes 2-3 values seperated by ',' pre Entity:\n1. value: Entity Name/Savegame ID (http://minecraft.gamepedia.com/Data_values/Entity_IDs). Modded Entities normally need their Mod ID too.\n2. value: Chance that the entity will not spawn (percentage). 100 always prevents the entity from spawning.\n3. value: Dimension ID (OPTIONAL). Left this blank if you want to reduce the spawn rate in every dimension.\nTo make another entry simply go to a new line.\nExample: Zombie,30,0 (This would make Zombies 30% rarer if they spawn in the overworld)");
        RoughMobs.config.addCustomCategoryComment(HEALTHBOOST, "Increase max HP of entities. Takes 2-3 values seperated by ',' per Entity:\n1. value: Entity Name/Savegame ID (http://minecraft.gamepedia.com/Data_values/Entity_IDs). Modded Entities normally need their Mod ID too.\n2. value: Percental amount with which the HP get boosted.\n3. value: Dimension ID (OPTIONAL). Left this blank if you want to apply the boost in every dimension.\nTo make another entry simply go to a new line.");
        RoughMobs.config.addCustomCategoryComment(FOLLOWRANGEBOOST, "Increase max follow range of entities. Takes 2-3 values seperated by ',' per Entity:\n1. value: Entity Name/Savegame ID (http://minecraft.gamepedia.com/Data_values/Entity_IDs). Modded Entities normally need their Mod ID too.\n2. value: Amount (blocks) which will be added to the follow range.\n3. value: Dimension ID (OPTIONAL). Left this blank if you want to apply the boost in every dimension.\nTo make another entry simply go to a new line.");
        RoughMobs.config.addCustomCategoryComment(SPEEDBOOST, "Increase max speed of entities. Takes 2-3 values seperated by ',' per Entity:\n1. value: Entity Name/Savegame ID (http://minecraft.gamepedia.com/Data_values/Entity_IDs). Modded Entities normally need their Mod ID too.\n2. value: Percental amount with which the speed get boosted.\n3. value: Dimension ID (OPTIONAL). Left this blank if you want to apply the boost in every dimension.\nTo make another entry simply go to a new line.");
        RoughMobs.config.addCustomCategoryComment(KNOCKBACKBOOST, "Increase max knockback resistance of entities. Takes 2-3 values seperated by ',' per Entity:\n1. value: Entity Name/Savegame ID (http://minecraft.gamepedia.com/Data_values/Entity_IDs). Modded Entities normally need their Mod ID too.\n2. value: Amount which will be added to the knockback resistance (range: 0.0 - 1.0).\n3. value: Dimension ID (OPTIONAL). Left this blank if you want to apply the boost in every dimension.\nTo make another entry simply go to a new line.");
        RoughMobs.config.addCustomCategoryComment(DAMAGEBOOST, "Increase max attack damage of entities. Takes 2-3 values seperated by ',' per Entity:\n1. value: Entity Name/Savegame ID (http://minecraft.gamepedia.com/Data_values/Entity_IDs). Modded Entities normally need their Mod ID too.\n2. value: Amount of extra damage entities do.\n3. value: Dimension ID (OPTIONAL). Left this blank if you want to apply the boost in every dimension.\nTo make another entry simply go to a new line.");
        RoughMobs.config.addCustomCategoryComment(MOBSATTACKEACHOTHER, "Mobs defined here should never attack each other. This was often caused by Skeleton which tried to shoot\nthe player but hit accidentally another mob. They always search for players, animals and villagers around them before attacking other mobs");
        RoughMobs.config.addCustomCategoryComment(MOBSIMMUNETOFIRE, "Mobs defined here are immune to fire");
        RoughMobs.config.addCustomCategoryComment(NOTAFFECTEDENTITIES, "Mobs defined here will not be affected by any features");
        RoughMobs.config.addCustomCategoryComment(EQUIPMENT, "Equipment settings for Zombies, Skeletons and Zombie Pigmen. To add NBT tags to the items, add \"::\" followed by the tag after the item name!");
        batEvents = RoughConfig.getEventBoolean("Bat");
        horseEvents = RoughConfig.getEventBoolean("Horse");
        zombieEvents = RoughConfig.getEventBoolean("Zombie");
        skeletonEvents = RoughConfig.getEventBoolean("Skeleton");
        creeperEvents = RoughConfig.getEventBoolean("Creeper");
        spiderEvents = RoughConfig.getEventBoolean("Spider");
        slimeEvents = RoughConfig.getEventBoolean("Slime");
        endermanEvents = RoughConfig.getEventBoolean("Enderman");
        witchEvents = RoughConfig.getEventBoolean("Witch");
        silverfishEvents = RoughConfig.getEventBoolean("Silverfish");
        pigmanEvents = RoughConfig.getEventBoolean("ZombiePigman");
        blazeEvents = RoughConfig.getEventBoolean("Blaze");
        ghastEvents = RoughConfig.getEventBoolean("Ghast");
        magmacubeEvents = RoughConfig.getEventBoolean("MagmaCube");
        witherEvents = RoughConfig.getEventBoolean("Wither");
        armorEnchants = RoughConfig.getEquipmentList("Armor Enchantments", armorEnchantsDefault);
        bowEnchants = RoughConfig.getEquipmentList("Bow Enchantments", bowEnchantsDefault);
        swordEnchants = RoughConfig.getEquipmentList("Sword Enchantments", swordEnchantsDefault);
        weapons = RoughConfig.getEquipmentList("Weapons", weaponsDefault);
        bossWeapons = RoughConfig.getEquipmentList("Boss Weapons", bossWeaponsDefault);
        helmets = RoughConfig.getEquipmentList("Helmets", helmetsDefault);
        chestplates = RoughConfig.getEquipmentList("Chestplates", chestplatesDefault);
        leggings = RoughConfig.getEquipmentList("Leggings", leggingsDefault);
        boots = RoughConfig.getEquipmentList("Boots", bootsDefault);
        bossHelmets = RoughConfig.getEquipmentList("Boss Helmets", bossHelmetsDefault);
        bossChestplates = RoughConfig.getEquipmentList("Boss Chestplates", bossChestplatesDefault);
        bossLeggings = RoughConfig.getEquipmentList("Boss Leggings", bossLeggingsDefault);
        bossBoots = RoughConfig.getEquipmentList("Boss Boots", bossBootsDefault);
        mobSpawning = RoughMobs.config.getStringList("mobSpawning", MOBSPAWNING, mobSpawningDefault, "");
        reduceSpawnRates = RoughMobs.config.getStringList("reduceSpawnRates", MOBSPAWNING, reduceSpawnRatesDefault, "");
        healthBoost = RoughMobs.config.getStringList("healthBoost", HEALTHBOOST, healthBoostDefault, "");
        followRangeBoost = RoughMobs.config.getStringList("followRangeBoost", FOLLOWRANGEBOOST, followRangeBoostDefault, "");
        speedBoost = RoughMobs.config.getStringList("speedBoost", SPEEDBOOST, speedBoostDefault, "");
        knockbackBoost = RoughMobs.config.getStringList("knockbackBoost", KNOCKBACKBOOST, knockbackBoostDefault, "");
        damageBoost = RoughMobs.config.getStringList("damageBoost", DAMAGEBOOST, damageBoostDefault, "");
        mobsAttackEachOther = RoughMobs.config.getStringList("mobsAttackEachOther", MOBSATTACKEACHOTHER, mobsAttackEachOtherDefault, "");
        mobsAttackPassives = RoughMobs.config.getBoolean("mobsAttackPassives", MOBSATTACKEACHOTHER, false, "Set to true to allow these mobs to attack animals and villagers");
        mobsImmuneToFire = RoughMobs.config.getStringList("mobsImmuneToFire", MOBSIMMUNETOFIRE, new String[0], "");
        notAffectedEntities = RoughMobs.config.getStringList("notAffectedEntities", NOTAFFECTEDENTITIES, notAffectedEntitiesDefault, "");
        outputToConsole = RoughMobs.config.getBoolean("outputToConsole", GENERAL, true, "If true active events will be printed to the console on MC-start");
        zombieApplyHunger = RoughMobs.config.getBoolean("zombieApplyHunger", ZOMBIE, true, "Set to false to prevent Zombies from applying the Hunger effect to the player");
        zombieBossBabyChance = RoughMobs.config.getInt("zombieBossBabyChance", ZOMBIE, 5, 0, Short.MAX_VALUE, "Chance (1 in amount) that boss Zombies spawn baby Zombies if they take damage");
        zombieBabyBurn = RoughMobs.config.getBoolean("zombieBabyBurn", ZOMBIE, true, "Set to false to prevent baby Zombies from burning in sunlight");
        zombieBossShouldDrop = RoughMobs.config.getBoolean("zombieBossShouldDrop", ZOMBIE, true, "Set to false to prevent boss Zombies from dropping one item of their weapons or armor");
        zombieDropChance = RoughMobs.config.getInt("zombieDropChance", ZOMBIE, 1, 0, 100, "Percentage chance that a non-boss Zombie drops one of its weapons or armor. Set to 0, to disable this feature");
        zombieHorseChance = RoughMobs.config.getInt("zombieHorseChance", ZOMBIE, 12, 0, Short.MAX_VALUE, "Chance (1 in amount) that Zombies spawn on a horse. Set to 0, to disable this feature");
        zombieBossChance = RoughMobs.config.getInt("zombieBossChance", ZOMBIE, 200, 0, Short.MAX_VALUE, "Chance (1 in amount) to turn a Zombie into a boss Zombie. Set to 0, to disable this feature");
        zombieEnchantChance = RoughMobs.config.getInt("zombieEnchantChance", ZOMBIE, 5, 0, Short.MAX_VALUE, "Chance (1 in amount per piece) to enchant Zombies new armor or weapons. Set to 0, to disable this feature");
        zombieArmorChance = RoughMobs.config.getInt("zombieArmorChance", ZOMBIE, 5, 0, Short.MAX_VALUE, "chance (1 in amount per piece) to give Zombies new armor on spawn. Set to 0, to disable this feature");
        zombieWeaponChance = RoughMobs.config.getInt("zombieWeaponChance", ZOMBIE, 5, 0, Short.MAX_VALUE, "chance (1 in amount per hand) to give Zombies new weapons on spawn. Set to 0, to disable this feature");
        zombieBlocks = RoughMobs.config.getStringList("zombieBlocks", ZOMBIE, zombieBlocksDefault, "Blocks which Zombies are allowed to break. Remove all lines to disable this feature");
        skeletonArmor = RoughMobs.config.getInt("skeletonArmor", SKELETON, 3, 0, Short.MAX_VALUE, "chance (1 in amount per piece) to give Skeletons new armor on spawning. Set to 0, to disable this feature");
        skeletonWeapons = RoughMobs.config.getBoolean("skeletonWeapons", SKELETON, true, "Set to false to prevent Skeletons from receiving new weapons on spawn");
        skeletonType = RoughMobs.config.getStringList("skeletonType", SKELETON, skeletonTypesDefault, "Skeleton Types which should receive new armor and weapons on spawning (0 is normal, 1 is wither, 2 is Stray). To make another entry simply go to a new line");
        skeletonToWither = RoughMobs.config.getBoolean("skeletonToWither", SKELETON, true, "While true all Skeletons in the Nether should become Wither Skeletons");
        skeletonDropChance = RoughMobs.config.getInt("skeletonDropChance", SKELETON, 1, 0, 100, "Percentage chance that a non-boss Skeleton drops one of its weapons or armor. Set to 0, to disable this feature");
        skeletonBossChance = RoughMobs.config.getInt("skeletonBossChance", SKELETON, 200, 0, Short.MAX_VALUE, "Chance (1 in amount) to turn a Skeleton into a boss Skeleton. Set to 0, to disable this feature");
        skeletonBossShouldDrop = RoughMobs.config.getBoolean("skeletonBossShouldDrop", SKELETON, true, "Set to false to prevent boss Skeletons from dropping one item of their weapons or armor");
        skeletonEnchantChance = RoughMobs.config.getInt("skeletonEnchantChance", SKELETON, 5, 0, Short.MAX_VALUE, "Chance (1 in amount per piece) to enchant Skeletons new armor or weapons. Set to 0, to disable this feature");
        skeletonBossExplosion = RoughMobs.config.getFloat("skeletonBossExplosion", SKELETON, 1.0f, 0.0f, 32767.0f, "Explosion radius for boss Skeleton explosions. Set to 0, to disable this feature");
        skeletonSwitchWeapons = RoughMobs.config.getBoolean("skeletonSwitchWeapons", SKELETON, true, "Set to false to prevent Skeletons from switching their weapons, while near a player");
        skeletonHorseChance = RoughMobs.config.getInt("skeletonHorseChance", SKELETON, 12, 0, Short.MAX_VALUE, "Chance (1 in amount) that Skeletons spawn on a horse. Set to 0, to disable this feature");
        slimeKnockback = RoughMobs.config.getFloat("slimeKnockback", SLIME, 0.5f, 0.0f, 100.0f, "Amount of extra knockback Slimes do on attack");
        slimeOnHead = RoughMobs.config.getBoolean("slimeOnHead", SLIME, true, "Set to false to prevent small Slimes from jumping on the players head");
        slimeNausea = RoughMobs.config.getBoolean("slimeNausea", SLIME, true, "Set to false to turn of the nausea effect which slimes give players when they stick on their head");
        endermanExtraDrop = RoughMobs.config.getBoolean("endermanExtraDrop", ENDERMAN, true, "Set to false to prevent Endermen from dropping an extra Enderpearl");
        endermanPlayerTeleport = RoughMobs.config.getBoolean("endermanPlayerTeleport", ENDERMAN, true, "Set to false to prevent Endermen from teleporting the player");
        endermanPotionChance = RoughMobs.config.getInt("endermanPotionChance", ENDERMAN, 5, 0, Short.MAX_VALUE, "Chance (1 in amount) that Endermen apply Blindness or Nausea to the player");
        endermanStealItem = RoughMobs.config.getBoolean("endermanStealItem", ENDERMAN, true, "Set to false to prevent Endermen from stealing the players held item");
        spiderSlowdown = RoughMobs.config.getInt("spiderSlowdown", SPIDER, 1, 0, Short.MAX_VALUE, "Chance (1 in amount) that Spiders create webs and apply Slowness to the player");
        spiderNoFallDamage = RoughMobs.config.getBoolean("spiderNoFallDamage", SPIDER, true, "While true Spiders take no fall damage");
        spiderRiderChance = RoughMobs.config.getInt("spiderRiderChance", SPIDER, 20, 0, Short.MAX_VALUE, "Chance (1 in amount) that Spiders spawn with a mob riding it");
        spiderRiderEntities = RoughMobs.config.getStringList("spiderRiderEntities", SPIDER, spiderRiderEntitiesDefault, "Entities which are allowed to spawn on a spider. To make another entry simply go to a new line");
        witchBoost = RoughMobs.config.getInt("witchBoost", WITCH, 1, 0, 2, "Entities which should get boosted with buffs (except blacklisted entities): 0 = disabled, 1 = Only Hostile, 2 = Every Entity besides Players");
        witchBoostBlacklist = RoughMobs.config.getStringList("witchBoostBlacklist", WITCH, witchBoostBlacklistDefault, "Entities which don't get boosted while they are near a Witch. To make another entry simply go to a new line");
        witchBatsOnDeath = RoughMobs.config.getBoolean("witchBatsOnDeath", WITCH, true, "Set to false to prevent Witches from summoning Bats on death");
        silverfishSplitChance = RoughMobs.config.getInt("silverfishSplitChance", SILVERFISH, 3, 0, Short.MAX_VALUE, "chance (1 in amount) to split one Silverfish in two when attacked. Set to 0, to disable this feature");
        batVampire = RoughMobs.config.getBoolean("batVampire", BAT, true, "Set to false to prevent Bats from draining players blood");
        horseUndeadBurn = RoughMobs.config.getBoolean("horseUndeadBurn", HORSE, true, "Set to false to prevent undead Horses (Skeleton- and Zombie-Horses) from burning in sunlight");
        magmaCubeDropLava = RoughMobs.config.getBoolean("magmaCubeDropLava", MAGMACUBE, true, "Set to false to prevent Magma Cubes from dropping Lava on death");
        magmaCubeRegeneration = RoughMobs.config.getBoolean("magmaCubeRegeneration", MAGMACUBE, true, "Set to false to prevent Magma Cubes from regenerating HP in lava");
        blazeExplosionOnDeath = RoughMobs.config.getFloat("blazeExplosionOnDeath", BLAZE, 0.5f, 0.0f, 32767.0f, "Explosion radius for the explosion which happens when a blaze dies. Set to 0, to disable this feature");
        blazeMeeleDebuffs = RoughMobs.config.getBoolean("blazeMeeleDebuffs", BLAZE, true, "Set to false to disallow blazes from knocking the player away if he attacks a blaze");
        blazeFireSkin = RoughMobs.config.getInt("blazeFireSkin", BLAZE, 5, 0, Short.MAX_VALUE, "Burn duration in seconds if the player touches a blaze. Set to 0 to disable the feature");
        ghastProjectileBlock = RoughMobs.config.getBoolean("ghastProjectileBlock", GHAST, true, "Set to false to prevent Ghasts from blocking projectiles");
        ghastTNTDrop = RoughMobs.config.getBoolean("ghastTNTDrop", GHAST, true, "Set to false to prevent Ghasts from dropping primed TNT");
        pigmanAngryOnTouch = RoughMobs.config.getBoolean("pigmanAngryOnTouch", ZOMBIEPIGMAN, true, "Set to false to prevent Zombie Pigmen from getting angry, if the player touches them");
        pigmanAngryOnBlockBreak = RoughMobs.config.getInt("pigmanAngryOnBlockBreak", ZOMBIEPIGMAN, 10, 0, Short.MAX_VALUE, "chance (1 in amount) to make Zombie Pigmen angry if the player destroys nearby blocks");
        snowballMeltInNether = RoughMobs.config.getBoolean("snowballMeltInNether", GENERAL, true, "Set to false to prevent snowballs from melting when thrown in the nether");
        witherKnockback = RoughMobs.config.getBoolean("witherKnockback", WITHER, true, "Set to false to prevent withers from knocking attackers away");
        witherSkeletonSummon = RoughMobs.config.getBoolean("witherSkeletonSummon", WITHER, true, "Set to false to prevent withers from summoning wither skeletons");
        creeperRange = RoughMobs.config.getFloat("creeperRangeInvisible", CREEPER, 3.0f, 0.0f, 100.0f, "Distance to the player at which Creepers become invisible. Set this to 0 to disallow creepers from becoming invisible");
        creeperParticle = RoughMobs.config.getInt("creeperParticle", CREEPER, 3, 0, 50, "Amount of particles which spawn while Creepers are invisible. Set this to 0 to disable particles");
        creeperBurn = RoughMobs.config.getBoolean("creeperBurn", CREEPER, false, "If true Creepers burn in sunlight");
        creeperFireExplosion = RoughMobs.config.getBoolean("creeperFireExplosion", CREEPER, false, "If true Creepers explode if they are burning. Don't combine this with creeperBurn, except you want a ton of destruction...");
        creeperFuseTime = RoughMobs.config.getInt("creeperFuseTime", CREEPER, 20, 1, Short.MAX_VALUE, "Fuse time (in ticks, 1 second = 20 ticks) for Creeper explosions. The vanilla default is 30");
        creeperExplosionRadius = RoughMobs.config.getInt("creeperExplosionRadius", CREEPER, 4, 0, 127, "Creeper explosion radius. The vanilla default is 3");
        ghastFireballStrength = RoughMobs.config.getInt("ghastFireballStrength", GHAST, 3, 0, 127, "Explosion radius for the Ghast Fireballs. The vanilla default is 1");
        skeletonBowCooldown = RoughMobs.config.getInt("skeletonBowCooldown", SKELETON, 0, 0, Short.MAX_VALUE, "Amount of ticks (20 ticks = 1 second) which Skeletons have to wait between each bow draw. The vanilla default is 20");
        if (RoughMobs.config.hasChanged()) {
            RoughMobs.config.save();
        }
    }

    private static boolean getEventBoolean(String name) {
        return RoughMobs.config.getBoolean(name + "Events", EVENTS, true, "Set to false to disable all " + name + " features");
    }

    private static String[] getEquipmentList(String name, String[] defaultValues) {
        return RoughMobs.config.getStringList(name.trim(), EQUIPMENT, defaultValues, name);
    }

    static {
        mobSpawningDefault = new String[]{"Skeleton,30,1,5,MOB,8", "Blaze,30,1,5,MOB,8", "LavaSlime,30,1,3,MOB,8"};
        healthBoostDefault = new String[]{"Zombie,50", "Skeleton,50", "Slime,50", "Blaze,50", "PigZombie,50", "Ghast,50", "LavaSlime,50", "WitherBoss,100"};
        followRangeBoostDefault = new String[]{"Zombie,30", "Skeleton,30", "Creeper,30", "Spider,30", "Slime,30", "Witch,30", "Blaze,30", "PigZombie,30", "Ghast,30", "LavaSlime,30"};
        speedBoostDefault = new String[]{"Creeper,50", "Slime,50", "LavaSlime,50"};
        knockbackBoostDefault = new String[]{"Zombie,0.5", "PigZombie,0.5"};
        damageBoostDefault = new String[0];
        mobsAttackEachOtherDefault = new String[]{"Zombie", "Skeleton", "Creeper", "Spider", "Slime", "Witch", "Blaze", "Ghast", "LavaSlime", "WitherBoss"};
        notAffectedEntitiesDefault = new String[]{"EnderZoo.DireSlime"};
        armorEnchantsDefault = new String[]{"protection", "feather_falling", "projectile_protection", "thorns", "unbreaking"};
        swordEnchantsDefault = new String[]{"fire_aspect", "knockback", "sharpness", "unbreaking"};
        bowEnchantsDefault = new String[]{"flame", "punch", "power", "unbreaking"};
        weaponsDefault = new String[]{"wooden_axe", "wooden_sword", "stone_pickaxe", "stone_axe", "stone_sword", "iron_pickaxe", "iron_axe", "iron_sword"};
        bossWeaponsDefault = new String[]{"diamond_sword", "diamond_axe"};
        helmetsDefault = new String[]{"leather_helmet", "chainmail_helmet"};
        chestplatesDefault = new String[]{"leather_chestplate", "chainmail_chestplate"};
        leggingsDefault = new String[]{"leather_leggings", "chainmail_leggings"};
        bootsDefault = new String[]{"leather_boots", "chainmail_boots"};
        bossHelmetsDefault = new String[]{"diamond_helmet"};
        bossChestplatesDefault = new String[]{"diamond_chestplate"};
        bossLeggingsDefault = new String[]{"diamond_leggings"};
        bossBootsDefault = new String[]{"diamond_boots"};
        skeletonTypesDefault = new String[]{"0", "1", "2"};
        spiderRiderEntitiesDefault = new String[]{"Witch", "Skeleton", "Zombie", "CaveSpider"};
        witchBoostBlacklistDefault = new String[]{"Witch"};
        reduceSpawnRatesDefault = new String[0];
        zombieBlocksDefault = new String[]{"minecraft:torch", "minecraft:carrots", "minecraft:potatoes", "minecraft:wheat", "minecraft:nether_wart", "minecraft:reeds", "minecraft:beetroots", "minecraft:pumpkin_stem", "minecraft:melon_stem"};
    }
}

