/*
 * Decompiled with CFR 0.152.
 */
package lellson.roughMobs.misc;

import java.util.Random;
import lellson.roughMobs.misc.RoughConfig;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLLog;

public class RoughEquipment {
    public static Enchantment getRandomEnchantment(Random rnd, Item item) {
        if (item instanceof ItemArmor) {
            return RoughEquipment.getEnchantmentFromArray(RoughConfig.armorEnchants, rnd);
        }
        if (item instanceof ItemBow) {
            return RoughEquipment.getEnchantmentFromArray(RoughConfig.bowEnchants, rnd);
        }
        return RoughEquipment.getEnchantmentFromArray(RoughConfig.swordEnchants, rnd);
    }

    public static ItemStack getRandomWeapon(Random rnd) {
        return RoughEquipment.getItemFromArray(RoughConfig.weapons, rnd);
    }

    public static ItemStack getRandomBossWeapon(Random rnd) {
        return RoughEquipment.getItemFromArray(RoughConfig.bossWeapons, rnd);
    }

    public static ItemStack getArmorItemForSlot(Random rnd, EntityEquipmentSlot slot) {
        switch (slot) {
            case HEAD: {
                return RoughEquipment.getItemFromArray(RoughConfig.helmets, rnd);
            }
            case CHEST: {
                return RoughEquipment.getItemFromArray(RoughConfig.chestplates, rnd);
            }
            case LEGS: {
                return RoughEquipment.getItemFromArray(RoughConfig.leggings, rnd);
            }
            case FEET: {
                return RoughEquipment.getItemFromArray(RoughConfig.boots, rnd);
            }
        }
        return null;
    }

    public static ItemStack getArmorItemForSlotBoss(Random rnd, EntityEquipmentSlot slot) {
        switch (slot) {
            case HEAD: {
                return RoughEquipment.getItemFromArray(RoughConfig.bossHelmets, rnd);
            }
            case CHEST: {
                return RoughEquipment.getItemFromArray(RoughConfig.bossChestplates, rnd);
            }
            case LEGS: {
                return RoughEquipment.getItemFromArray(RoughConfig.bossLeggings, rnd);
            }
            case FEET: {
                return RoughEquipment.getItemFromArray(RoughConfig.bossBoots, rnd);
            }
        }
        return null;
    }

    private static ItemStack getItemFromArray(String[] array, Random rnd) {
        if (array.length == 0 || array[0].length() == 0) {
            return null;
        }
        String[] name = array[rnd.nextInt(array.length)].split("::");
        ItemStack stack = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(name[0])));
        if (name.length > 1) {
            try {
                stack.func_77982_d(JsonToNBT.func_180713_a((String)name[1]));
            }
            catch (NBTException e) {
                FMLLog.bigWarning((String)"NBT Tag invalid: %s", (Object[])new Object[]{e.toString()});
            }
        }
        return stack;
    }

    private static Enchantment getEnchantmentFromArray(String[] array, Random rnd) {
        if (array.length == 0 || array[0].length() == 0) {
            return null;
        }
        String name = array[rnd.nextInt(array.length)];
        Enchantment enchantment = Enchantment.func_180305_b((String)name);
        if (enchantment == null) {
            System.err.println("'" + name + "' is not a valid enchantment!");
        }
        return enchantment;
    }

    public static Item randomHorseArmor(Random rnd) {
        switch (rnd.nextInt(6)) {
            case 0: {
                return Items.field_151125_bZ;
            }
            case 1: 
            case 2: {
                return Items.field_151136_bY;
            }
            case 3: 
            case 4: 
            case 5: {
                return Items.field_151138_bX;
            }
        }
        return Items.field_151138_bX;
    }
}

