/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.arboriculture;

import forestry.api.arboriculture.IWoodType;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;

public enum EnumForestryWoodType implements IWoodType
{
    LARCH(4),
    TEAK(4),
    ACACIA(4),
    LIME(4),
    CHESTNUT(4),
    WENGE(4),
    BAOBAB(4),
    SEQUOIA(3, 4.0f),
    KAPOK(4),
    EBONY(4),
    MAHOGANY(4),
    BALSA(4, 1.0f),
    WILLOW(4),
    WALNUT(4),
    GREENHEART(4, 7.5f),
    CHERRY(4),
    MAHOE(4),
    POPLAR(4),
    PALM(4),
    PAPAYA(4),
    PINE(4, 3.0f),
    PLUM(4),
    MAPLE(4),
    CITRUS(4),
    GIGANTEUM(3, 4.0f),
    IPE(4),
    PADAUK(4),
    COCOBOLO(4),
    ZEBRAWOOD(4);

    public static final float DEFAULT_HARDNESS = 2.0f;
    public static final EnumForestryWoodType[] VALUES;
    private final int carbonization;
    private final float hardness;

    private EnumForestryWoodType(int carbonization) {
        this(carbonization, 2.0f);
    }

    private EnumForestryWoodType(int carbonization, float hardness) {
        this.carbonization = carbonization;
        this.hardness = hardness;
    }

    @Override
    public float getHardness() {
        return this.hardness;
    }

    public static EnumForestryWoodType getRandom(Random random) {
        return VALUES[random.nextInt(VALUES.length)];
    }

    public String toString() {
        return super.toString().toLowerCase(Locale.ENGLISH);
    }

    public String func_176610_l() {
        return this.toString();
    }

    @Override
    public int getMetadata() {
        return this.ordinal();
    }

    @Nonnull
    public static EnumForestryWoodType byMetadata(int meta) {
        if (meta < 0 || meta >= VALUES.length) {
            meta = 0;
        }
        return VALUES[meta];
    }

    @Override
    public int getCarbonization() {
        return this.carbonization;
    }

    @Override
    public float getCharcoalChance(int numberOfCharcoal) {
        if (numberOfCharcoal == 3) {
            return 0.75f;
        }
        if (numberOfCharcoal == 4) {
            return 0.5f;
        }
        if (numberOfCharcoal == 5) {
            return 0.25f;
        }
        return 0.15f;
    }

    @Override
    public String getPlankTexture() {
        return "forestry:blocks/wood/planks." + this.func_176610_l();
    }

    @Override
    public String getDoorLowerTexture() {
        return "forestry:blocks/doors/" + this.func_176610_l() + "_lower";
    }

    @Override
    public String getDoorUpperTexture() {
        return "forestry:blocks/doors/" + this.func_176610_l() + "_upper";
    }

    @Override
    public String getBarkTexture() {
        return "forestry:blocks/wood/bark." + this.func_176610_l();
    }

    @Override
    public String getHeartTexture() {
        return "forestry:blocks/wood/heart." + this.func_176610_l();
    }

    static {
        VALUES = EnumForestryWoodType.values();
    }
}

