/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.apiculture.IBee;
import forestry.apiculture.network.packets.PacketHabitatBiomePointer;
import forestry.core.proxy.Proxies;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class HabitatLocatorLogic {
    private static final int maxChecksPerTick = 100;
    private static final int maxSearchRadiusIterations = 500;
    private static final int spacing = 20;
    private static final int minBiomeRadius = 8;
    private static final Set<Biome> waterBiomes = new HashSet<Biome>();
    private static final Set<Biome> netherBiomes = new HashSet<Biome>();
    private static final Set<Biome> endBiomes = new HashSet<Biome>();
    private Set<Biome> targetBiomes = new HashSet<Biome>();
    private boolean biomeFound = false;
    private int searchRadiusIteration = 0;
    private int searchAngleIteration = 0;
    private BlockPos searchCenter;

    public boolean isBiomeFound() {
        return this.biomeFound;
    }

    public Set<Biome> getTargetBiomes() {
        return this.targetBiomes;
    }

    public void startBiomeSearch(IBee bee, EntityPlayer player) {
        this.targetBiomes = new HashSet<Biome>(bee.getSuitableBiomes());
        this.searchAngleIteration = 0;
        this.searchRadiusIteration = 0;
        this.biomeFound = false;
        this.searchCenter = player.func_180425_c();
        Biome currentBiome = player.field_70170_p.func_180494_b(this.searchCenter);
        HabitatLocatorLogic.removeInvalidBiomes(currentBiome, this.targetBiomes);
        Proxies.render.setHabitatLocatorTexture(null, null);
    }

    public void onUpdate(World world, Entity player) {
        if (world.field_72995_K) {
            return;
        }
        if (this.targetBiomes.isEmpty()) {
            return;
        }
        if (this.biomeFound && world.func_82737_E() % 20L != 0L) {
            return;
        }
        BlockPos target = this.findNearestBiome(player, this.targetBiomes);
        if (target != null && player instanceof EntityPlayerMP) {
            Proxies.net.sendToPlayer(new PacketHabitatBiomePointer(target), (EntityPlayer)((EntityPlayerMP)player));
            this.biomeFound = true;
        }
    }

    private BlockPos findNearestBiome(Entity player, Collection<Biome> biomesToSearch) {
        BlockPos playerPos = player.func_180425_c();
        BlockPos coordinates = HabitatLocatorLogic.getChunkCoordinates(playerPos, player.field_70170_p, biomesToSearch);
        if (coordinates != null) {
            this.searchAngleIteration = 0;
            this.searchRadiusIteration = 0;
            return playerPos;
        }
        int radius = 20 * (this.searchRadiusIteration + 1);
        double angleSpacing = 2.0 * Math.asin(20.0 / (2.0 * (double)radius));
        angleSpacing = Math.PI * 2 / (double)Math.round(Math.PI * 2 / angleSpacing);
        for (int i = 0; i < 100; ++i) {
            int zOffset;
            double angle = angleSpacing * (double)this.searchAngleIteration;
            if (angle > Math.PI * 2) {
                this.searchAngleIteration = 0;
                ++this.searchRadiusIteration;
                if (this.searchRadiusIteration > 500) {
                    this.searchAngleIteration = 0;
                    this.searchRadiusIteration = 0;
                    this.searchCenter = playerPos;
                }
                return null;
            }
            ++this.searchAngleIteration;
            int xOffset = Math.round((float)((double)radius * Math.cos(angle)));
            BlockPos pos = this.searchCenter.func_177982_a(xOffset, 0, zOffset = Math.round((float)((double)radius * Math.sin(angle))));
            coordinates = HabitatLocatorLogic.getChunkCoordinates(pos, player.field_70170_p, biomesToSearch);
            if (coordinates == null) continue;
            this.searchAngleIteration = 0;
            this.searchRadiusIteration = 0;
            return coordinates;
        }
        return null;
    }

    private static BlockPos getChunkCoordinates(BlockPos pos, World world, Collection<Biome> biomesToSearch) {
        Biome biome = world.func_180494_b(pos);
        if (!biomesToSearch.contains(biome)) {
            return null;
        }
        biome = world.func_180494_b(pos.func_177982_a(-8, 0, 0));
        if (!biomesToSearch.contains(biome)) {
            return null;
        }
        biome = world.func_180494_b(pos.func_177982_a(8, 0, 0));
        if (!biomesToSearch.contains(biome)) {
            return null;
        }
        biome = world.func_180494_b(pos.func_177982_a(0, 0, -8));
        if (!biomesToSearch.contains(biome)) {
            return null;
        }
        biome = world.func_180494_b(pos.func_177982_a(0, 0, 8));
        if (!biomesToSearch.contains(biome)) {
            return null;
        }
        return pos;
    }

    private static void removeInvalidBiomes(Biome currentBiome, Set<Biome> biomesToSearch) {
        biomesToSearch.removeAll(waterBiomes);
        if (BiomeDictionary.isBiomeOfType((Biome)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            biomesToSearch.retainAll(netherBiomes);
        } else {
            biomesToSearch.removeAll(netherBiomes);
        }
        if (BiomeDictionary.isBiomeOfType((Biome)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.END)) {
            biomesToSearch.retainAll(endBiomes);
        } else {
            biomesToSearch.removeAll(endBiomes);
        }
    }

    static {
        Collections.addAll(waterBiomes, BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.BEACH));
        Collections.addAll(waterBiomes, BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
        Collections.addAll(waterBiomes, BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.RIVER));
        Collections.addAll(netherBiomes, BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.NETHER));
        Collections.addAll(endBiomes, BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.END));
    }
}

