/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IFruitFamily;
import forestry.arboriculture.FruitProviderNone;
import forestry.core.utils.BlockUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FruitProviderPod
extends FruitProviderNone {
    private final EnumPodType type;
    @Nonnull
    private final Map<ItemStack, Float> drops;

    public FruitProviderPod(String unlocalizedDescription, IFruitFamily family, EnumPodType type, ItemStack ... dropOnMature) {
        super(unlocalizedDescription, family);
        this.type = type;
        this.drops = new HashMap<ItemStack, Float>();
        for (ItemStack drop : dropOnMature) {
            this.drops.put(drop, Float.valueOf(1.0f));
        }
    }

    @Override
    public boolean requiresFruitBlocks() {
        return true;
    }

    @Override
    @Nonnull
    public List<ItemStack> getFruits(ITreeGenome genome, World world, BlockPos pos, int ripeningTime) {
        if (this.drops.isEmpty()) {
            return Collections.emptyList();
        }
        if (ripeningTime >= 2) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            for (ItemStack aDrop : this.drops.keySet()) {
                drops.add(aDrop.func_77946_l());
            }
            return drops;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean trySpawnFruitBlock(ITreeGenome genome, World world, Random rand, BlockPos pos) {
        if (rand.nextFloat() > genome.getSappiness()) {
            return false;
        }
        if (this.type == EnumPodType.COCOA) {
            return BlockUtil.tryPlantCocoaPod(world, pos);
        }
        IAlleleFruit activeAllele = (IAlleleFruit)genome.getActiveAllele(EnumTreeChromosome.FRUITS);
        return TreeManager.treeRoot.setFruitBlock(world, activeAllele, genome.getSappiness(), pos);
    }

    @Override
    public ResourceLocation getSprite(ITreeGenome genome, IBlockAccess world, BlockPos pos, int ripeningTime) {
        return null;
    }

    @Override
    public ResourceLocation getDecorativeSprite() {
        return null;
    }

    @Override
    @Nonnull
    public Map<ItemStack, Float> getProducts() {
        return Collections.unmodifiableMap(this.drops);
    }

    @Override
    public void registerSprites() {
    }

    @Override
    @Nonnull
    public String getModelName() {
        return this.type.getModelName();
    }

    public static enum EnumPodType {
        COCOA,
        DATES,
        PAPAYA;


        public String getModelName() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

