/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.mutations;

import forestry.api.climate.IClimateProvider;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutationCondition;
import forestry.core.utils.Translator;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class MutationConditionBiome
implements IMutationCondition {
    private final List<BiomeDictionary.Type> validBiomeTypes;

    public MutationConditionBiome(BiomeDictionary.Type ... types) {
        this.validBiomeTypes = Arrays.asList(types);
    }

    @Override
    public float getChance(World world, BlockPos pos, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1, IClimateProvider climate) {
        Biome biome = climate.getBiome();
        for (BiomeDictionary.Type type : this.validBiomeTypes) {
            if (!BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)type)) continue;
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public String getDescription() {
        if (this.validBiomeTypes.size() > 1) {
            String biomeTypes = Arrays.toString(this.validBiomeTypes.toArray()).toLowerCase(Locale.ENGLISH);
            return Translator.translateToLocalFormatted("for.mutation.condition.biome.multiple", biomeTypes);
        }
        String biomeType = this.validBiomeTypes.get(0).toString().toLowerCase(Locale.ENGLISH);
        return Translator.translateToLocalFormatted("for.mutation.condition.biome.single", biomeType);
    }
}

