/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.api.climate.IClimateControl;
import forestry.api.climate.IClimateControlProvider;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockLogic;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.PacketIdServer;
import forestry.core.network.packets.PacketCoordinates;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;

public class PacketUpdateClimateControl
extends PacketCoordinates
implements IForestryPacketServer {
    private float controlTemperature;
    private float controlHumidity;

    public PacketUpdateClimateControl() {
    }

    public PacketUpdateClimateControl(IClimateControlProvider provider) {
        super(provider.getCoordinates());
        IClimateControl control = provider.getClimateControl();
        this.controlTemperature = control.getControlTemperature();
        this.controlHumidity = control.getControlHumidity();
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeFloat(this.controlTemperature);
        data.writeFloat(this.controlHumidity);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.controlTemperature = data.readFloat();
        this.controlHumidity = data.readFloat();
    }

    @Override
    public PacketIdServer getPacketId() {
        return PacketIdServer.CLIMATE_CONTROL_UPDATE;
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayerMP player) throws IOException {
        TileEntity tile = this.getTarget(player.field_70170_p);
        IClimateControl control = null;
        if (tile instanceof IMultiblockComponent) {
            IMultiblockComponent component = (IMultiblockComponent)tile;
            IMultiblockLogic logic = component.getMultiblockLogic();
            if (logic.isConnected() && logic.getController() instanceof IClimateControlProvider) {
                control = ((IClimateControlProvider)((Object)logic.getController())).getClimateControl();
            }
        } else if (tile instanceof IClimateControlProvider) {
            control = ((IClimateControlProvider)tile).getClimateControl();
        }
        if (control != null) {
            control.setControlTemperature(this.controlTemperature);
            control.setControlHumidity(this.controlHumidity);
        }
    }
}

