/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.owner;

import com.mojang.authlib.GameProfile;
import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.owner.IOwnerHandler;
import forestry.core.utils.PlayerUtil;
import java.io.IOException;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class OwnerHandler
implements IOwnerHandler,
IStreamable,
INbtWritable,
INbtReadable {
    private GameProfile owner = null;

    @Override
    public GameProfile getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(@Nonnull GameProfile owner) {
        this.owner = owner;
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        if (this.owner == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(true);
            data.writeLong(this.owner.getId().getMostSignificantBits());
            data.writeLong(this.owner.getId().getLeastSignificantBits());
            data.writeUTF(this.owner.getName());
        }
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        if (data.readBoolean()) {
            GameProfile owner = new GameProfile(new UUID(data.readLong(), data.readLong()), data.readUTF());
            this.setOwner(owner);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        GameProfile owner;
        if (data.func_74764_b("owner") && (owner = PlayerUtil.readGameProfileFromNBT(data.func_74775_l("owner"))) != null) {
            this.setOwner(owner);
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        if (this.owner != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            PlayerUtil.writeGameProfile(nbt, this.owner);
            data.func_74782_a("owner", (NBTBase)nbt);
        }
        return data;
    }
}

