/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.network.packets;

import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.PacketIdServer;
import forestry.core.network.packets.PacketCoordinates;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.TileBase;
import forestry.factory.network.packets.PacketRecipeTransferUpdate;
import forestry.factory.tiles.TileCarpenter;
import forestry.factory.tiles.TileFabricator;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class PacketRecipeTransferRequest
extends PacketCoordinates
implements IForestryPacketServer {
    private ItemStack[] craftingInventory;

    public PacketRecipeTransferRequest() {
    }

    public PacketRecipeTransferRequest(TileBase base, ItemStack[] craftingInventory) {
        super(base);
        this.craftingInventory = craftingInventory;
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeItemStacks(this.craftingInventory);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.craftingInventory = data.readItemStacks();
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayerMP player) throws IOException {
        TileEntity tile = this.getTarget(player.field_70170_p);
        if (tile instanceof TileCarpenter) {
            TileCarpenter carpenter = (TileCarpenter)tile;
            int index = 0;
            for (ItemStack stack : this.craftingInventory) {
                carpenter.getCraftingInventory().func_70299_a(index, stack);
                ++index;
            }
            Proxies.net.sendNetworkPacket(new PacketRecipeTransferUpdate(carpenter, this.craftingInventory), player.field_70170_p);
        } else if (tile instanceof TileFabricator) {
            TileFabricator fabricator = (TileFabricator)tile;
            int index = 0;
            for (ItemStack stack : this.craftingInventory) {
                fabricator.getCraftingInventory().func_70299_a(index, stack);
                ++index;
            }
            Proxies.net.sendNetworkPacket(new PacketRecipeTransferUpdate(fabricator, this.craftingInventory), player.field_70170_p);
        }
    }

    @Override
    public PacketIdServer getPacketId() {
        return PacketIdServer.RECIPE_TRANSFER_REQUEST;
    }
}

