/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.recipes.IFabricatorManager;
import forestry.api.recipes.IFabricatorRecipe;
import forestry.core.recipes.RecipeUtil;
import forestry.core.recipes.ShapedRecipeCustom;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.recipes.FabricatorRecipe;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FabricatorRecipeManager
implements IFabricatorManager {
    private static final Set<IFabricatorRecipe> recipes = new HashSet<IFabricatorRecipe>();

    @Override
    public void addRecipe(ItemStack plan, FluidStack molten, ItemStack result, Object[] pattern) {
        FabricatorRecipe recipe = new FabricatorRecipe(plan, molten, ShapedRecipeCustom.createShapedRecipe(result, pattern));
        this.addRecipe(recipe);
    }

    public static IFabricatorRecipe findMatchingRecipe(ItemStack plan, IInventory resources) {
        ItemStack[][] gridResources = RecipeUtil.getResources(resources);
        for (IFabricatorRecipe recipe : recipes) {
            if (recipe.getPlan() != null && !ItemStackUtil.isCraftingEquivalent(recipe.getPlan(), plan) || !RecipeUtil.matches(recipe.getIngredients(), recipe.getWidth(), recipe.getHeight(), gridResources)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean isPlan(ItemStack plan) {
        for (IFabricatorRecipe recipe : recipes) {
            if (!ItemStackUtil.isIdenticalItem(recipe.getPlan(), plan)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addRecipe(IFabricatorRecipe recipe) {
        return recipes.add(recipe);
    }

    @Override
    public boolean removeRecipe(IFabricatorRecipe recipe) {
        return recipes.remove(recipe);
    }

    @Override
    public Set<IFabricatorRecipe> recipes() {
        return Collections.unmodifiableSet(recipes);
    }
}

