/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei;

import forestry.core.gui.GuiForestry;
import forestry.core.utils.JeiUtil;
import forestry.factory.PluginFactory;
import forestry.factory.blocks.BlockRegistryFactory;
import forestry.factory.gui.GuiBottler;
import forestry.factory.gui.GuiCarpenter;
import forestry.factory.gui.GuiCentrifuge;
import forestry.factory.gui.GuiFabricator;
import forestry.factory.gui.GuiFermenter;
import forestry.factory.gui.GuiMoistener;
import forestry.factory.gui.GuiSqueezer;
import forestry.factory.gui.GuiStill;
import forestry.factory.recipes.jei.WorktableRecipeTransferHandler;
import forestry.factory.recipes.jei.bottler.BottlerRecipeCategory;
import forestry.factory.recipes.jei.bottler.BottlerRecipeHandler;
import forestry.factory.recipes.jei.bottler.BottlerRecipeMaker;
import forestry.factory.recipes.jei.carpenter.CarpenterRecipeCategory;
import forestry.factory.recipes.jei.carpenter.CarpenterRecipeHandler;
import forestry.factory.recipes.jei.carpenter.CarpenterRecipeMaker;
import forestry.factory.recipes.jei.carpenter.CarpenterRecipeTransferHandler;
import forestry.factory.recipes.jei.centrifuge.CentrifugeRecipeCategory;
import forestry.factory.recipes.jei.centrifuge.CentrifugeRecipeHandler;
import forestry.factory.recipes.jei.centrifuge.CentrifugeRecipeMaker;
import forestry.factory.recipes.jei.fabricator.FabricatorRecipeCategory;
import forestry.factory.recipes.jei.fabricator.FabricatorRecipeHandler;
import forestry.factory.recipes.jei.fabricator.FabricatorRecipeMaker;
import forestry.factory.recipes.jei.fabricator.FabricatorRecipeTransferHandler;
import forestry.factory.recipes.jei.fermenter.FermenterRecipeCategory;
import forestry.factory.recipes.jei.fermenter.FermenterRecipeHandler;
import forestry.factory.recipes.jei.fermenter.FermenterRecipeMaker;
import forestry.factory.recipes.jei.moistener.MoistenerRecipeCategory;
import forestry.factory.recipes.jei.moistener.MoistenerRecipeHandler;
import forestry.factory.recipes.jei.moistener.MoistenerRecipeMaker;
import forestry.factory.recipes.jei.rainmaker.RainmakerRecipeCategory;
import forestry.factory.recipes.jei.rainmaker.RainmakerRecipeHandler;
import forestry.factory.recipes.jei.rainmaker.RainmakerRecipeMaker;
import forestry.factory.recipes.jei.squeezer.SqueezerContainerRecipeWrapper;
import forestry.factory.recipes.jei.squeezer.SqueezerRecipeCategory;
import forestry.factory.recipes.jei.squeezer.SqueezerRecipeHandler;
import forestry.factory.recipes.jei.squeezer.SqueezerRecipeMaker;
import forestry.factory.recipes.jei.squeezer.SqueezerRecipeWrapper;
import forestry.factory.recipes.jei.still.StillRecipeCategory;
import forestry.factory.recipes.jei.still.StillRecipeHandler;
import forestry.factory.recipes.jei.still.StillRecipeMaker;
import java.awt.Rectangle;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class FactoryJeiPlugin
extends BlankModPlugin {
    public static IJeiHelpers jeiHelpers;

    public void register(@Nonnull IModRegistry registry) {
        jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new BottlerRecipeCategory(guiHelper), new CarpenterRecipeCategory(guiHelper), new CentrifugeRecipeCategory(guiHelper), new FabricatorRecipeCategory(guiHelper), new FermenterRecipeCategory(guiHelper), new MoistenerRecipeCategory(guiHelper), new RainmakerRecipeCategory(guiHelper), new SqueezerRecipeCategory(guiHelper), new StillRecipeCategory(guiHelper)});
        registry.addRecipeHandlers(new IRecipeHandler[]{new BottlerRecipeHandler(), new CarpenterRecipeHandler(), new CentrifugeRecipeHandler(), new FabricatorRecipeHandler(), new FermenterRecipeHandler(), new MoistenerRecipeHandler(), new RainmakerRecipeHandler(), new SqueezerRecipeHandler<SqueezerRecipeWrapper>(SqueezerRecipeWrapper.class), new SqueezerRecipeHandler<SqueezerContainerRecipeWrapper>(SqueezerContainerRecipeWrapper.class), new StillRecipeHandler()});
        registry.addRecipes(BottlerRecipeMaker.getBottlerRecipes(registry.getIngredientRegistry()));
        registry.addRecipes(CarpenterRecipeMaker.getCarpenterRecipes());
        registry.addRecipes(CentrifugeRecipeMaker.getCentrifugeRecipe());
        registry.addRecipes(FabricatorRecipeMaker.getFabricatorRecipes());
        registry.addRecipes(FermenterRecipeMaker.getFermenterRecipes(jeiHelpers.getStackHelper()));
        registry.addRecipes(MoistenerRecipeMaker.getMoistenerRecipes());
        registry.addRecipes(RainmakerRecipeMaker.getRecipes());
        registry.addRecipes(SqueezerRecipeMaker.getSqueezerRecipes());
        registry.addRecipes(SqueezerRecipeMaker.getSqueezerContainerRecipes());
        registry.addRecipes(StillRecipeMaker.getStillRecipes());
        registry.addRecipeClickArea(GuiBottler.class, 107, 33, 26, 22, new String[]{"forestry.bottler"});
        registry.addRecipeClickArea(GuiBottler.class, 45, 33, 26, 22, new String[]{"forestry.bottler"});
        registry.addRecipeClickArea(GuiCarpenter.class, 98, 48, 21, 26, new String[]{"forestry.carpenter"});
        registry.addRecipeClickArea(GuiCentrifuge.class, 38, 22, 38, 14, new String[]{"forestry.centrifuge"});
        registry.addRecipeClickArea(GuiCentrifuge.class, 38, 54, 38, 14, new String[]{"forestry.centrifuge"});
        registry.addRecipeClickArea(GuiFabricator.class, 121, 53, 18, 18, new String[]{"forestry.fabricator"});
        registry.addRecipeClickArea(GuiFermenter.class, 72, 40, 32, 18, new String[]{"forestry.fermenter"});
        registry.addRecipeClickArea(GuiMoistener.class, 123, 35, 19, 21, new String[]{"forestry.moistener"});
        registry.addRecipeClickArea(GuiSqueezer.class, 76, 41, 43, 16, new String[]{"forestry.squeezer"});
        registry.addRecipeClickArea(GuiStill.class, 73, 17, 33, 57, new String[]{"forestry.still"});
        BlockRegistryFactory blocks = PluginFactory.blocks;
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)blocks.bottler), new String[]{"forestry.bottler"});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)blocks.carpenter), new String[]{"forestry.carpenter"});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)blocks.centrifuge), new String[]{"forestry.centrifuge"});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)blocks.fabricator), new String[]{"forestry.fabricator"});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)blocks.fermenter), new String[]{"forestry.fermenter"});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)blocks.moistener), new String[]{"forestry.moistener"});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)blocks.rainmaker), new String[]{"forestry.rainmaker"});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)blocks.squeezer), new String[]{"forestry.squeezer"});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)blocks.still), new String[]{"forestry.still"});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)blocks.worktable), new String[]{"minecraft.crafting"});
        IRecipeTransferRegistry transferRegistry = registry.getRecipeTransferRegistry();
        transferRegistry.addRecipeTransferHandler((IRecipeTransferHandler)new WorktableRecipeTransferHandler());
        transferRegistry.addRecipeTransferHandler((IRecipeTransferHandler)new CarpenterRecipeTransferHandler());
        transferRegistry.addRecipeTransferHandler((IRecipeTransferHandler)new FabricatorRecipeTransferHandler());
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new ForestryAdvancedGuiHandler()});
        JeiUtil.addDescription(registry, blocks.raintank, blocks.worktable);
    }

    private static class ForestryAdvancedGuiHandler
    implements IAdvancedGuiHandler<GuiForestry> {
        private ForestryAdvancedGuiHandler() {
        }

        @Nonnull
        public Class<GuiForestry> getGuiContainerClass() {
            return GuiForestry.class;
        }

        @Nullable
        public List<Rectangle> getGuiExtraAreas(GuiForestry guiContainer) {
            GuiForestry guiForestry = guiContainer;
            return guiForestry.getExtraGuiAreas();
        }
    }
}

