/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.core.network.packets.PacketFXSignal;
import forestry.core.proxy.Proxies;
import forestry.farming.logic.Crop;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CropDestroy
extends Crop {
    protected final IBlockState blockState;
    @Nullable
    protected final IBlockState replantState;

    public CropDestroy(World world, IBlockState blockState, BlockPos position, @Nullable IBlockState replantState) {
        super(world, position);
        this.blockState = blockState;
        this.replantState = replantState;
    }

    @Override
    protected boolean isCrop(World world, BlockPos pos) {
        return world.func_180495_p(pos) == this.blockState;
    }

    @Override
    protected Collection<ItemStack> harvestBlock(World world, BlockPos pos) {
        Block block = this.blockState.func_177230_c();
        List harvested = block.getDrops((IBlockAccess)world, pos, this.blockState, 0);
        PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, pos, this.blockState);
        Proxies.net.sendNetworkPacket(packet, world);
        if (this.replantState != null) {
            world.func_180501_a(pos, this.replantState, 2);
        } else {
            world.func_175698_g(pos);
        }
        return harvested;
    }

    public String toString() {
        return String.format("CropDestroy [ position: [ %s ]; block: %s ]", this.position.toString(), this.blockState);
    }
}

