/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.blocks;

import com.google.common.base.Predicate;
import forestry.api.core.ForestryAPI;
import forestry.api.core.ICamouflagedTile;
import forestry.api.core.IModelManager;
import forestry.api.core.ISpriteRegister;
import forestry.api.core.ITextureManager;
import forestry.api.core.Tabs;
import forestry.api.multiblock.IGreenhouseComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.CreativeTabForestry;
import forestry.core.blocks.BlockStructure;
import forestry.core.blocks.IBlockRotatable;
import forestry.core.blocks.IColoredBlock;
import forestry.core.blocks.propertys.UnlistedBlockAccess;
import forestry.core.blocks.propertys.UnlistedBlockPos;
import forestry.core.multiblock.MultiblockTileEntityForestry;
import forestry.core.tiles.IActivatable;
import forestry.core.utils.CamouflageUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.greenhouse.blocks.BlockGreenhouseDoor;
import forestry.greenhouse.blocks.BlockGreenhouseType;
import forestry.greenhouse.tiles.TileGreenhouseClimateControl;
import forestry.greenhouse.tiles.TileGreenhouseControl;
import forestry.greenhouse.tiles.TileGreenhouseDoor;
import forestry.greenhouse.tiles.TileGreenhouseDryer;
import forestry.greenhouse.tiles.TileGreenhouseFan;
import forestry.greenhouse.tiles.TileGreenhouseGearbox;
import forestry.greenhouse.tiles.TileGreenhouseHatch;
import forestry.greenhouse.tiles.TileGreenhouseHeater;
import forestry.greenhouse.tiles.TileGreenhousePlain;
import forestry.greenhouse.tiles.TileGreenhouseSprinkler;
import forestry.greenhouse.tiles.TileGreenhouseValve;
import forestry.greenhouse.tiles.TileGreenhouseWindow;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockGreenhouse
extends BlockStructure
implements ISpriteRegister,
IColoredBlock,
IBlockRotatable {
    private static final AxisAlignedBB SPRINKLER_BOUNDS = new AxisAlignedBB(0.3125, 0.25, 0.3125, 0.6875, 1.0, 0.6875);
    public static final PropertyEnum<State> STATE = PropertyEnum.func_177709_a((String)"state", State.class);
    public static final PropertyBool BLOCKED = PropertyBool.func_177716_a((String)"blocked");
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public static Map<BlockGreenhouseType, BlockGreenhouse> create() {
        EnumMap<BlockGreenhouseType, BlockGreenhouse> blockMap = new EnumMap<BlockGreenhouseType, BlockGreenhouse>(BlockGreenhouseType.class);
        for (final BlockGreenhouseType type : BlockGreenhouseType.VALUES) {
            if (type == BlockGreenhouseType.BUTTERFLY_HATCH && !ForestryAPI.enabledPlugins.contains("forestry.lepidopterology")) continue;
            BlockGreenhouse block = type == BlockGreenhouseType.DOOR ? new BlockGreenhouseDoor() : new BlockGreenhouse(){

                @Override
                @Nonnull
                public BlockGreenhouseType getGreenhouseType() {
                    return type;
                }

                @Nonnull
                public SoundType func_185467_w() {
                    if (type == BlockGreenhouseType.SPRINKLER || type == BlockGreenhouseType.GLASS || type == BlockGreenhouseType.WINDOW || type == BlockGreenhouseType.WINDOW_UP) {
                        return SoundType.field_185853_f;
                    }
                    return super.func_185467_w();
                }
            };
            blockMap.put(type, block);
        }
        return blockMap;
    }

    public BlockGreenhouse() {
        super(Material.field_151576_e);
        BlockGreenhouseType greenhouseType = this.getGreenhouseType();
        IBlockState defaultState = this.field_176227_L.func_177621_b();
        if (greenhouseType.activatable && greenhouseType != BlockGreenhouseType.SPRINKLER) {
            defaultState = defaultState.func_177226_a(STATE, (Comparable)((Object)State.OFF));
        }
        if (greenhouseType == BlockGreenhouseType.WINDOW || greenhouseType == BlockGreenhouseType.WINDOW_UP) {
            defaultState = defaultState.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
        }
        this.func_180632_j(defaultState);
        this.func_149711_c(1.0f);
        this.setHarvestLevel("pickaxe", 0);
        if (ForestryAPI.enabledPlugins.contains("forestry.farming")) {
            this.func_149647_a(Tabs.tabAgriculture);
        } else {
            this.func_149647_a(CreativeTabForestry.tabForestry);
        }
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (!(tile instanceof MultiblockTileEntityForestry)) {
            return false;
        }
        MultiblockTileEntityForestry part = (MultiblockTileEntityForestry)tile;
        IMultiblockController controller = part.getMultiblockLogic().getController();
        if (player.func_184614_ca() == null) {
            TileGreenhouseWindow window;
            if (tile instanceof TileGreenhouseWindow && (window = (TileGreenhouseWindow)tile).getMode() != TileGreenhouseWindow.WindowMode.CONTROL) {
                if (!worldIn.field_72995_K && window.isBlocked() == TileGreenhouseWindow.WindowMode.OPEN) {
                    if (window.getMode() == TileGreenhouseWindow.WindowMode.OPEN) {
                        window.setMode(TileGreenhouseWindow.WindowMode.PLAYER);
                    } else {
                        window.setMode(TileGreenhouseWindow.WindowMode.OPEN);
                    }
                }
                worldIn.func_180498_a(player, this.getPlaySound(!window.isActive()), pos, 0);
                return true;
            }
            if (player.func_184592_cb() == null) {
                if (controller != null) {
                    String validationError;
                    if (!controller.isAssembled() && (validationError = controller.getLastValidationError()) != null) {
                        long tick = worldIn.func_82737_E();
                        if (tick > this.previousMessageTick + 20L) {
                            player.func_145747_a((ITextComponent)new TextComponentString(validationError));
                            this.previousMessageTick = tick;
                        }
                        return true;
                    }
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("for.multiblock.error.notConnected", new Object[0]));
                    return true;
                }
            }
        }
        if (controller == null || !controller.isAssembled()) {
            return false;
        }
        if (!worldIn.field_72995_K) {
            part.openGui(player);
        }
        return true;
    }

    protected int getPlaySound(boolean open) {
        if (open) {
            return 1007;
        }
        return 1013;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        if (this.getGreenhouseType() == BlockGreenhouseType.SPRINKLER) {
            return SPRINKLER_BOUNDS.func_186670_a(pos);
        }
        return super.func_180640_a(state, worldIn, pos);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        if (this.getGreenhouseType() == BlockGreenhouseType.SPRINKLER) {
            return SPRINKLER_BOUNDS;
        }
        return super.func_180646_a(blockState, worldIn, pos);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.getGreenhouseType() != BlockGreenhouseType.SPRINKLER && this.getGreenhouseType() != BlockGreenhouseType.WINDOW && this.getGreenhouseType() != BlockGreenhouseType.WINDOW_UP) {
            return ((IExtendedBlockState)super.getExtendedState(state, world, pos)).withProperty((IUnlistedProperty)UnlistedBlockPos.POS, (Object)pos).withProperty((IUnlistedProperty)UnlistedBlockAccess.BLOCKACCESS, (Object)world);
        }
        return super.getExtendedState(state, world, pos);
    }

    protected BlockStateContainer func_180661_e() {
        if (this.getGreenhouseType() == BlockGreenhouseType.SPRINKLER) {
            return new ExtendedBlockState((Block)this, new IProperty[]{Properties.StaticProperty}, new IUnlistedProperty[]{Properties.AnimationProperty});
        }
        if (this.getGreenhouseType() == BlockGreenhouseType.WINDOW || this.getGreenhouseType() == BlockGreenhouseType.WINDOW_UP) {
            return new BlockStateContainer((Block)this, new IProperty[]{STATE, FACING});
        }
        if (this.getGreenhouseType().activatable) {
            return new ExtendedBlockState((Block)this, new IProperty[]{STATE}, new IUnlistedProperty[]{UnlistedBlockPos.POS, UnlistedBlockAccess.BLOCKACCESS});
        }
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{UnlistedBlockPos.POS, UnlistedBlockAccess.BLOCKACCESS});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (this.getGreenhouseType() == BlockGreenhouseType.SPRINKLER) {
            return state.func_177226_a((IProperty)Properties.StaticProperty, (Comparable)Boolean.valueOf(true));
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof IActivatable) {
            state = state.func_177226_a(STATE, (Comparable)((Object)(((IActivatable)tile).isActive() ? State.ON : State.OFF)));
        }
        if (tile instanceof TileGreenhouseWindow) {
            TileGreenhouseWindow tileGreenhouseWindow = (TileGreenhouseWindow)tile;
        }
        return super.func_176221_a(state, worldIn, pos);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a(facing));
    }

    public IBlockState func_176203_a(int meta) {
        if (this.getGreenhouseType() == BlockGreenhouseType.WINDOW || this.getGreenhouseType() == BlockGreenhouseType.WINDOW_UP) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.field_82609_l[meta + 2]);
        }
        return super.func_176203_a(meta);
    }

    public int func_176201_c(IBlockState state) {
        if (this.getGreenhouseType() == BlockGreenhouseType.WINDOW || this.getGreenhouseType() == BlockGreenhouseType.WINDOW_UP) {
            return ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal() - 2;
        }
        return 0;
    }

    @Override
    public void rotateAfterPlacement(EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177228_b().containsKey((Object)FACING)) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)player.func_174811_aO().func_176734_d()));
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        try {
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile instanceof TileGreenhouseWindow) {
                ((TileGreenhouseWindow)tile).onNeighborBlockChange();
            }
        }
        catch (StackOverflowError error) {
            Log.error("Stack Overflow Error in BlockMachine.onNeighborBlockChange()", error);
            throw error;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(item));
    }

    public TileEntity func_149915_a(World world, int meta) {
        BlockGreenhouseType type = this.getGreenhouseType();
        switch (type) {
            case GEARBOX: {
                return new TileGreenhouseGearbox();
            }
            case SPRINKLER: {
                return new TileGreenhouseSprinkler();
            }
            case DRYER: {
                return new TileGreenhouseDryer();
            }
            case VALVE: {
                return new TileGreenhouseValve();
            }
            case FAN: {
                return new TileGreenhouseFan();
            }
            case HEATER: {
                return new TileGreenhouseHeater();
            }
            case DOOR: {
                return new TileGreenhouseDoor();
            }
            case CONTROL: {
                return new TileGreenhouseControl();
            }
            case CLIMATE_CONTROL: {
                return new TileGreenhouseClimateControl();
            }
            case WINDOW_UP: 
            case WINDOW: {
                return new TileGreenhouseWindow();
            }
            case HATCH_INPUT: 
            case HATCH_OUTPUT: {
                return new TileGreenhouseHatch();
            }
            case BUTTERFLY_HATCH: {
                return new TileGreenhouseHatch();
            }
        }
        return new TileGreenhousePlain();
    }

    @Override
    public int colorMultiplier(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        if (pos == null) {
            return 0xFFFFFF;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof ICamouflagedTile) {
            Block block;
            ItemStack camouflageStack = CamouflageUtil.getCamouflageBlock(worldIn, pos);
            if (tintIndex < 100 && camouflageStack != null && (block = Block.func_149634_a((Item)camouflageStack.func_77973_b())) != null) {
                IBlockState camouflageState = block.func_176203_a(camouflageStack.func_77952_i());
                int color = Minecraft.func_71410_x().func_184125_al().func_186724_a(camouflageState, worldIn, pos, tintIndex);
                if (color != -1) {
                    return color;
                }
            }
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        if (this.getGreenhouseType() == BlockGreenhouseType.GLASS || this.getGreenhouseType() == BlockGreenhouseType.WINDOW || this.getGreenhouseType() == BlockGreenhouseType.WINDOW_UP || this.getGreenhouseType() == BlockGreenhouseType.SPRINKLER) {
            return BlockRenderLayer.TRANSLUCENT;
        }
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return this.getGreenhouseType() != BlockGreenhouseType.GLASS && this.getGreenhouseType() != BlockGreenhouseType.SPRINKLER && this.getGreenhouseType() != BlockGreenhouseType.WINDOW && this.getGreenhouseType() != BlockGreenhouseType.WINDOW_UP;
    }

    public boolean func_149662_c(IBlockState state) {
        return this.getGreenhouseType() != BlockGreenhouseType.GLASS && this.getGreenhouseType() != BlockGreenhouseType.SPRINKLER && this.getGreenhouseType() != BlockGreenhouseType.WINDOW && this.getGreenhouseType() != BlockGreenhouseType.WINDOW_UP;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        if (this.getGreenhouseType() == BlockGreenhouseType.SPRINKLER) {
            if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
                return false;
            }
            if (!(worldIn.func_175625_s(pos.func_177984_a()) instanceof IGreenhouseComponent)) {
                return false;
            }
        }
        return super.func_176196_c(worldIn, pos);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileGreenhouseWindow) {
            TileGreenhouseWindow window = (TileGreenhouseWindow)tile;
            if (!window.func_145831_w().field_72995_K) {
                window.setMode(window.isBlocked());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = blockAccess.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (this.getGreenhouseType() == BlockGreenhouseType.GLASS) {
            BlockPos posSide = pos.func_177972_a(side);
            if (blockAccess.func_180495_p(posSide) != iblockstate) {
                return true;
            }
            TileEntity tile = blockAccess.func_175625_s(pos);
            TileEntity tileSide = blockAccess.func_175625_s(posSide);
            if (tile instanceof TileGreenhousePlain && tileSide instanceof TileGreenhousePlain && ((TileGreenhousePlain)tile).getCamouflageType().equals(((TileGreenhousePlain)tileSide).getCamouflageType())) {
                ItemStack camouflage = CamouflageUtil.getCamouflageBlock(blockAccess, pos);
                ItemStack camouflageSide = CamouflageUtil.getCamouflageBlock(blockAccess, posSide);
                if (camouflage != null && camouflageSide != null) {
                    return !ItemStackUtil.isIdenticalItem(camouflage, camouflageSide);
                }
            }
            return block != this && super.func_176225_a(blockState, blockAccess, pos, side);
        }
        if (this.getGreenhouseType() == BlockGreenhouseType.DOOR) {
            return super.func_176225_a(blockState, blockAccess, pos, side);
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        if (this.getGreenhouseType() == BlockGreenhouseType.SPRINKLER) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("forestry:greenhouse.sprinkler", "inventory"));
        } else if (this.getGreenhouseType() == BlockGreenhouseType.WINDOW) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("forestry:greenhouse.window", "inventory"));
        } else if (this.getGreenhouseType() == BlockGreenhouseType.WINDOW_UP) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("forestry:greenhouse.window_up", "inventory"));
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("forestry:greenhouse", "inventory"));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSprites(ITextureManager manager) {
        BlockGreenhouseType.registerSprites();
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.getGreenhouseType() == BlockGreenhouseType.CONTROL;
    }

    @Nonnull
    public abstract BlockGreenhouseType getGreenhouseType();

    public static enum State implements IStringSerializable
    {
        ON,
        OFF;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

