/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import forestry.lepidopterology.entities.EntityButterfly;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;

public abstract class AIButterflyBase
extends EntityAIBase {
    protected final EntityButterfly entity;

    protected AIButterflyBase(EntityButterfly entity) {
        this.entity = entity;
    }

    protected Vec3d getRandomDestination() {
        if (this.entity.func_70090_H()) {
            return this.getRandomDestinationUpwards();
        }
        Vec3d randomTarget = RandomPositionGenerator.func_75461_b((EntityCreature)this.entity, (int)16, (int)7, (Vec3d)new Vec3d(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v));
        if (randomTarget == null) {
            return null;
        }
        if (this.validateDestination(randomTarget, false)) {
            return randomTarget;
        }
        return null;
    }

    protected Vec3d getRandomDestinationUpwards() {
        Vec3d destination = new Vec3d(this.entity.field_70165_t, this.entity.field_70163_u + (double)this.entity.func_70681_au().nextInt(10) + 2.0, this.entity.field_70161_v);
        if (this.validateDestination(destination, true)) {
            return destination;
        }
        return null;
    }

    private boolean validateDestination(Vec3d dest, boolean allowFluids) {
        if (dest.field_72448_b < 1.0) {
            return false;
        }
        BlockPos pos = new BlockPos(dest);
        if (!this.entity.field_70170_p.func_175667_e(pos)) {
            return false;
        }
        IBlockState blockState = this.entity.field_70170_p.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (!allowFluids && block.func_149688_o(blockState).func_76224_d()) {
            return false;
        }
        if (!block.func_176205_b((IBlockAccess)this.entity.field_70170_p, pos)) {
            return false;
        }
        return this.entity.getButterfly().isAcceptedEnvironment(this.entity.field_70170_p, dest.field_72450_a, dest.field_72448_b, dest.field_72449_c);
    }
}

