/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterfly;
import forestry.core.config.Config;
import forestry.core.genetics.GenericRatings;
import forestry.core.genetics.alleles.AlleleBoolean;
import forestry.core.gui.GuiAlyzer;
import forestry.core.gui.TextLayoutHelper;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Translator;
import forestry.lepidopterology.PluginLepidopterology;
import forestry.lepidopterology.genetics.ButterflyGenome;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FlutterlyzerPlugin
implements IAlyzerPlugin {
    public static final FlutterlyzerPlugin INSTANCE = new FlutterlyzerPlugin();
    protected final Map<String, ItemStack> iconStacks = new HashMap<String, ItemStack>();

    private FlutterlyzerPlugin() {
        ArrayList<ItemStack> butterflyList = new ArrayList<ItemStack>();
        PluginLepidopterology.items.butterflyGE.addCreativeItems(butterflyList, false);
        for (ItemStack butterflyStack : butterflyList) {
            IAlleleButterflySpecies species = ButterflyGenome.getSpecies(butterflyStack);
            if (species == null) continue;
            this.iconStacks.put(species.getUID(), butterflyStack);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawAnalyticsPage1(GuiScreen gui, ItemStack itemStack) {
        if (gui instanceof GuiAlyzer) {
            GuiAlyzer guiAlyzer = (GuiAlyzer)gui;
            IButterfly butterfly = ButterflyManager.butterflyRoot.getMember(itemStack);
            if (butterfly == null) {
                return;
            }
            TextLayoutHelper textLayout = guiAlyzer.getTextLayout();
            textLayout.startPage(12, 90, 155);
            textLayout.drawLine(Translator.translateToLocal("for.gui.active"), 90);
            textLayout.drawLine(Translator.translateToLocal("for.gui.inactive"), 155);
            textLayout.newLine();
            textLayout.newLine();
            guiAlyzer.drawSpeciesRow(Translator.translateToLocal("for.gui.species"), butterfly, EnumButterflyChromosome.SPECIES, null, null);
            textLayout.newLine();
            guiAlyzer.drawRow(Translator.translateToLocal("for.gui.size"), butterfly.getGenome().getActiveAllele(EnumButterflyChromosome.SIZE).getName(), butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.SIZE).getName(), butterfly, EnumButterflyChromosome.SPEED);
            textLayout.newLine();
            guiAlyzer.drawRow(Translator.translateToLocal("for.gui.lifespan"), butterfly.getGenome().getActiveAllele(EnumButterflyChromosome.LIFESPAN).getName(), butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.LIFESPAN).getName(), butterfly, EnumButterflyChromosome.LIFESPAN);
            textLayout.newLine();
            guiAlyzer.drawRow(Translator.translateToLocal("for.gui.speed"), butterfly.getGenome().getActiveAllele(EnumButterflyChromosome.SPEED).getName(), butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.SPEED).getName(), butterfly, EnumButterflyChromosome.SPEED);
            textLayout.newLine();
            guiAlyzer.drawRow(Translator.translateToLocal("for.gui.metabolism"), GenericRatings.rateMetabolism(butterfly.getGenome().getMetabolism()), GenericRatings.rateMetabolism(((IAlleleInteger)butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.METABOLISM)).getValue()), butterfly, EnumButterflyChromosome.METABOLISM);
            textLayout.newLine();
            textLayout.drawLine(Translator.translateToLocal("for.gui.fertility"), 12);
            guiAlyzer.drawFertilityInfo(butterfly.getGenome().getFertility(), 90, guiAlyzer.getColorCoding(butterfly.getGenome().getActiveAllele(EnumButterflyChromosome.FERTILITY).isDominant()), 8);
            guiAlyzer.drawFertilityInfo(((IAlleleInteger)butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.FERTILITY)).getValue(), 155, guiAlyzer.getColorCoding(butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.FERTILITY).isDominant()), 8);
            textLayout.newLine();
            guiAlyzer.drawRow(Translator.translateToLocal("for.gui.flowers"), butterfly.getGenome().getFlowerProvider().getDescription(), ((IAlleleFlowers)butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.FLOWER_PROVIDER)).getProvider().getDescription(), butterfly, EnumButterflyChromosome.FLOWER_PROVIDER);
            textLayout.newLine();
            guiAlyzer.drawRow(Translator.translateToLocal("for.gui.effect"), butterfly.getGenome().getEffect().getName(), butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.EFFECT).getName(), butterfly, EnumButterflyChromosome.EFFECT);
            textLayout.newLine();
            textLayout.endPage();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawAnalyticsPage2(GuiScreen gui, ItemStack itemStack) {
        if (gui instanceof GuiAlyzer) {
            String nocturnal1;
            String diurnal1;
            String nocturnal0;
            String diurnal0;
            GuiAlyzer guiAlyzer = (GuiAlyzer)gui;
            IButterfly butterfly = ButterflyManager.butterflyRoot.getMember(itemStack);
            if (butterfly == null) {
                return;
            }
            TextLayoutHelper textLayout = guiAlyzer.getTextLayout();
            textLayout.startPage(12, 90, 155);
            textLayout.drawLine(Translator.translateToLocal("for.gui.active"), 90);
            textLayout.drawLine(Translator.translateToLocal("for.gui.inactive"), 155);
            textLayout.newLine();
            textLayout.newLine();
            guiAlyzer.drawRow(Translator.translateToLocal("for.gui.climate"), AlleleManager.climateHelper.toDisplay(butterfly.getGenome().getPrimary().getTemperature()), AlleleManager.climateHelper.toDisplay(butterfly.getGenome().getPrimary().getTemperature()), butterfly, EnumButterflyChromosome.SPECIES);
            textLayout.newLine();
            IAlleleTolerance tempToleranceActive = (IAlleleTolerance)butterfly.getGenome().getActiveAllele(EnumButterflyChromosome.TEMPERATURE_TOLERANCE);
            IAlleleTolerance tempToleranceInactive = (IAlleleTolerance)butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.TEMPERATURE_TOLERANCE);
            textLayout.drawLine("  " + Translator.translateToLocal("for.gui.tolerance"), 12);
            guiAlyzer.drawToleranceInfo(tempToleranceActive, 90);
            guiAlyzer.drawToleranceInfo(tempToleranceInactive, 155);
            textLayout.newLine();
            guiAlyzer.drawRow(Translator.translateToLocal("for.gui.humidity"), AlleleManager.climateHelper.toDisplay(butterfly.getGenome().getPrimary().getHumidity()), AlleleManager.climateHelper.toDisplay(butterfly.getGenome().getPrimary().getHumidity()), butterfly, EnumButterflyChromosome.SPECIES);
            textLayout.newLine();
            IAlleleTolerance humidToleranceActive = (IAlleleTolerance)butterfly.getGenome().getActiveAllele(EnumButterflyChromosome.HUMIDITY_TOLERANCE);
            IAlleleTolerance humidToleranceInactive = (IAlleleTolerance)butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.HUMIDITY_TOLERANCE);
            textLayout.drawLine("  " + Translator.translateToLocal("for.gui.tolerance"), 12);
            guiAlyzer.drawToleranceInfo(humidToleranceActive, 90);
            guiAlyzer.drawToleranceInfo(humidToleranceInactive, 155);
            textLayout.newLine();
            textLayout.newLine();
            String yes = Translator.translateToLocal("for.yes");
            String no = Translator.translateToLocal("for.no");
            if (butterfly.getGenome().getNocturnal()) {
                nocturnal0 = diurnal0 = yes;
            } else {
                nocturnal0 = butterfly.getGenome().getPrimary().isNocturnal() ? yes : no;
                String string = diurnal0 = !butterfly.getGenome().getPrimary().isNocturnal() ? yes : no;
            }
            if (((AlleleBoolean)butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.NOCTURNAL)).getValue()) {
                nocturnal1 = diurnal1 = yes;
            } else {
                nocturnal1 = butterfly.getGenome().getSecondary().isNocturnal() ? yes : no;
                diurnal1 = !butterfly.getGenome().getSecondary().isNocturnal() ? yes : no;
            }
            textLayout.drawLine(Translator.translateToLocal("for.gui.diurnal"), 12);
            textLayout.drawLine(diurnal0, 90, guiAlyzer.getColorCoding(false));
            textLayout.drawLine(diurnal1, 155, guiAlyzer.getColorCoding(false));
            textLayout.newLine();
            textLayout.drawLine(Translator.translateToLocal("for.gui.nocturnal"), 12);
            textLayout.drawLine(nocturnal0, 90, guiAlyzer.getColorCoding(false));
            textLayout.drawLine(nocturnal1, 155, guiAlyzer.getColorCoding(false));
            textLayout.newLine();
            String primary = StringUtil.readableBoolean(butterfly.getGenome().getTolerantFlyer(), yes, no);
            String secondary = StringUtil.readableBoolean(((AlleleBoolean)butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.TOLERANT_FLYER)).getValue(), yes, no);
            guiAlyzer.drawRow(Translator.translateToLocal("for.gui.flyer"), primary, secondary, butterfly, EnumButterflyChromosome.TOLERANT_FLYER);
            textLayout.newLine();
            primary = StringUtil.readableBoolean(butterfly.getGenome().getFireResist(), yes, no);
            secondary = StringUtil.readableBoolean(((AlleleBoolean)butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.FIRE_RESIST)).getValue(), yes, no);
            guiAlyzer.drawRow(Translator.translateToLocal("for.gui.fireresist"), primary, secondary, butterfly, EnumButterflyChromosome.FIRE_RESIST);
            textLayout.endPage();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawAnalyticsPage3(GuiScreen gui, ItemStack itemStack) {
        if (gui instanceof GuiAlyzer) {
            GuiAlyzer guiAlyzer = (GuiAlyzer)gui;
            IButterfly butterfly = ButterflyManager.butterflyRoot.getMember(itemStack);
            if (butterfly == null) {
                return;
            }
            TextLayoutHelper textLayout = guiAlyzer.getTextLayout();
            textLayout.startPage(12, 90, 155);
            textLayout.drawLine(Translator.translateToLocal("for.gui.loot.butterfly") + ":", 12);
            textLayout.newLine();
            int x = 12;
            for (ItemStack stack : butterfly.getGenome().getPrimary().getButterflyLoot().keySet()) {
                Proxies.common.getClientInstance().func_175599_af().func_175042_a(stack, guiAlyzer.getGuiLeft() + x, guiAlyzer.getGuiTop() + textLayout.getLineY());
                if ((x += 18) <= 148) continue;
                x = 12;
                textLayout.newLine();
            }
            textLayout.newLine();
            textLayout.newLine();
            textLayout.drawLine(Translator.translateToLocal("for.gui.loot.caterpillar") + ":", 12);
            textLayout.newLine();
            x = 12;
            for (ItemStack stack : butterfly.getGenome().getPrimary().getCaterpillarLoot().keySet()) {
                Proxies.common.getClientInstance().func_175599_af().func_175042_a(stack, guiAlyzer.getGuiLeft() + x, guiAlyzer.getGuiTop() + textLayout.getLineY());
                if ((x += 18) <= 148) continue;
                x = 12;
                textLayout.newLine();
            }
            textLayout.endPage();
        }
    }

    @Override
    public Map<String, ItemStack> getIconStacks() {
        return this.iconStacks;
    }

    @Override
    public List<String> getHints() {
        return Config.hints.get((Object)"flutterlyzer");
    }
}

