/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import forestry.core.utils.Log;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.IForestryPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.discovery.ASMDataTable;

public class ForestryPluginUtil {
    private ForestryPluginUtil() {
    }

    public static List<IForestryPlugin> getForestryPlugins(@Nonnull ASMDataTable asmDataTable) {
        return ForestryPluginUtil.getInstances(asmDataTable, ForestryPlugin.class, IForestryPlugin.class);
    }

    private static <T> List<T> getInstances(@Nonnull ASMDataTable asmDataTable, Class annotationClass, Class<T> instanceClass) {
        String annotationClassName = annotationClass.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        ArrayList<T> instances = new ArrayList<T>();
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                Class<?> asmClass = Class.forName(asmData.getClassName());
                Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                T instance = asmInstanceClass.newInstance();
                instances.add(instance);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                Log.error("Failed to load: {}", asmData.getClassName(), e);
            }
        }
        return instances;
    }
}

