/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.packet.PacketCustom;
import codechicken.lib.util.ClientUtils;
import codechicken.nei.DefaultHighlightHandler;
import codechicken.nei.HUDRenderer;
import codechicken.nei.KeyManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIController;
import codechicken.nei.WorldOverlayRenderer;
import codechicken.nei.api.API;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.jei.gui.ContainerEventHandler;
import codechicken.nei.network.NEIClientPacketHandler;
import codechicken.nei.util.NEIClientUtils;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiWorldSelection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.CustomModLoadingErrorDisplayException;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ClientHandler {
    private static ClientHandler instance;
    private ArrayList<EntityItem> SMPmagneticItems = new ArrayList();
    private World lastworld;
    private GuiScreen lastGui;

    public void addSMPMagneticItem(int i, World world) {
        Entity e = world.func_73045_a(i);
        if (e instanceof EntityItem) {
            this.SMPmagneticItems.add((EntityItem)e);
        }
    }

    private void updateMagnetMode(World world, EntityPlayerSP player) {
        if (!NEIClientConfig.getMagnetMode()) {
            return;
        }
        float distancexz = 16.0f;
        float distancey = 8.0f;
        double maxspeedxz = 0.5;
        double maxspeedy = 0.5;
        double speedxz = 0.05;
        double speedy = 0.07;
        Iterator<EntityItem> iterator = this.SMPmagneticItems.iterator();
        while (iterator.hasNext()) {
            double rationspeedy;
            EntityItem item = iterator.next();
            if (item.func_174874_s()) continue;
            if (item.field_70128_L) {
                iterator.remove();
            }
            if (!NEIClientUtils.canItemFitInInventory((EntityPlayer)player, item.func_92059_d())) continue;
            double dx = player.field_70165_t - item.field_70165_t;
            double dy = player.field_70163_u + (double)player.func_70047_e() - item.field_70163_u;
            double dz = player.field_70161_v - item.field_70161_v;
            double absxz = Math.sqrt(dx * dx + dz * dz);
            double absy = Math.abs(dy);
            if (absxz > (double)distancexz || absy > (double)distancey) continue;
            if (absxz > 1.0) {
                dx /= absxz;
                dz /= absxz;
            }
            if (absy > 1.0) {
                dy /= absy;
            }
            double vx = item.field_70159_w + speedxz * dx;
            double vy = item.field_70181_x + speedy * dy;
            double vz = item.field_70179_y + speedxz * dz;
            double absvxz = Math.sqrt(vx * vx + vz * vz);
            double absvy = Math.abs(vy);
            double rationspeedxz = absvxz / maxspeedxz;
            if (rationspeedxz > 1.0) {
                vx /= rationspeedxz;
                vz /= rationspeedxz;
            }
            if ((rationspeedy = absvy / maxspeedy) > 1.0) {
                vy /= rationspeedy;
            }
            if (absvxz < 0.2 && absxz < 0.2) {
                item.func_70106_y();
            }
            item.func_70016_h(vx, vy, vz);
        }
    }

    public static void preInit() {
        ItemInfo.preInit();
    }

    public static void init() {
        instance = new ClientHandler();
        PacketCustom.assignHandler((Object)"NEI", (PacketCustom.ICustomPacketHandler)new NEIClientPacketHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ContainerEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)instance);
        ItemInfo.init();
        API.registerHighlightHandler(new DefaultHighlightHandler(), ItemInfo.Layout.HEADER);
        HUDRenderer.load();
        WorldOverlayRenderer.load();
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.ClientTickEvent event) {
        GuiScreen gui;
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null) {
            if (this.loadWorld((World)mc.field_71441_e)) {
                NEIClientConfig.setHasSMPCounterPart(false);
                NEIClientConfig.setInternalEnabled(false);
                if (!Minecraft.func_71410_x().func_71356_B()) {
                    NEIClientConfig.loadWorld("remote/" + ClientUtils.getServerIP().replace(':', '~'));
                }
            }
            if (!NEIClientConfig.isEnabled()) {
                return;
            }
            KeyManager.tickKeyStates();
            NEIController.updateUnlimitedItems(mc.field_71439_g.field_71071_by);
            if (mc.field_71462_r == null) {
                NEIController.processCreativeCycling(mc.field_71439_g.field_71071_by);
            }
            this.updateMagnetMode((World)mc.field_71441_e, mc.field_71439_g);
        }
        if ((gui = mc.field_71462_r) != this.lastGui) {
            if (gui instanceof GuiMainMenu) {
                this.lastworld = null;
            } else if (gui instanceof GuiWorldSelection) {
                NEIClientConfig.reloadSaves();
            }
        }
        this.lastGui = gui;
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && NEIClientConfig.isEnabled()) {
            HUDRenderer.renderOverlay();
        }
    }

    @SubscribeEvent
    public void renderLastEvent(RenderWorldLastEvent event) {
        if (NEIClientConfig.isEnabled()) {
            WorldOverlayRenderer.render(event.getPartialTicks());
        }
    }

    public boolean loadWorld(World world) {
        if (world != this.lastworld) {
            this.SMPmagneticItems.clear();
            WorldOverlayRenderer.reset();
            this.lastworld = world;
            return true;
        }
        return false;
    }

    public static ClientHandler instance() {
        return instance;
    }

    public static RuntimeException throwCME(final String message) {
        GuiErrorScreen errorGui = new GuiErrorScreen(null, null){

            public void func_146274_d() {
            }

            public void func_146282_l() {
            }

            public void func_73863_a(int par1, int par2, float par3) {
                this.func_146276_q_();
                String[] s_msg = message.split("\n");
                for (int i = 0; i < s_msg.length; ++i) {
                    this.func_73732_a(this.field_146289_q, s_msg[i], this.field_146294_l / 2, this.field_146295_m / 3 + 12 * i, -1);
                }
            }
        };
        CustomModLoadingErrorDisplayException e = new CustomModLoadingErrorDisplayException((GuiScreen)errorGui){
            final /* synthetic */ GuiScreen val$errorGui;
            {
                this.val$errorGui = guiScreen;
            }

            public void initGui(GuiErrorScreen errorScreen, FontRenderer fontRenderer) {
                Minecraft.func_71410_x().func_147108_a(this.val$errorGui);
            }

            public void drawScreen(GuiErrorScreen errorScreen, FontRenderer fontRenderer, int mouseRelX, int mouseRelY, float tickTime) {
            }
        };
        throw e;
    }
}

