/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.capability.projectile;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.capability.projectile.ITinkerProjectile;
import slimeknights.tconstruct.library.tools.ranged.IAmmo;
import slimeknights.tconstruct.library.traits.IProjectileTrait;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.AmmoHelper;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class TinkerProjectileHandler
implements ITinkerProjectile,
INBTSerializable<NBTTagCompound> {
    public static final String TAG_PARENT = "parent";
    public static final String TAG_LAUNCHER = "launcher";
    private ItemStack parent;
    private ItemStack launcher;
    private List<IProjectileTrait> projectileTraitList = Lists.newArrayList();

    @Override
    public ItemStack getItemStack() {
        return this.parent;
    }

    @Override
    public void setItemStack(ItemStack stack) {
        this.parent = stack;
        this.updateTraits();
    }

    @Override
    @Nullable
    public ItemStack getLaunchingStack() {
        return this.launcher;
    }

    @Override
    public void setLaunchingStack(ItemStack launchingStack) {
        this.launcher = launchingStack;
    }

    @Override
    public List<IProjectileTrait> getProjectileTraits() {
        return this.projectileTraitList;
    }

    private void updateTraits() {
        if (this.parent != null) {
            this.projectileTraitList.clear();
            NBTTagList list = TagUtil.getTraitsTagList(this.parent);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ITrait trait = TinkerRegistry.getTrait(list.func_150307_f(i));
                if (!(trait instanceof IProjectileTrait)) continue;
                this.projectileTraitList.add((IProjectileTrait)trait);
            }
        }
    }

    @Override
    public boolean pickup(EntityLivingBase entity, boolean simulate) {
        ItemStack stack = AmmoHelper.getMatchingItemstackFromInventory(this.parent, (Entity)entity, true);
        if (stack != null && stack.func_77973_b() instanceof IAmmo) {
            if (!simulate && this.parent.field_77994_a > 0) {
                ToolHelper.unbreakTool(stack);
                ((IAmmo)stack.func_77973_b()).addAmmo(stack, entity);
            }
            return true;
        }
        return false;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.parent != null) {
            tag.func_74782_a(TAG_PARENT, (NBTBase)this.parent.func_77955_b(new NBTTagCompound()));
        }
        if (this.launcher != null) {
            tag.func_74782_a(TAG_LAUNCHER, (NBTBase)this.launcher.func_77955_b(new NBTTagCompound()));
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.parent = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l(TAG_PARENT));
        if (this.parent == null) {
            this.parent = ItemStack.func_77949_a((NBTTagCompound)nbt);
        }
        this.launcher = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l(TAG_LAUNCHER));
        this.updateTraits();
    }
}

