/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.ranged;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.client.BooleanItemPropertyGetter;
import slimeknights.tconstruct.library.events.ProjectileEvent;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IAmmoUser;
import slimeknights.tconstruct.library.tools.ProjectileLauncherNBT;
import slimeknights.tconstruct.library.tools.ranged.IAmmo;
import slimeknights.tconstruct.library.tools.ranged.ProjectileLauncherCore;
import slimeknights.tconstruct.library.utils.AmmoHelper;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.ranged.TinkerRangedWeapons;

public abstract class BowCore
extends ProjectileLauncherCore
implements IAmmoUser {
    protected static final ResourceLocation PROPERTY_PULL = new ResourceLocation("pull");
    protected static final ResourceLocation PROPERTY_PULLING = new ResourceLocation("pulling");

    public BowCore(PartMaterialType ... requiredComponents) {
        super(requiredComponents);
        this.addCategory(Category.LAUNCHER);
        this.func_185043_a(PROPERTY_PULL, new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entityIn.func_184607_cu();
                return BowCore.this.getDrawbackProgress(itemstack, entityIn);
            }
        });
        this.func_185043_a(PROPERTY_PULLING, new BooleanItemPropertyGetter(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public boolean applyIf(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack;
            }
        });
    }

    protected float baseInaccuracy() {
        return 0.0f;
    }

    protected float baseProjectileSpeed() {
        return 3.0f;
    }

    protected int getDrawTime() {
        return 20;
    }

    protected float getDrawbackProgress(ItemStack itemStack, EntityLivingBase entityIn) {
        ItemStack itemstack = entityIn.func_184607_cu();
        if (itemstack != null && itemstack.func_77973_b() == this) {
            int timePassed = itemstack.func_77988_m() - entityIn.func_184605_cv();
            return this.getDrawbackProgress(itemstack, timePassed);
        }
        return 0.0f;
    }

    protected float getDrawbackProgress(ItemStack itemStack, int timePassed) {
        float drawProgress = ProjectileLauncherNBT.from((ItemStack)itemStack).drawSpeed * (float)timePassed;
        return Math.min(1.0f, drawProgress / (float)this.getDrawTime());
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (!ToolHelper.isBroken(itemStackIn)) {
            boolean hasAmmo = this.findAmmo(itemStackIn, (EntityLivingBase)playerIn) != null;
            ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)itemStackIn, (World)worldIn, (EntityPlayer)playerIn, (EnumHand)hand, (boolean)hasAmmo);
            if (ret != null) {
                return ret;
            }
            if (playerIn.field_71075_bZ.field_75098_d || hasAmmo) {
                playerIn.func_184598_c(hand);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (ToolHelper.isBroken(stack) || !(entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        ItemStack ammo = this.findAmmo(stack, entityLiving);
        if (ammo == null && !player.field_71075_bZ.field_75098_d) {
            return;
        }
        int useTime = this.func_77626_a(stack) - timeLeft;
        if ((useTime = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (EntityPlayer)player, (int)useTime, (ammo != null ? 1 : 0) != 0)) < 5) {
            return;
        }
        if (ammo == null) {
            ammo = this.getCreativeProjectileStack();
        }
        this.shootProjectile(ammo, stack, worldIn, player, useTime);
        player.func_71029_a(StatList.func_188057_b((Item)this));
        TinkerRangedWeapons.proxy.updateEquippedItemForRendering(entityLiving.func_184600_cs());
        TagUtil.setResetFlag(stack, true);
    }

    public void shootProjectile(ItemStack ammo, ItemStack bow, World worldIn, EntityPlayer player, int useTime) {
        float power = ItemBow.func_185059_b((int)useTime) * this.getDrawbackProgress(bow, useTime) * this.baseProjectileSpeed();
        power *= ProjectileLauncherNBT.from((ItemStack)bow).range;
        if (!worldIn.field_72995_K) {
            TinkerToolEvent.OnBowShoot event = TinkerToolEvent.OnBowShoot.fireEvent(bow, ammo, player, useTime);
            for (int i = 0; i < event.projectileCount; ++i) {
                EntityArrow projectile;
                boolean usedAmmo = false;
                if (i == 0 || event.consumeAmmoPerProjectile) {
                    usedAmmo = this.consumeAmmo(ammo, player);
                }
                if ((projectile = this.getProjectileEntity(ammo, bow, worldIn, player, power, this.baseInaccuracy(), usedAmmo)) == null || !ProjectileEvent.OnLaunch.fireEvent((Entity)projectile, bow, (EntityLivingBase)player)) continue;
                if (!player.field_71075_bZ.field_75098_d) {
                    ToolHelper.damageTool(bow, 1, (EntityLivingBase)player);
                }
                worldIn.func_72838_d((Entity)projectile);
            }
        }
        this.playShootSound(power, worldIn, player);
    }

    public EntityArrow getProjectileEntity(ItemStack ammo, ItemStack bow, World world, EntityPlayer player, float power, float inaccuracy, boolean usedAmmo) {
        if (ammo.func_77973_b() instanceof IAmmo) {
            return ((IAmmo)ammo.func_77973_b()).getProjectile(ammo, bow, world, player, power, inaccuracy, usedAmmo);
        }
        if (ammo.func_77973_b() instanceof ItemArrow) {
            EntityArrow projectile = ((ItemArrow)ammo.func_77973_b()).func_185052_a(world, ammo, (EntityLivingBase)player);
            projectile.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, power, inaccuracy);
            if (player.field_71075_bZ.field_75098_d) {
                projectile.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
            } else if (!usedAmmo) {
                projectile.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
            }
            return projectile;
        }
        return null;
    }

    public boolean consumeAmmo(ItemStack ammo, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (ammo.func_77973_b() instanceof IAmmo) {
            return ((IAmmo)ammo.func_77973_b()).useAmmo(ammo, (EntityLivingBase)player);
        }
        --ammo.field_77994_a;
        if (ammo.field_77994_a == 0) {
            player.field_71071_by.func_184437_d(ammo);
        }
        return true;
    }

    protected ItemStack getCreativeProjectileStack() {
        return new ItemStack(Items.field_151032_g);
    }

    public void playShootSound(float power, World world, EntityPlayer entityPlayer) {
        world.func_184148_a(null, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + power * 0.5f);
    }

    @Override
    public ItemStack findAmmo(ItemStack weapon, EntityLivingBase player) {
        return AmmoHelper.findAmmoFromInventory(this.getAmmoItems(), (Entity)player);
    }

    @Override
    public ItemStack getAmmoToRender(ItemStack weapon, EntityLivingBase player) {
        if (ToolHelper.isBroken(weapon)) {
            return null;
        }
        return this.findAmmo(weapon, player);
    }

    protected abstract List<Item> getAmmoItems();
}

