/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block;

import com.google.common.base.Predicate;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.tconstruct.smeltery.block.BlockEnumSmeltery;
import slimeknights.tconstruct.smeltery.tileentity.TileDrain;

public class BlockSmelteryIO
extends BlockEnumSmeltery<IOType> {
    public static final PropertyEnum<IOType> TYPE = PropertyEnum.func_177709_a((String)"type", IOType.class);
    public static PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockSmelteryIO() {
        super(TYPE, IOType.class);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, FACING});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        int horIndex = meta >> 2 & 0xF;
        return this.func_176223_P().func_177226_a((IProperty)this.prop, (Comparable)((Object)this.fromMeta(meta))).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.field_176754_o[horIndex]);
    }

    public int func_176201_c(IBlockState state) {
        return ((IOType)((Object)state.func_177229_b((IProperty)this.prop))).getMeta() | ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() << 2;
    }

    public int func_180651_a(IBlockState state) {
        return ((IOType)((Object)state.func_177229_b((IProperty)this.prop))).getMeta();
    }

    @Override
    @Nonnull
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TileDrain();
    }

    @Nonnull
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing side = placer.func_174811_aO().func_176734_d();
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)side);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((World)worldIn, (BlockPos)pos, null);
        if (fluidHandler == null) {
            return false;
        }
        IItemHandler playerInventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        if (FluidUtil.tryEmptyContainerAndStow((ItemStack)heldItem, (IFluidHandler)fluidHandler, (IItemHandler)playerInventory, (int)1000, (EntityPlayer)player)) {
            return true;
        }
        return FluidUtil.getFluidHandler((ItemStack)heldItem) != null;
    }

    public static enum IOType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        DRAIN;

        public final int meta = this.ordinal();

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

