/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.ArrowShaftMaterialStats;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.BowStringMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.FletchingMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.TinkerTraits;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.BlockSlimeGrass;

@Pulse(id="TinkerMaterials", description="All the tool materials added by TConstruct", pulsesRequired="TinkerTools", forced=true)
public final class TinkerMaterials {
    static final String PulseId = "TinkerMaterials";
    static final Logger log = Util.getLogger("TinkerMaterials");
    public static final List<Material> materials = Lists.newArrayList();
    public static final Material wood = TinkerMaterials.mat("wood", 9332251);
    public static final Material stone = TinkerMaterials.mat("stone", 0x999999);
    public static final Material flint = TinkerMaterials.mat("flint", 0x696969);
    public static final Material cactus = TinkerMaterials.mat("cactus", 41231);
    public static final Material bone = TinkerMaterials.mat("bone", 15591103);
    public static final Material obsidian = TinkerMaterials.mat("obsidian", 6298820);
    public static final Material prismarine = TinkerMaterials.mat("prismarine", 8314556);
    public static final Material endstone = TinkerMaterials.mat("endstone", 14735504);
    public static final Material paper = TinkerMaterials.mat("paper", 0xFFFFFF);
    public static final Material sponge = TinkerMaterials.mat("sponge", 13290574);
    public static final Material firewood = TinkerMaterials.mat("firewood", 13390592);
    public static final Material knightslime = TinkerMaterials.mat("knightslime", 15831024);
    public static final Material slime = TinkerMaterials.mat("slime", 8570995);
    public static final Material blueslime = TinkerMaterials.mat("blueslime", 7653575);
    public static final Material magmaslime = TinkerMaterials.mat("magmaslime", 16750093);
    public static final Material iron = TinkerMaterials.mat("iron", 0xCACACA);
    public static final Material pigiron = TinkerMaterials.mat("pigiron", 15703707);
    public static final Material netherrack = TinkerMaterials.mat("netherrack", 12078927);
    public static final Material ardite = TinkerMaterials.mat("ardite", 13713936);
    public static final Material cobalt = TinkerMaterials.mat("cobalt", 2654932);
    public static final Material manyullyn = TinkerMaterials.mat("manyullyn", 10575096);
    public static final Material copper = TinkerMaterials.mat("copper", 15572743);
    public static final Material bronze = TinkerMaterials.mat("bronze", 14925160);
    public static final Material lead = TinkerMaterials.mat("lead", 5065064);
    public static final Material silver = TinkerMaterials.mat("silver", 13757686);
    public static final Material electrum = TinkerMaterials.mat("electrum", 15260489);
    public static final Material steel = TinkerMaterials.mat("steel", 0xA7A7A7);
    public static final Material xu;
    public static final Material string;
    public static final Material vine;
    public static final Material slimevine_blue;
    public static final Material slimevine_purple;
    public static final Material blaze;
    public static final Material reed;
    public static final Material ice;
    public static final Material endrod;
    public static final Material feather;
    public static final Material leaf;
    public static final Material slimeleaf_blue;
    public static final Material slimeleaf_orange;
    public static final Material slimeleaf_purple;

    private static Material mat(String name, int color) {
        Material mat = new Material(name, color);
        materials.add(mat);
        return mat;
    }

    @Subscribe
    public void setupMaterials(FMLInitializationEvent event) {
        wood.setCraftable(true);
        wood.addItem("stickWood", 1, 72);
        wood.addItem("plankWood", 1, 144);
        wood.addItem("logWood", 1, 576);
        wood.addTrait(TinkerTraits.ecological, "head");
        wood.addTrait(TinkerTraits.splinters);
        wood.addTrait(TinkerTraits.ecological);
        stone.setCraftable(true);
        stone.addItemIngot("cobblestone");
        stone.addItemIngot("stone");
        stone.setRepresentativeItem(new ItemStack(Blocks.field_150347_e));
        stone.addTrait(TinkerTraits.cheapskate, "head");
        stone.addTrait(TinkerTraits.cheap);
        flint.setCraftable(true);
        flint.addItem(Items.field_151145_ak, 1, 144);
        flint.setRepresentativeItem(new ItemStack(Items.field_151145_ak));
        flint.addTrait(TinkerTraits.crude2, "head");
        flint.addTrait(TinkerTraits.crude);
        cactus.setCraftable(true);
        cactus.addItemIngot("blockCactus");
        cactus.setRepresentativeItem(new ItemStack((Block)Blocks.field_150434_aF));
        cactus.addTrait(TinkerTraits.prickly, "head");
        cactus.addTrait(TinkerTraits.spiky);
        obsidian.setFluid(TinkerFluids.obsidian);
        obsidian.setCraftable(true);
        obsidian.setCastable(true);
        obsidian.addItemIngot("obsidian");
        obsidian.setRepresentativeItem(new ItemStack(Blocks.field_150343_Z));
        obsidian.addTrait(TinkerTraits.duritos);
        prismarine.setCraftable(true);
        prismarine.addItem("gemPrismarine", 1, 36);
        prismarine.addItem("blockPrismarine", 1, 144);
        prismarine.addItem("blockPrismarineBrick", 1, 324);
        prismarine.addItem("blockPrismarineDark", 1, 288);
        prismarine.setRepresentativeItem(Blocks.field_180397_cI);
        prismarine.addTrait(TinkerTraits.jagged, "head");
        prismarine.addTrait(TinkerTraits.aquadynamic);
        netherrack.setCraftable(true);
        netherrack.addItemIngot("netherrack");
        netherrack.setRepresentativeItem(Blocks.field_150424_aL);
        netherrack.addTrait(TinkerTraits.aridiculous, "head");
        netherrack.addTrait(TinkerTraits.hellish);
        endstone.setCraftable(true);
        endstone.addItemIngot("endstone");
        endstone.setRepresentativeItem(Blocks.field_150377_bs);
        endstone.addTrait(TinkerTraits.alien, "head");
        endstone.addTrait(TinkerTraits.enderference);
        bone.setCraftable(true);
        bone.addItemIngot("bone");
        bone.addItem(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.WHITE.func_176767_b()), 1, 36);
        bone.setRepresentativeItem(Items.field_151103_aS);
        bone.addTrait(TinkerTraits.splintering, "head");
        bone.addTrait(TinkerTraits.splitting, "shaft");
        bone.addTrait(TinkerTraits.fractured);
        paper.setCraftable(true);
        paper.addItem("paper", 1, 36);
        paper.setRepresentativeItem(Items.field_151121_aF);
        paper.addTrait(TinkerTraits.writable2, "head");
        paper.addTrait(TinkerTraits.writable);
        sponge.setCraftable(true);
        sponge.addItem(Blocks.field_150360_v, 144);
        sponge.setRepresentativeItem(Blocks.field_150360_v);
        sponge.addTrait(TinkerTraits.squeaky);
        firewood.setCraftable(true);
        firewood.addItem(TinkerCommons.firewood, 1, 144);
        firewood.setRepresentativeItem(TinkerCommons.firewood);
        firewood.addTrait(TinkerTraits.autosmelt);
        slime.setCraftable(true);
        slime.addItemIngot("slimecrystalGreen");
        slime.addTrait(TinkerTraits.slimeyGreen);
        blueslime.setCraftable(true);
        blueslime.addItemIngot("slimecrystalBlue");
        blueslime.addTrait(TinkerTraits.slimeyBlue);
        knightslime.setCraftable(true);
        knightslime.addItemIngot("ingotKnightslime");
        knightslime.addTrait(TinkerTraits.crumbling, "head");
        knightslime.addTrait(TinkerTraits.unnatural);
        magmaslime.setCraftable(true);
        magmaslime.addItemIngot("slimecrystalMagma");
        magmaslime.setRepresentativeItem(TinkerCommons.matSlimeCrystalMagma);
        magmaslime.addTrait(TinkerTraits.superheat, "head");
        magmaslime.addTrait(TinkerTraits.flammable);
        iron.addItemIngot("ingotIron");
        iron.setRepresentativeItem(Items.field_151042_j);
        iron.addTrait(TinkerTraits.magnetic2, "head");
        iron.addTrait(TinkerTraits.magnetic);
        pigiron.addItemIngot("ingotPigiron");
        pigiron.addTrait(TinkerTraits.baconlicious, "head");
        pigiron.addTrait(TinkerTraits.tasty, "head");
        pigiron.addTrait(TinkerTraits.tasty);
        cobalt.addItemIngot("ingotCobalt");
        cobalt.addTrait(TinkerTraits.momentum, "head");
        cobalt.addTrait(TinkerTraits.lightweight);
        ardite.addItemIngot("ingotArdite");
        ardite.addTrait(TinkerTraits.stonebound, "head");
        ardite.addTrait(TinkerTraits.petramor);
        manyullyn.addItemIngot("ingotManyullyn");
        manyullyn.addTrait(TinkerTraits.insatiable, "head");
        manyullyn.addTrait(TinkerTraits.coldblooded);
        copper.addItemIngot("ingotCopper");
        copper.addTrait(TinkerTraits.established);
        bronze.addItemIngot("ingotBronze");
        bronze.addTrait(TinkerTraits.dense);
        lead.addItemIngot("ingotLead");
        lead.addTrait(TinkerTraits.poisonous);
        silver.addItemIngot("ingotSilver");
        silver.addTrait(TinkerTraits.holy);
        electrum.addItemIngot("ingotElectrum");
        electrum.addTrait(TinkerTraits.shocking);
        steel.addItemIngot("ingotSteel");
        steel.addTrait(TinkerTraits.sharp, "head");
        steel.addTrait(TinkerTraits.stiff);
        string.addItemIngot("string");
        vine.addItemIngot("vine");
        this.safeAdd(slimevine_blue, new ItemStack((Block)TinkerWorld.slimeVineBlue1), 144, true);
        this.safeAdd(slimevine_blue, new ItemStack((Block)TinkerWorld.slimeVineBlue2), 144, false);
        this.safeAdd(slimevine_blue, new ItemStack((Block)TinkerWorld.slimeVineBlue3), 144, false);
        this.safeAdd(slimevine_purple, new ItemStack((Block)TinkerWorld.slimeVinePurple1), 144, true);
        this.safeAdd(slimevine_purple, new ItemStack((Block)TinkerWorld.slimeVinePurple2), 144, false);
        this.safeAdd(slimevine_purple, new ItemStack((Block)TinkerWorld.slimeVinePurple3), 144, false);
        blaze.addItem(Items.field_151072_bj, 1, 144);
        blaze.setRepresentativeItem(Items.field_151072_bj);
        blaze.addTrait(TinkerTraits.hovering);
        reed.addItem(Items.field_151120_aE, 1, 144);
        reed.setRepresentativeItem(Items.field_151120_aE);
        reed.addTrait(TinkerTraits.breakable);
        ice.addItem(Blocks.field_150403_cj, 144);
        ice.setRepresentativeItem(Blocks.field_150403_cj);
        ice.addTrait(TinkerTraits.freezing);
        endrod.addItem(Blocks.field_185764_cQ, 144);
        endrod.setRepresentativeItem(Blocks.field_185764_cQ);
        endrod.addTrait(TinkerTraits.endspeed);
        feather.addItemIngot("feather");
        leaf.addItemIngot("treeLeaves");
        this.safeAdd(slimeleaf_blue, new ItemStack((Block)TinkerWorld.slimeLeaves, 1, BlockSlimeGrass.FoliageType.BLUE.getMeta()), 144, true);
        this.safeAdd(slimeleaf_orange, new ItemStack((Block)TinkerWorld.slimeLeaves, 1, BlockSlimeGrass.FoliageType.ORANGE.getMeta()), 144, true);
        this.safeAdd(slimeleaf_purple, new ItemStack((Block)TinkerWorld.slimeLeaves, 1, BlockSlimeGrass.FoliageType.PURPLE.getMeta()), 144, true);
        this.registerToolMaterialStats();
        this.registerBowMaterialStats();
        this.registerProjectileMaterialStats();
    }

    private void safeAdd(Material material, ItemStack item, int value) {
        this.safeAdd(material, item, value, false);
    }

    private void safeAddOredicted(Material material, String oredict, ItemStack representative) {
        material.addItem(oredict, 1, 144);
        material.setRepresentativeItem(representative);
    }

    private void safeAdd(Material material, ItemStack item, int value, boolean representative) {
        if (item != null && item.func_77973_b() != null) {
            material.addItem(item, 1, value);
            if (representative) {
                material.setRepresentativeItem(item);
            }
        }
    }

    public void registerToolMaterialStats() {
        TinkerRegistry.addMaterialStats(wood, new HeadMaterialStats(35, 2.0f, 2.0f, 0), new HandleMaterialStats(1.0f, 25), new ExtraMaterialStats(15));
        TinkerRegistry.addMaterialStats(stone, new HeadMaterialStats(120, 4.0f, 2.9f, 1), new HandleMaterialStats(0.5f, -50), new ExtraMaterialStats(20));
        TinkerRegistry.addMaterialStats(flint, new HeadMaterialStats(150, 5.0f, 2.8f, 1), new HandleMaterialStats(0.6f, -60), new ExtraMaterialStats(40));
        TinkerRegistry.addMaterialStats(cactus, new HeadMaterialStats(210, 4.0f, 3.4f, 1), new HandleMaterialStats(0.85f, 20), new ExtraMaterialStats(50));
        TinkerRegistry.addMaterialStats(bone, new HeadMaterialStats(200, 5.09f, 2.5f, 1), new HandleMaterialStats(1.1f, 50), new ExtraMaterialStats(65));
        TinkerRegistry.addMaterialStats(obsidian, new HeadMaterialStats(139, 7.07f, 4.2f, 4), new HandleMaterialStats(0.9f, -100), new ExtraMaterialStats(90));
        TinkerRegistry.addMaterialStats(prismarine, new HeadMaterialStats(430, 5.5f, 6.0f, 1), new HandleMaterialStats(0.6f, -150), new ExtraMaterialStats(100));
        TinkerRegistry.addMaterialStats(endstone, new HeadMaterialStats(420, 3.23f, 3.23f, 3), new HandleMaterialStats(0.85f, 0), new ExtraMaterialStats(42));
        TinkerRegistry.addMaterialStats(paper, new HeadMaterialStats(12, 0.51f, 0.05f, 0), new HandleMaterialStats(0.1f, 5), new ExtraMaterialStats(15));
        TinkerRegistry.addMaterialStats(sponge, new HeadMaterialStats(1050, 3.02f, 0.0f, 0), new HandleMaterialStats(1.2f, 250), new ExtraMaterialStats(250));
        TinkerRegistry.addMaterialStats(slime, new HeadMaterialStats(1000, 4.24f, 1.8f, 0), new HandleMaterialStats(0.7f, 0), new ExtraMaterialStats(350));
        TinkerRegistry.addMaterialStats(blueslime, new HeadMaterialStats(780, 4.03f, 1.8f, 0), new HandleMaterialStats(1.3f, -50), new ExtraMaterialStats(200));
        TinkerRegistry.addMaterialStats(knightslime, new HeadMaterialStats(850, 5.8f, 5.1f, 3), new HandleMaterialStats(0.5f, 500), new ExtraMaterialStats(125));
        TinkerRegistry.addMaterialStats(magmaslime, new HeadMaterialStats(600, 2.1f, 7.0f, 0), new HandleMaterialStats(0.85f, -200), new ExtraMaterialStats(150));
        TinkerRegistry.addMaterialStats(netherrack, new HeadMaterialStats(270, 4.5f, 3.0f, 1), new HandleMaterialStats(0.85f, -150), new ExtraMaterialStats(75));
        TinkerRegistry.addMaterialStats(cobalt, new HeadMaterialStats(780, 12.0f, 4.1f, 4), new HandleMaterialStats(0.9f, 100), new ExtraMaterialStats(300));
        TinkerRegistry.addMaterialStats(ardite, new HeadMaterialStats(990, 3.5f, 3.6f, 4), new HandleMaterialStats(1.4f, -200), new ExtraMaterialStats(450));
        TinkerRegistry.addMaterialStats(manyullyn, new HeadMaterialStats(820, 7.02f, 8.72f, 4), new HandleMaterialStats(0.5f, 250), new ExtraMaterialStats(50));
        TinkerRegistry.addMaterialStats(firewood, new HeadMaterialStats(550, 6.0f, 5.5f, 0), new HandleMaterialStats(1.0f, -200), new ExtraMaterialStats(150));
        TinkerRegistry.addMaterialStats(iron, new HeadMaterialStats(204, 6.0f, 4.0f, 2), new HandleMaterialStats(0.85f, 60), new ExtraMaterialStats(50));
        TinkerRegistry.addMaterialStats(pigiron, new HeadMaterialStats(380, 6.2f, 4.5f, 3), new HandleMaterialStats(1.2f, -100), new ExtraMaterialStats(170));
        TinkerRegistry.addMaterialStats(copper, new HeadMaterialStats(210, 5.3f, 3.0f, 1), new HandleMaterialStats(1.05f, 30), new ExtraMaterialStats(100));
        TinkerRegistry.addMaterialStats(bronze, new HeadMaterialStats(430, 6.8f, 3.5f, 2), new HandleMaterialStats(1.1f, 70), new ExtraMaterialStats(80));
        TinkerRegistry.addMaterialStats(lead, new HeadMaterialStats(334, 5.25f, 3.5f, 1), new HandleMaterialStats(0.7f, -50), new ExtraMaterialStats(100));
        TinkerRegistry.addMaterialStats(silver, new HeadMaterialStats(250, 5.0f, 5.0f, 1), new HandleMaterialStats(0.95f, 50), new ExtraMaterialStats(150));
        TinkerRegistry.addMaterialStats(electrum, new HeadMaterialStats(50, 12.0f, 3.0f, 1), new HandleMaterialStats(1.1f, -25), new ExtraMaterialStats(250));
        TinkerRegistry.addMaterialStats(steel, new HeadMaterialStats(540, 7.0f, 6.0f, 3), new HandleMaterialStats(0.9f, 150), new ExtraMaterialStats(25));
    }

    public void registerBowMaterialStats() {
        BowMaterialStats whyWouldYouMakeABowOutOfThis = new BowMaterialStats(0.2f, 0.4f);
        TinkerRegistry.addMaterialStats(wood, (IMaterialStats)new BowMaterialStats(1.0f, 1.0f));
        TinkerRegistry.addMaterialStats(stone, (IMaterialStats)whyWouldYouMakeABowOutOfThis);
        TinkerRegistry.addMaterialStats(flint, (IMaterialStats)whyWouldYouMakeABowOutOfThis);
        TinkerRegistry.addMaterialStats(cactus, (IMaterialStats)new BowMaterialStats(1.05f, 0.9f));
        TinkerRegistry.addMaterialStats(bone, (IMaterialStats)new BowMaterialStats(0.95f, 1.15f));
        TinkerRegistry.addMaterialStats(obsidian, (IMaterialStats)whyWouldYouMakeABowOutOfThis);
        TinkerRegistry.addMaterialStats(prismarine, (IMaterialStats)whyWouldYouMakeABowOutOfThis);
        TinkerRegistry.addMaterialStats(endstone, (IMaterialStats)whyWouldYouMakeABowOutOfThis);
        TinkerRegistry.addMaterialStats(paper, (IMaterialStats)new BowMaterialStats(2.0f, 0.5f));
        TinkerRegistry.addMaterialStats(sponge, (IMaterialStats)new BowMaterialStats(1.15f, 0.75f));
        TinkerRegistry.addMaterialStats(slime, (IMaterialStats)new BowMaterialStats(0.85f, 1.3f));
        TinkerRegistry.addMaterialStats(blueslime, (IMaterialStats)new BowMaterialStats(1.05f, 1.0f));
        TinkerRegistry.addMaterialStats(knightslime, (IMaterialStats)new BowMaterialStats(0.4f, 2.0f));
        TinkerRegistry.addMaterialStats(magmaslime, (IMaterialStats)new BowMaterialStats(1.1f, 1.05f));
        TinkerRegistry.addMaterialStats(netherrack, (IMaterialStats)whyWouldYouMakeABowOutOfThis);
        TinkerRegistry.addMaterialStats(cobalt, (IMaterialStats)new BowMaterialStats(0.75f, 1.3f));
        TinkerRegistry.addMaterialStats(ardite, (IMaterialStats)new BowMaterialStats(0.45f, 0.8f));
        TinkerRegistry.addMaterialStats(manyullyn, (IMaterialStats)new BowMaterialStats(0.65f, 1.2f));
        TinkerRegistry.addMaterialStats(firewood, (IMaterialStats)new BowMaterialStats(1.0f, 1.0f));
        TinkerRegistry.addMaterialStats(iron, (IMaterialStats)new BowMaterialStats(0.5f, 1.5f));
        TinkerRegistry.addMaterialStats(pigiron, (IMaterialStats)new BowMaterialStats(0.6f, 1.4f));
        TinkerRegistry.addMaterialStats(copper, (IMaterialStats)new BowMaterialStats(0.6f, 1.45f));
        TinkerRegistry.addMaterialStats(bronze, (IMaterialStats)new BowMaterialStats(0.55f, 1.5f));
        TinkerRegistry.addMaterialStats(lead, (IMaterialStats)new BowMaterialStats(0.4f, 1.3f));
        TinkerRegistry.addMaterialStats(silver, (IMaterialStats)new BowMaterialStats(1.2f, 0.8f));
        TinkerRegistry.addMaterialStats(electrum, (IMaterialStats)new BowMaterialStats(1.5f, 1.0f));
        TinkerRegistry.addMaterialStats(steel, (IMaterialStats)new BowMaterialStats(0.4f, 2.0f));
        BowStringMaterialStats bowstring = new BowStringMaterialStats(1.0f);
        TinkerRegistry.addMaterialStats(string, (IMaterialStats)bowstring);
        TinkerRegistry.addMaterialStats(vine, (IMaterialStats)bowstring);
        TinkerRegistry.addMaterialStats(slimevine_blue, (IMaterialStats)bowstring);
        TinkerRegistry.addMaterialStats(slimevine_purple, (IMaterialStats)bowstring);
    }

    public void registerProjectileMaterialStats() {
        TinkerRegistry.addMaterialStats(wood, (IMaterialStats)new ArrowShaftMaterialStats(1.0f, 0));
        TinkerRegistry.addMaterialStats(bone, (IMaterialStats)new ArrowShaftMaterialStats(0.9f, 5));
        TinkerRegistry.addMaterialStats(blaze, (IMaterialStats)new ArrowShaftMaterialStats(0.8f, 3));
        TinkerRegistry.addMaterialStats(reed, (IMaterialStats)new ArrowShaftMaterialStats(1.5f, 20));
        TinkerRegistry.addMaterialStats(ice, (IMaterialStats)new ArrowShaftMaterialStats(0.95f, 0));
        TinkerRegistry.addMaterialStats(endrod, (IMaterialStats)new ArrowShaftMaterialStats(0.7f, 1));
        TinkerRegistry.addMaterialStats(feather, (IMaterialStats)new FletchingMaterialStats(1.0f, 1.0f));
        TinkerRegistry.addMaterialStats(leaf, (IMaterialStats)new FletchingMaterialStats(0.5f, 1.5f));
        FletchingMaterialStats slimeLeafStats = new FletchingMaterialStats(0.8f, 1.25f);
        TinkerRegistry.addMaterialStats(slimeleaf_purple, (IMaterialStats)slimeLeafStats);
        TinkerRegistry.addMaterialStats(slimeleaf_blue, (IMaterialStats)slimeLeafStats);
        TinkerRegistry.addMaterialStats(slimeleaf_orange, (IMaterialStats)slimeLeafStats);
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        if (TinkerTools.shard == null) {
            return;
        }
        for (Material material : TinkerRegistry.getAllMaterials()) {
            ItemStack shard = TinkerTools.shard.getItemstackWithMaterial(material);
            material.addRecipeMatch((RecipeMatch)new RecipeMatch.ItemCombination(72, new ItemStack[]{shard}));
            if (material.getShard() == null) continue;
            material.setShard(shard);
        }
    }

    static {
        string = TinkerMaterials.mat("string", 0xEEEEEE);
        vine = TinkerMaterials.mat("vine", 4235535);
        slimevine_blue = TinkerMaterials.mat("slimevine_blue", 7653575);
        slimevine_purple = TinkerMaterials.mat("slimevine_purple", 13136840);
        blaze = TinkerMaterials.mat("blaze", 16761088);
        reed = TinkerMaterials.mat("reed", 11197300);
        ice = TinkerMaterials.mat("ice", 9951200);
        endrod = TinkerMaterials.mat("endrod", 15269846);
        feather = TinkerMaterials.mat("feather", 0xEEEEEE);
        leaf = TinkerMaterials.mat("leaf", 1929996);
        slimeleaf_blue = TinkerMaterials.mat("slimeleaf_blue", 7653575);
        slimeleaf_orange = TinkerMaterials.mat("slimeleaf_orange", 16750093);
        slimeleaf_purple = TinkerMaterials.mat("slimeleaf_purple", 13136840);
        xu = new Material("unstable", TextFormatting.WHITE);
    }
}

