/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials;

import com.google.common.collect.ImmutableList;
import java.util.List;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.AbstractMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;

public class ArrowShaftMaterialStats
extends AbstractMaterialStats {
    public static final String LOC_Multiplier = "stat.shaft.modifier.name";
    public static final String LOC_Ammo = "stat.shaft.ammo.name";
    public static final String LOC_MultiplierDesc = "stat.shaft.modifier.desc";
    public static final String LOC_AmmoDesc = "stat.shaft.ammo.desc";
    public static final String COLOR_Ammo = HeadMaterialStats.COLOR_Durability;
    public static final String COLOR_Modifier = HandleMaterialStats.COLOR_Modifier;
    public final float modifier;
    public final int bonusAmmo;

    public ArrowShaftMaterialStats(float modifier, int bonusAmmo) {
        super("shaft");
        this.bonusAmmo = bonusAmmo;
        this.modifier = modifier;
    }

    @Override
    public List<String> getLocalizedInfo() {
        return ImmutableList.of((Object)ArrowShaftMaterialStats.formatModifier(this.modifier), (Object)ArrowShaftMaterialStats.formatAmmo(this.bonusAmmo));
    }

    @Override
    public List<String> getLocalizedDesc() {
        return ImmutableList.of((Object)Util.translate(LOC_MultiplierDesc, new Object[0]), (Object)Util.translate(LOC_AmmoDesc, new Object[0]));
    }

    public static String formatModifier(float quality) {
        return ArrowShaftMaterialStats.formatNumber(LOC_Multiplier, COLOR_Modifier, quality);
    }

    public static String formatAmmo(int durability) {
        return ArrowShaftMaterialStats.formatNumber(LOC_Ammo, COLOR_Ammo, durability);
    }
}

