/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.client;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.client.model.BakedCompositeModel;
import slimeknights.mantle.client.model.TRSRBakedModel;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.model.ModelHelper;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.shared.block.BlockTable;
import slimeknights.tconstruct.shared.block.PropertyTableItem;

public class BakedTableModel
implements IPerspectiveAwareModel {
    private final IPerspectiveAwareModel standard;
    private final IRetexturableModel tableModel;
    private final Map<String, IBakedModel> cache = Maps.newHashMap();
    private final Function<ResourceLocation, TextureAtlasSprite> textureGetter;
    private final VertexFormat format;
    private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;

    public BakedTableModel(IPerspectiveAwareModel standard, IRetexturableModel tableModel, VertexFormat format) {
        this.standard = standard;
        this.tableModel = tableModel;
        this.textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

            public TextureAtlasSprite apply(ResourceLocation location) {
                return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
            }
        };
        this.format = format;
        this.transforms = ModelHelper.getTransforms(standard);
    }

    protected IBakedModel getActualModel(String texture, List<PropertyTableItem.TableItem> items, EnumFacing facing) {
        BakedCompositeModel.Builder builder;
        IPerspectiveAwareModel bakedModel = this.standard;
        if (texture != null) {
            if (this.cache.containsKey(texture)) {
                bakedModel = this.cache.get(texture);
            } else if (this.tableModel != null) {
                builder = ImmutableMap.builder();
                builder.put((Object)"bottom", (Object)texture);
                builder.put((Object)"leg", (Object)texture);
                builder.put((Object)"legBottom", (Object)texture);
                IModel retexturedModel = this.tableModel.retexture(builder.build());
                SimpleModelState modelState = new SimpleModelState(this.transforms);
                bakedModel = retexturedModel.bake((IModelState)modelState, this.format, this.textureGetter);
                this.cache.put(texture, (IBakedModel)bakedModel);
            }
        }
        if (items != null && !items.isEmpty()) {
            builder = new BakedCompositeModel.Builder();
            builder.add((IBakedModel)bakedModel, null, 0L);
            for (PropertyTableItem.TableItem item : items) {
                builder.add((IBakedModel)new TRSRBakedModel(item.model, item.x, item.y + 1.0f, item.z, item.r, (float)Math.PI, 0.0f, item.s), null, 0L);
            }
            bakedModel = builder.build((IBakedModel)bakedModel);
        }
        if (facing != null) {
            bakedModel = new TRSRBakedModel((IBakedModel)bakedModel, facing);
        }
        return bakedModel;
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        String texture = null;
        List<PropertyTableItem.TableItem> items = Collections.emptyList();
        EnumFacing face = EnumFacing.SOUTH;
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState extendedState = (IExtendedBlockState)state;
            if (extendedState.getUnlistedNames().contains(BlockTable.TEXTURE)) {
                texture = (String)extendedState.getValue((IUnlistedProperty)BlockTable.TEXTURE);
            }
            if (Config.renderTableItems && extendedState.getUnlistedNames().contains(BlockTable.INVENTORY) && extendedState.getValue((IUnlistedProperty)BlockTable.INVENTORY) != null) {
                items = ((PropertyTableItem.TableItems)extendedState.getValue((IUnlistedProperty)BlockTable.INVENTORY)).items;
            }
            if (extendedState.getUnlistedNames().contains(BlockTable.FACING)) {
                face = (EnumFacing)extendedState.getValue((IUnlistedProperty)BlockTable.FACING);
            }
            state = extendedState.withProperty((IUnlistedProperty)BlockTable.INVENTORY, (Object)PropertyTableItem.TableItems.EMPTY).withProperty((IUnlistedProperty)BlockTable.FACING, null);
        }
        if (texture == null && items == null) {
            return this.standard.func_188616_a(state, side, rand);
        }
        return this.getActualModel(texture, items, face).func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.standard.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.standard.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.standard.func_188618_c();
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.standard.func_177554_e();
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return this.standard.func_177552_f();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return TableItemOverrideList.INSTANCE;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        Pair pair = this.standard.handlePerspective(cameraTransformType);
        return Pair.of((Object)this, (Object)pair.getRight());
    }

    private static class TableItemOverrideList
    extends ItemOverrideList {
        static TableItemOverrideList INSTANCE = new TableItemOverrideList();

        private TableItemOverrideList() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nonnull World world, @Nonnull EntityLivingBase entity) {
            ItemStack blockStack;
            if (originalModel instanceof BakedTableModel && (blockStack = ItemStack.func_77949_a((NBTTagCompound)TagUtil.getTagSafe(stack).func_74775_l("textureBlock"))) != null) {
                Block block = Block.func_149634_a((Item)blockStack.func_77973_b());
                String texture = ModelHelper.getTextureFromBlock((Block)block, (int)blockStack.func_77952_i()).func_94215_i();
                return ((BakedTableModel)originalModel).getActualModel(texture, Collections.emptyList(), null);
            }
            return originalModel;
        }
    }
}

