/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.module;

import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.client.gui.GuiElement;
import slimeknights.mantle.client.gui.GuiElementScalable;
import slimeknights.mantle.client.gui.GuiMultiModule;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.smeltery.client.GuiSearedFurnace;
import slimeknights.tconstruct.smeltery.tileentity.TileSearedFurnace;
import slimeknights.tconstruct.tools.common.client.module.GuiSideInventory;

public class GuiSearedFurnaceSideInventory
extends GuiSideInventory {
    public static final ResourceLocation SLOT_LOCATION = GuiSearedFurnace.BACKGROUND;
    protected final TileSearedFurnace furnace;
    protected GuiElement progressBar = new GuiElementScalable(176, 150, 3, 16, 256, 256);
    protected GuiElement unprogressBar = new GuiElementScalable(179, 150, 3, 16);
    protected GuiElement uberHeatBar = new GuiElementScalable(182, 150, 3, 16);
    protected GuiElement noMeltBar = new GuiElementScalable(185, 150, 3, 16);
    protected GuiElement completeBar = new GuiElementScalable(188, 150, 3, 16);

    public GuiSearedFurnaceSideInventory(GuiMultiModule parent, Container container, TileSearedFurnace furnace, int slotCount, int columns) {
        super(parent, container, slotCount, columns, false, true);
        this.furnace = furnace;
        GuiElement.defaultTexH = 256;
        GuiElement.defaultTexW = 256;
        this.slot = new GuiElementScalable(0, 166, 22, 18);
        this.slotEmpty = new GuiElementScalable(22, 166, 22, 18);
        this.yOffset = 0;
    }

    @Override
    protected boolean shouldDrawName() {
        return false;
    }

    @Override
    protected void updateSlots() {
        this.xOffset += 4;
        super.updateSlots();
        this.xOffset -= 4;
    }

    @Override
    protected int drawSlots(int xPos, int yPos) {
        this.field_146297_k.func_110434_K().func_110577_a(SLOT_LOCATION);
        int ret = super.drawSlots(xPos, yPos);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_INVENTORY);
        return ret;
    }

    @Override
    public void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146297_k.func_110434_K().func_110577_a(SLOT_LOCATION);
        RenderHelper.func_74518_a();
        String tooltipText = null;
        for (Slot slot : this.field_147002_h.field_75151_b) {
            if (!slot.func_75216_d() || !this.shouldDrawSlot(slot)) continue;
            float progress = this.furnace.getHeatingProgress(slot.getSlotIndex());
            String tooltip = null;
            GuiElement bar = this.progressBar;
            if (Float.isNaN(progress)) {
                progress = 1.0f;
                bar = this.noMeltBar;
                tooltip = "gui.searedfurnace.progress.no_recipe";
            } else if (progress == Float.POSITIVE_INFINITY) {
                bar = this.completeBar;
                progress = 1.0f;
                tooltip = "gui.searedfurnace.progress.complete";
            } else if (progress == Float.NEGATIVE_INFINITY) {
                bar = this.uberHeatBar;
                progress = 1.0f;
                tooltip = "gui.searedfurnace.progress.no_space";
            } else if (progress < 0.0f) {
                bar = this.unprogressBar;
                progress = 1.0f;
                tooltip = "gui.smeltery.progress.no_heat";
            } else if (progress > 1.0f) {
                progress = 1.0f;
            }
            int height = 1 + Math.round(progress * (float)(bar.h - 1));
            int x = slot.field_75223_e - 10 + this.field_146999_f;
            int y = slot.field_75221_f + bar.h - height;
            if (tooltip != null && x + this.field_147003_i <= mouseX && x + this.field_147003_i + bar.w > mouseX && y + this.field_147009_r <= mouseY && y + this.field_147009_r + bar.h > mouseY) {
                tooltipText = tooltip;
            }
            GuiScreen.func_146110_a((int)x, (int)y, (float)bar.x, (float)(bar.y + bar.h - height), (int)bar.w, (int)height, (float)bar.texW, (float)bar.texH);
        }
        if (tooltipText != null) {
            this.func_146283_a(this.field_146289_q.func_78271_c(Util.translate(tooltipText, new Object[0]), 100), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }
}

