/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketParticles;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.fluid.FluidHandlerCasting;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.library.tileentity.IProgress;
import slimeknights.tconstruct.shared.tileentity.TileTable;
import slimeknights.tconstruct.smeltery.events.TinkerCastingEvent;
import slimeknights.tconstruct.smeltery.network.FluidUpdatePacket;

public abstract class TileCasting
extends TileTable
implements ITickable,
ISidedInventory,
IProgress {
    public FluidTankAnimated tank = new FluidTankAnimated(0, (TileEntity)this);
    public IFluidHandler fluidHandler = new FluidHandlerCasting(this, this.tank);
    protected int timer;
    protected ICastingRecipe recipe;

    public TileCasting() {
        super("casting", 2, 1);
        this.itemHandler = new SidedInvWrapper((ISidedInventory)this, null);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.fluidHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void interact(EntityPlayer player) {
        if (this.tank.getFluidAmount() > 0) {
            return;
        }
        if (!this.isStackInSlot(0) && !this.isStackInSlot(1)) {
            ItemStack stack = player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, this.stackSizeLimit);
            this.func_70299_a(0, stack);
        } else {
            int slot = this.isStackInSlot(1) ? 1 : 0;
            ItemStack stack = this.func_70301_a(slot);
            if (slot == 1) {
                FMLCommonHandler.instance().firePlayerSmeltedEvent(player, stack);
            }
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack);
            this.func_70299_a(slot, null);
            if (slot == 1) {
                this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
            }
        }
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int index, @Nonnull ItemStack itemStackIn, @Nonnull EnumFacing direction) {
        return index == 0 && !this.isStackInSlot(1);
    }

    public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nonnull EnumFacing direction) {
        return index == 1;
    }

    public void func_73660_a() {
        if (this.recipe == null) {
            return;
        }
        if (this.tank.getFluidAmount() == this.tank.getCapacity()) {
            ++this.timer;
            if (!this.field_145850_b.field_72995_K) {
                if (this.timer >= this.recipe.getTime()) {
                    TinkerCastingEvent.OnCasted event = TinkerCastingEvent.OnCasted.fire(this.recipe, this);
                    if (event.consumeCast) {
                        this.func_70299_a(0, null);
                        for (EntityPlayer player : this.field_145850_b.field_73010_i) {
                            if (!(player.func_174818_b(this.field_174879_c) < 1024.0) || !(player instanceof EntityPlayerMP)) continue;
                            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketParticles(EnumParticleTypes.FLAME, false, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 1.1f, (float)this.field_174879_c.func_177952_p() + 0.5f, 0.25f, 0.0125f, 0.25f, 0.005f, 5, new int[0]));
                        }
                    }
                    if (event.switchOutputs) {
                        this.func_70299_a(1, this.func_70301_a(0));
                        this.func_70299_a(0, event.output);
                    } else {
                        this.func_70299_a(1, event.output);
                    }
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187659_cY, SoundCategory.AMBIENT, 0.07f, 4.0f);
                    this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
                    this.reset();
                }
            } else if (this.field_145850_b.field_73012_v.nextFloat() > 0.9f) {
                this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextDouble(), (double)this.field_174879_c.func_177956_o() + 1.1, (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public float getProgress() {
        if (this.recipe == null || this.tank.getFluidAmount() == 0) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)this.timer / (float)this.recipe.getTime());
    }

    public ItemStack getCurrentResult() {
        if (this.recipe == null) {
            return null;
        }
        Fluid fluid = null;
        if (this.tank.getFluid() != null) {
            fluid = this.tank.getFluid().getFluid();
        }
        return this.recipe.getResult(this.func_70301_a(0), fluid);
    }

    protected abstract ICastingRecipe findRecipe(ItemStack var1, Fluid var2);

    protected ICastingRecipe findRecipe(Fluid fluid) {
        ICastingRecipe recipe = this.findRecipe(this.func_70301_a(0), fluid);
        if (TinkerCastingEvent.OnCasting.fire(recipe, this)) {
            return recipe;
        }
        return null;
    }

    public int initNewCasting(Fluid fluid, boolean setNewRecipe) {
        ICastingRecipe recipe = this.findRecipe(fluid);
        if (recipe != null) {
            if (setNewRecipe) {
                this.recipe = recipe;
            }
            return recipe.getFluidAmount();
        }
        return 0;
    }

    public void reset() {
        this.timer = 0;
        this.recipe = null;
        this.tank.setCapacity(0);
        this.tank.setFluid(null);
        this.tank.renderOffset = 0.0f;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.field_145850_b instanceof WorldServer) {
            TinkerNetwork.sendToClients((WorldServer)this.field_145850_b, this.field_174879_c, (AbstractPacket)new FluidUpdatePacket(this.field_174879_c, null));
        }
    }

    public void updateFluidTo(FluidStack fluid) {
        int oldAmount = this.tank.getFluidAmount();
        this.tank.setFluid(fluid);
        if (fluid == null) {
            this.reset();
            return;
        }
        if (this.recipe == null) {
            this.recipe = this.findRecipe(fluid.getFluid());
            if (this.recipe != null) {
                this.tank.setCapacity(this.recipe.getFluidAmount());
            }
        }
        this.tank.renderOffset += (float)(this.tank.getFluidAmount() - oldAmount);
    }

    public int comparatorStrength() {
        return this.isStackInSlot(1) ? 15 : 0;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags = super.func_189515_b(tags);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.tank.writeToNBT(tankTag);
        tags.func_74782_a("tank", (NBTBase)tankTag);
        tags.func_74768_a("timer", this.timer);
        return tags;
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.tank.readFromNBT(tags.func_74775_l("tank"));
        this.updateFluidTo(this.tank.getFluid());
        this.timer = tags.func_74762_e("timer");
    }
}

