/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.BlockSearedFurnaceController;
import slimeknights.tconstruct.smeltery.multiblock.MultiblockDetection;
import slimeknights.tconstruct.smeltery.network.HeatingStructureFuelUpdatePacket;
import slimeknights.tconstruct.smeltery.tileentity.TileHeatingStructure;
import slimeknights.tconstruct.smeltery.tileentity.TileTank;

public abstract class TileHeatingStructureFuelTank<T extends MultiblockDetection>
extends TileHeatingStructure<T> {
    public static final String TAG_TANKS = "tanks";
    public static final String TAG_FUEL_QUALITY = "fuelQuality";
    public static final String TAG_CURRENT_FUEL = "currentFuel";
    public static final String TAG_CURRENT_TANK = "currentTank";
    public int fuelQuality;
    public List<BlockPos> tanks = Lists.newLinkedList();
    public BlockPos currentTank;
    public FluidStack currentFuel;

    public TileHeatingStructureFuelTank(String name, int inventorySize, int maxStackSize) {
        super(name, inventorySize, maxStackSize);
    }

    @Override
    protected void consumeFuel() {
        TileEntity te;
        if (this.hasFuel()) {
            return;
        }
        this.searchForFuel();
        if (this.currentTank != null && (te = this.field_145850_b.func_175625_s(this.currentTank)) instanceof TileTank) {
            FluidTankAnimated tank = ((TileTank)te).getInternalTank();
            FluidStack liquid = tank.getFluid();
            if (liquid != null) {
                FluidStack in = liquid.copy();
                int bonusFuel = TinkerRegistry.consumeSmelteryFuel(in);
                int amount = liquid.amount - in.amount;
                FluidStack drained = tank.drain(amount, false);
                if (drained != null && drained.amount == amount) {
                    tank.drain(amount, true);
                    this.currentFuel = drained.copy();
                    this.fuelQuality = bonusFuel;
                    this.addFuel(bonusFuel, drained.getFluid().getTemperature(drained) - 300);
                    if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                        TinkerNetwork.sendToAll((AbstractPacket)new HeatingStructureFuelUpdatePacket(this.field_174879_c, this.currentTank, this.temperature, this.currentFuel));
                    }
                    return;
                }
            }
            this.fuelQuality = 0;
        }
    }

    private void searchForFuel() {
        if (this.currentTank != null && this.hasTankWithFuel(this.currentTank, this.currentFuel)) {
            return;
        }
        for (BlockPos pos : this.tanks) {
            if (!this.hasTankWithFuel(pos, this.currentFuel)) continue;
            this.currentTank = pos;
            return;
        }
        for (BlockPos pos : this.tanks) {
            if (!this.hasTankWithFuel(pos, null)) continue;
            this.currentTank = pos;
            return;
        }
        this.currentTank = null;
    }

    private boolean hasTankWithFuel(BlockPos pos, FluidStack preference) {
        IFluidTank tank = this.getTankAt(pos);
        if (tank != null && tank.getFluid() != null && tank.getFluidAmount() > 0 && TinkerRegistry.isSmelteryFuel(tank.getFluid())) {
            if (preference != null && tank.getFluid().isFluidEqual(preference)) {
                return true;
            }
            if (preference == null) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void updateStructureInfo(MultiblockDetection.MultiblockStructure structure) {
        this.tanks.clear();
        for (BlockPos pos : structure.blocks) {
            if (this.field_145850_b.func_180495_p(pos).func_177230_c() != TinkerSmeltery.searedTank) continue;
            this.tanks.add(pos);
        }
        int inventorySize = this.getUpdatedInventorySize(structure.xd, structure.yd, structure.zd);
        if (this.func_70302_i_() > inventorySize) {
            for (int i = inventorySize; i < this.func_70302_i_(); ++i) {
                if (this.func_70301_a(i) == null) continue;
                this.dropItem(this.func_70301_a(i));
            }
        }
        this.resize(inventorySize);
    }

    protected abstract int getUpdatedInventorySize(int var1, int var2, int var3);

    protected void dropItem(ItemStack stack) {
        EnumFacing direction = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockSearedFurnaceController.FACING);
        BlockPos pos = this.func_174877_v().func_177972_a(direction);
        EntityItem entityitem = new EntityItem(this.field_145850_b, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
        this.field_145850_b.func_72838_d((Entity)entityitem);
    }

    private IFluidTank getTankAt(BlockPos pos) {
        TileEntity te = this.field_145850_b.func_175625_s(pos);
        if (te instanceof TileTank) {
            return ((TileTank)te).getInternalTank();
        }
        return null;
    }

    public float getHeatingProgress(int index) {
        if (index < 0 || index > this.func_70302_i_() - 1) {
            return -1.0f;
        }
        if (!this.canHeat(index)) {
            return -1.0f;
        }
        return this.getProgress(index);
    }

    @SideOnly(value=Side.CLIENT)
    public float getFuelPercentage() {
        return (float)this.fuel / (float)this.fuelQuality;
    }

    @SideOnly(value=Side.CLIENT)
    public FuelInfo getFuelDisplay() {
        FuelInfo info = new FuelInfo();
        if (this.hasFuel()) {
            info.fluid = this.currentFuel.copy();
            info.fluid.amount = 0;
            info.heat = this.temperature;
            info.maxCap = this.currentFuel.amount;
        } else if (this.currentTank != null && this.hasTankWithFuel(this.currentTank, this.currentFuel)) {
            IFluidTank tank = this.getTankAt(this.currentTank);
            info.fluid = tank.getFluid().copy();
            info.heat = this.temperature;
            info.maxCap = tank.getCapacity();
        }
        for (BlockPos pos : this.tanks) {
            IFluidTank tank;
            if (pos == this.currentTank || (tank = this.getTankAt(pos)) == null || tank.getFluidAmount() <= 0) continue;
            if (info.fluid == null) {
                info.fluid = tank.getFluid().copy();
                info.heat = info.fluid.getFluid().getTemperature(info.fluid);
                info.maxCap = tank.getCapacity();
                continue;
            }
            if (!tank.getFluid().isFluidEqual(info.fluid)) continue;
            info.fluid.amount += tank.getFluidAmount();
            info.maxCap += tank.getCapacity();
        }
        return info;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateFuelFromPacket(int index, int fuel) {
        if (index == 0) {
            this.fuel = fuel;
        } else if (index == 1) {
            this.fuelQuality = fuel;
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74768_a(TAG_FUEL_QUALITY, this.fuelQuality);
        compound.func_74782_a(TAG_CURRENT_TANK, (NBTBase)TagUtil.writePos(this.currentTank));
        NBTTagList tankList = new NBTTagList();
        for (BlockPos pos : this.tanks) {
            tankList.func_74742_a((NBTBase)TagUtil.writePos(pos));
        }
        compound.func_74782_a(TAG_TANKS, (NBTBase)tankList);
        NBTTagCompound fuelTag = new NBTTagCompound();
        if (this.currentFuel != null) {
            this.currentFuel.writeToNBT(fuelTag);
        }
        compound.func_74782_a(TAG_CURRENT_FUEL, (NBTBase)fuelTag);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.fuelQuality = compound.func_74762_e(TAG_FUEL_QUALITY);
        NBTTagList tankList = compound.func_150295_c(TAG_TANKS, 10);
        this.tanks.clear();
        for (int i = 0; i < tankList.func_74745_c(); ++i) {
            this.tanks.add(TagUtil.readPos(tankList.func_150305_b(i)));
        }
        NBTTagCompound fuelTag = compound.func_74775_l(TAG_CURRENT_FUEL);
        this.currentFuel = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fuelTag);
    }

    public static class FuelInfo {
        public int heat;
        public int maxCap;
        public FluidStack fluid;
    }
}

