/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.tools.modifiers.ToolModifier;

public class ModHaste
extends ToolModifier {
    private final int max;

    public ModHaste(int max) {
        super("haste", 0x910000);
        this.max = max;
        this.addAspects(new ModifierAspect.MultiAspect(this, 5, max, 1));
    }

    @Override
    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        ModifierNBT.IntegerNBT modData = ModifierNBT.readInteger(modifierTag);
        boolean harvest = false;
        for (Category category : TagUtil.getCategories(rootCompound)) {
            if (category != Category.HARVEST) continue;
            harvest = true;
        }
        ToolNBT data = TagUtil.getToolStats(rootCompound);
        int level = modData.current / this.max;
        if (harvest) {
            float speed = data.speed;
            for (int count = modData.current; count > 0; --count) {
                if (speed <= 10.0f) {
                    speed += 0.15f - 0.05f * speed / 10.0f;
                    continue;
                }
                speed = speed <= 20.0f ? (float)((double)speed + ((double)0.1f - 0.05 * (double)speed / 20.0)) : (float)((double)speed + 0.05);
            }
            data.speed = speed += (float)level * 0.5f;
        }
        data.attackSpeedMultiplier += this.getSpeedBonus(modData);
        TagUtil.setToolTag(rootCompound, data.get());
    }

    protected float getSpeedBonus(ModifierNBT.IntegerNBT modData) {
        return 0.2f * (float)modData.current / (float)this.max;
    }

    @Override
    protected boolean canApplyCustom(ItemStack stack) throws TinkerGuiException {
        return !((ToolCore)stack.func_77973_b()).hasCategory(Category.NO_MELEE);
    }

    @Override
    public String getTooltip(NBTTagCompound modifierTag, boolean detailed) {
        return this.getLeveledTooltip(modifierTag, detailed);
    }

    @Override
    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        String loc = String.format("modifier.%s.extra", this.getIdentifier());
        float bonus = this.getSpeedBonus(ModifierNBT.readInteger(modifierTag));
        return ImmutableList.of((Object)Util.translateFormatted(loc, Util.dfPercent.format(bonus)));
    }
}

