/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.ranged.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.entity.EntityProjectileBase;
import slimeknights.tconstruct.library.materials.ArrowShaftMaterialStats;
import slimeknights.tconstruct.library.materials.FletchingMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ProjectileNBT;
import slimeknights.tconstruct.library.tools.ranged.ProjectileCore;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.common.entity.EntityArrow;

public class Arrow
extends ProjectileCore {
    public Arrow() {
        super(PartMaterialType.arrowShaft(TinkerTools.arrowShaft), PartMaterialType.arrowHead(TinkerTools.arrowHead), PartMaterialType.fletching(TinkerTools.fletching));
        this.addCategory(Category.NO_MELEE, Category.PROJECTILE);
    }

    @Override
    public void func_150895_a(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        this.addDefaultSubItems(subItems, TinkerMaterials.wood, null, TinkerMaterials.feather);
    }

    @Override
    public float damagePotential() {
        return 1.0f;
    }

    @Override
    public double attackSpeed() {
        return 1.0;
    }

    @Override
    public ProjectileNBT buildTagData(List<Material> materials) {
        ProjectileNBT data = new ProjectileNBT();
        ArrowShaftMaterialStats shaft = (ArrowShaftMaterialStats)materials.get(0).getStatsOrUnknown("shaft");
        HeadMaterialStats head = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        FletchingMaterialStats fletching = (FletchingMaterialStats)materials.get(2).getStatsOrUnknown("fletching");
        data.head(head);
        data.fletchings(fletching);
        data.shafts(this, shaft);
        data.attack += 2.0f;
        return data;
    }

    @Override
    public EntityProjectileBase getProjectile(ItemStack stack, ItemStack bow, World world, EntityPlayer player, float speed, float inaccuracy, boolean usedAmmo) {
        return new EntityArrow(world, player, speed, inaccuracy -= (1.0f - 1.0f / ProjectileNBT.from((ItemStack)stack).accuracy) * speed / 2.0f, this.getProjectileStack(stack, world, player, usedAmmo), bow);
    }
}

