/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.tools;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.tools.Shovel;

public class Excavator
extends Shovel {
    public static final float DURABILITY_MODIFIER = 1.75f;

    public Excavator() {
        super(PartMaterialType.handle(TinkerTools.toughToolRod), PartMaterialType.head(TinkerTools.excavatorHead), PartMaterialType.head(TinkerTools.largePlate), PartMaterialType.extra(TinkerTools.toughBinding));
    }

    @Override
    public void func_150895_a(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        this.addDefaultSubItems(subItems, new Material[0]);
        this.addInfiTool(subItems, "InfiDigger");
    }

    @Override
    public float miningSpeedModifier() {
        return 0.28f;
    }

    @Override
    public float damagePotential() {
        return 1.25f;
    }

    @Override
    public double attackSpeed() {
        return 0.7f;
    }

    @Override
    public ImmutableList<BlockPos> getAOEBlocks(ItemStack stack, World world, EntityPlayer player, BlockPos origin) {
        return ToolHelper.calcAOEBlocks(stack, world, player, origin, 3, 3, 1);
    }

    @Override
    public int[] getRepairParts() {
        return new int[]{1, 2};
    }

    @Override
    public float getRepairModifierForPart(int index) {
        return index == 1 ? 1.75f : 1.3125f;
    }

    @Override
    public ToolNBT buildTagData(List<Material> materials) {
        HandleMaterialStats handle = (HandleMaterialStats)materials.get(0).getStatsOrUnknown("handle");
        HeadMaterialStats head = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        HeadMaterialStats plate = (HeadMaterialStats)materials.get(2).getStatsOrUnknown("head");
        ExtraMaterialStats binding = (ExtraMaterialStats)materials.get(3).getStatsOrUnknown("extra");
        ToolNBT data = new ToolNBT();
        data.head(head, plate);
        data.extra(binding);
        data.handle(handle);
        data.durability = (int)((float)data.durability * 1.75f);
        return data;
    }
}

