/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.traits;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.library.traits.AbstractTrait;

public class TraitAridiculous
extends AbstractTrait {
    public TraitAridiculous() {
        super("aridiculous", TextFormatting.DARK_RED);
    }

    @Override
    public void miningSpeed(ItemStack tool, PlayerEvent.BreakSpeed event) {
        float coeff = this.calcAridiculousness(event.getEntityPlayer().field_70170_p, event.getPos()) / 10.0f;
        event.setNewSpeed(event.getNewSpeed() + event.getOriginalSpeed() * coeff);
    }

    @Override
    public float damage(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, float newDamage, boolean isCritical) {
        float extraDamage = 2.0f * this.calcAridiculousness(player.field_70170_p, player.func_180425_c());
        return extraDamage + super.damage(tool, player, target, damage, newDamage, isCritical);
    }

    protected float calcAridiculousness(World world, BlockPos pos) {
        Biome biome = world.getBiomeForCoordsBody(pos);
        float rain = world.func_72896_J() ? biome.func_76727_i() / 2.0f : 0.0f;
        return (float)(Math.pow(1.25, 3.0 * (double)(0.5f + biome.func_185353_n() - biome.func_76727_i())) - 1.25) - rain;
    }
}

