/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity.helper;

import info.ata4.minecraft.dragon.server.block.BlockDragonBreedEgg;
import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.entity.helper.DragonHelper;
import info.ata4.minecraft.dragon.server.entity.helper.DragonScaleModifier;
import info.ata4.minecraft.dragon.server.entity.helper.EnumDragonLifeStage;
import info.ata4.minecraft.dragon.server.util.ClientServerSynchronisedTickCount;
import net.minecraft.block.Block;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.EnumParticleTypes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DragonLifeStageHelper
extends DragonHelper {
    private static final Logger L = LogManager.getLogger();
    private static final String NBT_TICKS_SINCE_CREATION = "TicksSinceCreation";
    private static final int TICKS_SINCE_CREATION_UPDATE_INTERVAL = 100;
    private static final float EGG_CRACK_THRESHOLD = 0.9f;
    private static final float EGG_WIGGLE_THRESHOLD = 0.75f;
    private static final float EGG_WIGGLE_BASE_CHANCE = 20.0f;
    private EnumDragonLifeStage lifeStagePrev;
    private int eggWiggleX;
    private int eggWiggleZ;
    private final DataParameter<Integer> dataParam;
    private int ticksSinceCreationServer;
    private final ClientServerSynchronisedTickCount ticksSinceCreationClient;

    public DragonLifeStageHelper(EntityTameableDragon dragon, DataParameter<Integer> dataParam) {
        super(dragon);
        this.dataParam = dataParam;
        this.dataWatcher.func_187214_a(dataParam, (Object)this.ticksSinceCreationServer);
        if (dragon.isClient()) {
            this.ticksSinceCreationClient = new ClientServerSynchronisedTickCount(100);
            this.ticksSinceCreationClient.reset(this.ticksSinceCreationServer);
        } else {
            this.ticksSinceCreationClient = null;
        }
    }

    @Override
    public void applyEntityAttributes() {
        this.applyScaleModifier(SharedMonsterAttributes.field_111267_a);
        this.applyScaleModifier(SharedMonsterAttributes.field_111264_e);
    }

    private void applyScaleModifier(IAttribute attribute) {
        IAttributeInstance instance = this.dragon.func_110148_a(attribute);
        AttributeModifier oldModifier = instance.func_111127_a(DragonScaleModifier.ID);
        if (oldModifier != null) {
            instance.func_111124_b(oldModifier);
        }
        instance.func_111121_a((AttributeModifier)new DragonScaleModifier(this.getScale()));
    }

    public void playEggCrackEffect() {
        this.dragon.field_70170_p.func_175718_b(2001, this.dragon.func_180425_c(), Block.func_149682_b((Block)BlockDragonBreedEgg.INSTANCE));
    }

    public int getEggWiggleX() {
        return this.eggWiggleX;
    }

    public int getEggWiggleZ() {
        return this.eggWiggleZ;
    }

    public EnumDragonLifeStage getLifeStage() {
        int age = this.getTicksSinceCreation();
        return EnumDragonLifeStage.fromTickCount(age);
    }

    public int getTicksSinceCreation() {
        if (this.dragon.isServer()) {
            return this.ticksSinceCreationServer;
        }
        return this.ticksSinceCreationClient.getCurrentTickCount();
    }

    public void setTicksSinceCreation(int ticksSinceCreation) {
        if (this.dragon.isServer()) {
            this.ticksSinceCreationServer = ticksSinceCreation;
        } else {
            this.ticksSinceCreationClient.updateFromServer(this.ticksSinceCreationServer);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a(NBT_TICKS_SINCE_CREATION, this.getTicksSinceCreation());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        int ticksRead = nbt.func_74762_e(NBT_TICKS_SINCE_CREATION);
        this.ticksSinceCreationServer = ticksRead = EnumDragonLifeStage.clampTickCount(ticksRead);
        this.dataWatcher.func_187227_b(this.dataParam, (Object)this.ticksSinceCreationServer);
    }

    public float getScale() {
        return EnumDragonLifeStage.scaleFromTickCount(this.getTicksSinceCreation());
    }

    public void transformToEgg() {
        if (this.dragon.func_110143_aJ() <= 0.0f) {
            return;
        }
        L.debug("transforming to egg");
        float volume = 1.0f;
        float pitch = 0.5f + (0.5f - this.rand.nextFloat()) * 0.1f;
        this.dragon.func_184185_a(SoundEvents.field_187534_aX, volume, pitch);
        if (this.dragon.isSaddled()) {
            this.dragon.func_145779_a(Items.field_151141_av, 1);
        }
        this.dragon.func_70099_a(new ItemStack((Block)BlockDragonBreedEgg.INSTANCE), this.dragon.getBreedType().getMeta());
        this.dragon.func_70106_y();
    }

    public final void setLifeStage(EnumDragonLifeStage lifeStage) {
        L.trace("setLifeStage({})", new Object[]{lifeStage});
        if (this.dragon.isServer()) {
            this.ticksSinceCreationServer = lifeStage.startTicks();
            this.dataWatcher.func_187227_b(this.dataParam, (Object)this.ticksSinceCreationServer);
        } else {
            L.error("setLifeStage called on Client");
        }
        this.updateLifeStage();
    }

    private void onNewLifeStage(EnumDragonLifeStage lifeStage, EnumDragonLifeStage prevLifeStage) {
        L.trace("onNewLifeStage({},{})", new Object[]{prevLifeStage, lifeStage});
        if (this.dragon.isClient()) {
            if (prevLifeStage != null && prevLifeStage == EnumDragonLifeStage.EGG && lifeStage == EnumDragonLifeStage.HATCHLING) {
                this.playEggCrackEffect();
                this.dragon.func_184185_a(SoundEvents.field_187929_hc, 1.0f, 1.0f);
            }
        } else {
            this.dragon.getBrain().updateAITasks();
            this.applyEntityAttributes();
            this.dragon.func_70606_j(this.dragon.func_110138_aP());
        }
    }

    @Override
    public void onLivingUpdate() {
        if (this.dragon.isServer()) {
            if (!this.isAdult()) {
                ++this.ticksSinceCreationServer;
                if (this.ticksSinceCreationServer % 100 == 0) {
                    this.dataWatcher.func_187227_b(this.dataParam, (Object)this.ticksSinceCreationServer);
                }
            }
        } else {
            this.ticksSinceCreationClient.updateFromServer((Integer)this.dataWatcher.func_187225_a(this.dataParam));
            if (!this.isAdult()) {
                this.ticksSinceCreationClient.tick();
            }
        }
        this.updateLifeStage();
        this.updateEgg();
        this.updateScale();
    }

    private void updateLifeStage() {
        EnumDragonLifeStage lifeStage = this.getLifeStage();
        if (this.lifeStagePrev != lifeStage) {
            this.onNewLifeStage(lifeStage, this.lifeStagePrev);
            this.lifeStagePrev = lifeStage;
        }
    }

    private void updateEgg() {
        if (!this.isEgg()) {
            return;
        }
        float progress = EnumDragonLifeStage.progressFromTickCount(this.getTicksSinceCreation());
        if (progress > 0.75f) {
            float wiggleChance = (progress - 0.75f) / 20.0f * 0.25f;
            if (this.eggWiggleX > 0) {
                --this.eggWiggleX;
            } else if (this.rand.nextFloat() < wiggleChance) {
                int n = this.eggWiggleX = this.rand.nextBoolean() ? 10 : 20;
                if (progress > 0.9f) {
                    this.playEggCrackEffect();
                }
            }
            if (this.eggWiggleZ > 0) {
                --this.eggWiggleZ;
            } else if (this.rand.nextFloat() < wiggleChance) {
                int n = this.eggWiggleZ = this.rand.nextBoolean() ? 10 : 20;
                if (progress > 0.9f) {
                    this.playEggCrackEffect();
                }
            }
        }
        double px = this.dragon.field_70165_t + (this.rand.nextDouble() - 0.5);
        double py = this.dragon.field_70163_u + (this.rand.nextDouble() - 0.5);
        double pz = this.dragon.field_70161_v + (this.rand.nextDouble() - 0.5);
        double ox = (this.rand.nextDouble() - 0.5) * 2.0;
        double oy = (this.rand.nextDouble() - 0.5) * 2.0;
        double oz = (this.rand.nextDouble() - 0.5) * 2.0;
        this.dragon.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, px, py, pz, ox, oy, oz, new int[0]);
    }

    private void updateScale() {
        this.dragon.setScalePublic(this.getScale());
    }

    @Override
    public void onDeath() {
        if (this.dragon.isClient() && this.isEgg()) {
            this.playEggCrackEffect();
        }
    }

    public boolean isEgg() {
        return this.getLifeStage() == EnumDragonLifeStage.EGG;
    }

    public boolean isHatchling() {
        return this.getLifeStage() == EnumDragonLifeStage.HATCHLING;
    }

    public boolean isJuvenile() {
        return this.getLifeStage() == EnumDragonLifeStage.JUVENILE;
    }

    public boolean isAdult() {
        return this.getLifeStage() == EnumDragonLifeStage.ADULT;
    }
}

