/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity.helper;

import info.ata4.minecraft.dragon.util.math.Interpolation;
import net.minecraft.util.math.MathHelper;

public enum EnumDragonLifeStage {
    EGG(0.25f),
    HATCHLING(0.33f),
    JUVENILE(0.66f),
    ADULT(1.0f);

    public static final int TICKS_PER_STAGE = 24000;
    public static final EnumDragonLifeStage[] VALUES;
    public final float scale;

    public static EnumDragonLifeStage fromTickCount(int ticksSinceCreation) {
        return VALUES[EnumDragonLifeStage.clampTickCount(ticksSinceCreation) / 24000];
    }

    public static float progressFromTickCount(int ticksSinceCreation) {
        EnumDragonLifeStage lifeStage = EnumDragonLifeStage.fromTickCount(ticksSinceCreation);
        int lifeStageTicks = ticksSinceCreation - lifeStage.startTicks();
        return (float)lifeStageTicks / 24000.0f;
    }

    public static float scaleFromTickCount(int ticksSinceCreation) {
        EnumDragonLifeStage lifeStage = EnumDragonLifeStage.fromTickCount(ticksSinceCreation);
        if (lifeStage == EGG || lifeStage == ADULT) {
            return lifeStage.scale;
        }
        return Interpolation.linear(lifeStage.scale, lifeStage.next().scale, EnumDragonLifeStage.progressFromTickCount(ticksSinceCreation));
    }

    public static int clampTickCount(int ticksSinceCreation) {
        return MathHelper.func_76125_a((int)ticksSinceCreation, (int)0, (int)(VALUES.length * 24000));
    }

    private EnumDragonLifeStage(float scale) {
        this.scale = scale;
    }

    public int startTicks() {
        return this.ordinal() * 24000;
    }

    public EnumDragonLifeStage next() {
        return this == ADULT ? null : VALUES[this.ordinal() + 1];
    }

    static {
        VALUES = EnumDragonLifeStage.values();
    }
}

