/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity.helper;

import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.entity.breeds.DragonBreed;
import info.ata4.minecraft.dragon.server.entity.breeds.EnumDragonBreed;
import info.ata4.minecraft.dragon.server.entity.helper.DragonHelper;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import org.apache.commons.lang3.EnumUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DragonBreedHelper
extends DragonHelper {
    private static final Logger L = LogManager.getLogger();
    private static final int BLOCK_RANGE = 2;
    private static final int POINTS_INITIAL = 1000;
    private static final int POINTS_INHERIT = 1800;
    private static final int POINTS_BLOCK = 1;
    private static final int POINTS_BIOME = 1;
    private static final int POINTS_ENV = 3;
    private static final int TICK_RATE_PARTICLES = 2;
    private static final int TICK_RATE_BLOCK = 20;
    private static final String NBT_BREED = "Breed";
    private static final String NBT_BREED_POINTS = "breedPoints";
    private final DataParameter<String> dataParam;
    private final Map<EnumDragonBreed, AtomicInteger> breedPoints = new EnumMap<EnumDragonBreed, AtomicInteger>(EnumDragonBreed.class);

    public DragonBreedHelper(EntityTameableDragon dragon, DataParameter<String> dataParam) {
        super(dragon);
        this.dataParam = dataParam;
        if (dragon.isServer()) {
            for (EnumDragonBreed type : EnumDragonBreed.values()) {
                this.breedPoints.put(type, new AtomicInteger());
            }
            this.breedPoints.get((Object)EnumDragonBreed.DEFAULT).set(1000);
        }
        this.dataWatcher.func_187214_a(dataParam, (Object)EnumDragonBreed.DEFAULT.func_176610_l());
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a(NBT_BREED, this.getBreedType().func_176610_l());
        NBTTagCompound breedPointTag = new NBTTagCompound();
        this.breedPoints.forEach((type, points) -> breedPointTag.func_74768_a(type.func_176610_l(), points.get()));
        nbt.func_74782_a(NBT_BREED_POINTS, (NBTBase)breedPointTag);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        String breedName = nbt.func_74779_i(NBT_BREED);
        EnumDragonBreed breed = (EnumDragonBreed)EnumUtils.getEnum(EnumDragonBreed.class, (String)breedName.toUpperCase());
        if (breed == null) {
            breed = EnumDragonBreed.DEFAULT;
            L.warn("Dragon {} loaded with invalid breed type {}, using {} instead", new Object[]{this.dragon.func_145782_y(), breedName, breed});
        }
        this.setBreedType(breed);
        NBTTagCompound breedPointTag = nbt.func_74775_l(NBT_BREED_POINTS);
        this.breedPoints.forEach((type, points) -> points.set(breedPointTag.func_74762_e(type.func_176610_l())));
    }

    public Map<EnumDragonBreed, AtomicInteger> getBreedPoints() {
        return Collections.unmodifiableMap(this.breedPoints);
    }

    public EnumDragonBreed getBreedType() {
        String breedName = (String)this.dataWatcher.func_187225_a(this.dataParam);
        return (EnumDragonBreed)EnumUtils.getEnum(EnumDragonBreed.class, (String)breedName.toUpperCase());
    }

    public void setBreedType(EnumDragonBreed newType) {
        L.trace("setBreed({})", new Object[]{newType});
        if (this.dragon.isClient()) {
            return;
        }
        Objects.requireNonNull(newType);
        EnumDragonBreed oldType = this.getBreedType();
        if (oldType == newType) {
            return;
        }
        DragonBreed oldBreed = oldType.getBreed();
        DragonBreed newBreed = newType.getBreed();
        oldBreed.onDisable(this.dragon);
        newBreed.onEnable(this.dragon);
        this.dragon.setImmuneToFire(newBreed.isImmuneToDamage(DamageSource.field_76372_a) || newBreed.isImmuneToDamage(DamageSource.field_76370_b) || newBreed.isImmuneToDamage(DamageSource.field_76371_c));
        this.dataWatcher.func_187227_b(this.dataParam, (Object)newType.func_176610_l());
        if (this.dragon.isEgg()) {
            this.breedPoints.values().forEach(points -> points.set(0));
            this.breedPoints.get((Object)newType).set(1000);
        }
    }

    @Override
    public void onLivingUpdate() {
        EnumDragonBreed currentType = this.getBreedType();
        if (this.dragon.isEgg()) {
            if (this.dragon.isClient() && this.dragon.field_70173_aa % 2 == 0 && currentType != EnumDragonBreed.DEFAULT) {
                double px = this.dragon.field_70165_t + (this.rand.nextDouble() - 0.5);
                double py = this.dragon.field_70163_u + (this.rand.nextDouble() - 0.5);
                double pz = this.dragon.field_70161_v + (this.rand.nextDouble() - 0.5);
                DragonBreed current = currentType.getBreed();
                this.dragon.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, px, py + 1.0, pz, (double)current.getColorR(), (double)current.getColorG(), (double)current.getColorB(), new int[0]);
            }
            if (this.dragon.isServer() && this.dragon.field_70173_aa % 20 == 0) {
                BlockPos eggPos = this.dragon.func_180425_c();
                BlockPos eggPosFrom = eggPos.func_177982_a(2, 2, 2);
                BlockPos eggPosTo = eggPos.func_177982_a(-2, -2, -2);
                BlockPos.func_177975_b((BlockPos)eggPosFrom, (BlockPos)eggPosTo).forEach(blockPos -> {
                    Block block = this.dragon.field_70170_p.func_180495_p((BlockPos)blockPos).func_177230_c();
                    this.breedPoints.entrySet().stream().filter(breed -> ((EnumDragonBreed)((Object)((Object)((Object)breed.getKey())))).getBreed().isHabitatBlock(block)).forEach(breed -> ((AtomicInteger)breed.getValue()).addAndGet(1));
                });
                Biome biome = this.dragon.field_70170_p.func_180494_b(eggPos);
                this.breedPoints.keySet().forEach(breed -> {
                    if (breed.getBreed().isHabitatBiome(biome)) {
                        this.breedPoints.get(breed).addAndGet(1);
                    }
                    if (breed.getBreed().isHabitatEnvironment(this.dragon)) {
                        this.breedPoints.get(breed).addAndGet(3);
                    }
                });
                EnumDragonBreed newType = (EnumDragonBreed)((Object)((Map.Entry)this.breedPoints.entrySet().stream().max((breed1, breed2) -> Integer.compare(((AtomicInteger)breed1.getValue()).get(), ((AtomicInteger)breed2.getValue()).get())).get()).getKey());
                if (newType != currentType) {
                    this.setBreedType(newType);
                }
            }
        }
        currentType.getBreed().onUpdate(this.dragon);
    }

    @Override
    public void onDeath() {
        this.getBreedType().getBreed().onDeath(this.dragon);
    }

    public void inheritBreed(EntityTameableDragon parent1, EntityTameableDragon parent2) {
        this.breedPoints.get((Object)parent1.getBreedType()).addAndGet(1800 + this.rand.nextInt(1800));
        this.breedPoints.get((Object)parent2.getBreedType()).addAndGet(1800 + this.rand.nextInt(1800));
    }
}

