/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.builtins;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import net.lomeli.lomlib.repack.kotlin.collections.CollectionsKt;
import net.lomeli.lomlib.repack.kotlin.collections.SetsKt;
import net.lomeli.lomlib.repack.kotlin.jvm.internal.Intrinsics;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import net.lomeli.lomlib.repack.org.jetbrains.annotations.NotNull;

public final class CompanionObjectMapping {
    private final LinkedHashSet<ClassDescriptor> classes;
    private final KotlinBuiltIns builtIns;

    @NotNull
    public final Set<ClassDescriptor> allClassesWithIntrinsicCompanions() {
        Set<ClassDescriptor> set = Collections.unmodifiableSet((Set)this.classes);
        Intrinsics.checkExpressionValueIsNotNull(set, "Collections.unmodifiableSet(classes)");
        return set;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasMappingToObject(@NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
        if (!DescriptorUtils.isCompanionObject(classDescriptor)) return false;
        Iterable iterable = this.classes;
        DeclarationDescriptor declarationDescriptor = classDescriptor.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "classDescriptor.containingDeclaration");
        if (!CollectionsKt.contains(iterable, declarationDescriptor)) return false;
        return true;
    }

    public CompanionObjectMapping(@NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        this.builtIns = builtIns;
        this.classes = SetsKt.linkedSetOf(new ClassDescriptor[0]);
        for (PrimitiveType type2 : PrimitiveType.NUMBER_TYPES) {
            this.classes.add(this.builtIns.getPrimitiveClassDescriptor(type2));
        }
        this.classes.add(this.builtIns.getString());
        this.classes.add(this.builtIns.getEnum());
    }
}

