/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.lomeli.lomlib.repack.kotlin.Unit;
import net.lomeli.lomlib.repack.kotlin._Assertions;
import net.lomeli.lomlib.repack.kotlin.jvm.functions.Function1;
import net.lomeli.lomlib.repack.kotlin.jvm.internal.Intrinsics;
import net.lomeli.lomlib.repack.kotlin.jvm.internal.Ref;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.descriptors.annotations.CompositeAnnotations;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.load.java.JvmAnnotationNames;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.EnhancedTypeAnnotations;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.EnhancementResult;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.JavaTypeQualifiers;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.MutabilityQualifier;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.NotNullTypeParameterTypeCapability;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.NullabilityQualifier;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.Result;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeComponentPosition;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.name.FqName;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.platform.JavaToKotlinClassMap;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.types.CustomTypeVariable;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.types.DelegatingFlexibleType;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.types.Flexibility;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.types.KotlinType;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.types.KotlinTypeImpl;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.types.TypeCapabilities;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.types.TypeCapabilitiesKt;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.types.TypeCapability;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.types.Variance;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.utils.CollectionsKt;
import net.lomeli.lomlib.repack.org.jetbrains.annotations.NotNull;
import net.lomeli.lomlib.repack.org.jetbrains.annotations.Nullable;

public final class TypeEnhancementKt {
    private static final EnhancedTypeAnnotations ENHANCED_NULLABILITY_ANNOTATIONS;
    private static final EnhancedTypeAnnotations ENHANCED_MUTABILITY_ANNOTATIONS;

    @Nullable
    public static final KotlinType enhance(@NotNull KotlinType $receiver, @NotNull Function1<? super Integer, JavaTypeQualifiers> qualifiers) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(qualifiers, "qualifiers");
        return TypeEnhancementKt.enhancePossiblyFlexible($receiver, qualifiers, 0).getTypeIfChanged();
    }

    public static final boolean hasEnhancedNullability(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION");
        return annotations2.findAnnotation(fqName2) != null;
    }

    private static final Result enhancePossiblyFlexible(@NotNull KotlinType $receiver, Function1<? super Integer, JavaTypeQualifiers> qualifiers, int index) {
        Result result;
        if ($receiver.isError()) {
            return new Result($receiver, 1, false);
        }
        if (FlexibleTypesKt.isFlexible($receiver)) {
            Unit unit;
            Flexibility flexibility = FlexibleTypesKt.flexibility($receiver);
            Flexibility $receiver2 = flexibility;
            Result lowerResult = TypeEnhancementKt.enhanceInflexible($receiver2.getLowerBound(), qualifiers, index, TypeComponentPosition.FLEXIBLE_LOWER);
            Result upperResult = TypeEnhancementKt.enhanceInflexible($receiver2.getUpperBound(), qualifiers, index, TypeComponentPosition.FLEXIBLE_UPPER);
            boolean bl = lowerResult.getSubtreeSize() == upperResult.getSubtreeSize();
            if (_Assertions.ENABLED) {
                if (!bl) {
                    String string = "Different tree sizes of bounds: " + ("lower = (" + $receiver2.getLowerBound() + ", " + lowerResult.getSubtreeSize() + "), ") + ("upper = (" + $receiver2.getUpperBound() + ", " + upperResult.getSubtreeSize() + ")");
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            boolean wereChanges = lowerResult.getWereChanges() || upperResult.getWereChanges();
            result = new Result(wereChanges ? DelegatingFlexibleType.Companion.create(lowerResult.getType(), upperResult.getType(), $receiver2.getExtraCapabilities()) : $receiver, lowerResult.getSubtreeSize(), wereChanges);
        } else {
            result = TypeEnhancementKt.enhanceInflexible($receiver, qualifiers, index, TypeComponentPosition.INFLEXIBLE);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final Result enhanceInflexible(@NotNull KotlinType $receiver, Function1<? super Integer, JavaTypeQualifiers> qualifiers, int index, TypeComponentPosition position) {
        void enhancedNullability;
        TypeCapabilities typeCapabilities2;
        void enhancedNullabilityAnnotations;
        void wereChanges;
        void globalArgIndex;
        EnhancementResult<Boolean> destination$iv$iv;
        Annotations $receiver$iv$iv;
        void $receiver$iv22;
        void enhancedMutabilityAnnotations;
        void enhancedClassifier;
        boolean shouldEnhance = TypeEnhancementKt.shouldEnhance(position);
        if (!shouldEnhance && $receiver.getArguments().isEmpty()) {
            return new Result($receiver, 1, false);
        }
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return new Result($receiver, 1, false);
        }
        ClassifierDescriptor originalClass = classifierDescriptor;
        JavaTypeQualifiers effectiveQualifiers = qualifiers.invoke((Integer)index);
        EnhancementResult<ClassifierDescriptor> enhancementResult = TypeEnhancementKt.enhanceMutability(originalClass, effectiveQualifiers, position);
        ClassifierDescriptor classifierDescriptor2 = enhancementResult.component1();
        Annotations annotations2 = enhancementResult.component2();
        enhancementResult = null;
        TypeConstructor typeConstructor2 = enhancedClassifier.getTypeConstructor();
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = index + 1;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = enhancedMutabilityAnnotations != null;
        Iterable iterable = $receiver.getArguments();
        void var13_14 = $receiver$iv22;
        Collection collection = new ArrayList(net.lomeli.lomlib.repack.kotlin.collections.CollectionsKt.collectionSizeOrDefault($receiver$iv22, 10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            TypeProjection typeProjection;
            void localArgIndex;
            void arg;
            int n = index$iv$iv++;
            TypeProjection typeProjection2 = (TypeProjection)item$iv$iv;
            int n2 = n;
            void var20_23 = destination$iv$iv;
            if (arg.isStarProjection()) {
                int n3 = globalArgIndex.element;
                globalArgIndex.element = n3 + 1;
                typeProjection = TypeUtils.makeStarProjection(enhancedClassifier.getTypeConstructor().getParameters().get((int)localArgIndex));
            } else {
                void enhancedType;
                void subtreeSize;
                void wasChangeInArgument;
                Result result = TypeEnhancementKt.enhancePossiblyFlexible(arg.getType(), qualifiers, globalArgIndex.element);
                KotlinType kotlinType = result.component1();
                int n4 = result.component2();
                boolean bl = result.component3();
                result = null;
                wereChanges.element = wereChanges.element || wasChangeInArgument != false;
                globalArgIndex.element += subtreeSize;
                Variance variance = arg.getProjectionKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)variance, "arg.projectionKind");
                typeProjection = TypeUtilsKt.createProjection((KotlinType)enhancedType, variance, typeConstructor2.getParameters().get((int)localArgIndex));
            }
            TypeProjection typeProjection3 = typeProjection;
            var20_23.add(typeProjection3);
        }
        List enhancedArguments = (List)((Object)destination$iv$iv);
        destination$iv$iv = TypeEnhancementKt.getEnhancedNullability($receiver, effectiveQualifiers, position);
        boolean $receiver$iv22 = destination$iv$iv.component1();
        $receiver$iv$iv = destination$iv$iv.component2();
        destination$iv$iv = null;
        wereChanges.element = wereChanges.element || enhancedNullabilityAnnotations != null;
        int subtreeSize = globalArgIndex.element - index;
        if (!wereChanges.element) {
            return new Result($receiver, subtreeSize, false);
        }
        Annotations newAnnotations = TypeEnhancementKt.compositeAnnotationsOrSingle(net.lomeli.lomlib.repack.kotlin.collections.CollectionsKt.filterNotNull((Iterable)net.lomeli.lomlib.repack.kotlin.collections.CollectionsKt.listOf(new Annotations[]{$receiver.getAnnotations(), enhancedMutabilityAnnotations, enhancedNullabilityAnnotations})));
        TypeConstructor typeConstructor3 = typeConstructor2;
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor3, "typeConstructor");
        TypeSubstitution newSubstitution = TypeSubstitutionKt.computeNewSubstitution($receiver, typeConstructor3, enhancedArguments);
        if (effectiveQualifiers.isNotNullTypeParameter$kotlin_core()) {
            typeCapabilities2 = TypeCapabilitiesKt.addCapability($receiver.getCapabilities(), CustomTypeVariable.class, (TypeCapability)NotNullTypeParameterTypeCapability.INSTANCE);
        } else {
            TypeCapabilities typeCapabilities3 = $receiver.getCapabilities();
            typeCapabilities2 = typeCapabilities3;
            Intrinsics.checkExpressionValueIsNotNull(typeCapabilities3, "capabilities");
        }
        TypeCapabilities newCapabilities = typeCapabilities2;
        TypeConstructor typeConstructor4 = typeConstructor2;
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor4, "typeConstructor");
        MemberScope memberScope2 = enhancedClassifier instanceof ClassDescriptor ? ((ClassDescriptor)enhancedClassifier).getMemberScope(newSubstitution) : enhancedClassifier.getDefaultType().getMemberScope();
        Intrinsics.checkExpressionValueIsNotNull(memberScope2, "if (enhancedClassifier i\u2026ltType().getMemberScope()");
        KotlinTypeImpl enhancedType = KotlinTypeImpl.Companion.create(newAnnotations, typeConstructor4, (boolean)enhancedNullability, enhancedArguments, newSubstitution, memberScope2, newCapabilities);
        return new Result(enhancedType, subtreeSize, true);
    }

    private static final Annotations compositeAnnotationsOrSingle(@NotNull List<? extends Annotations> $receiver) {
        Annotations annotations2;
        switch ($receiver.size()) {
            case 0: {
                String string = "At least one Annotations object expected";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            case 1: {
                annotations2 = net.lomeli.lomlib.repack.kotlin.collections.CollectionsKt.single($receiver);
                break;
            }
            default: {
                annotations2 = new CompositeAnnotations(CollectionsKt.toReadOnlyList((Collection)$receiver));
            }
        }
        return annotations2;
    }

    private static final boolean shouldEnhance(@NotNull TypeComponentPosition $receiver) {
        return Intrinsics.areEqual((Object)$receiver, (Object)TypeComponentPosition.INFLEXIBLE) ^ true;
    }

    private static final <T> EnhancementResult<T> noChange(T $receiver) {
        return new EnhancementResult<T>($receiver, null);
    }

    private static final <T> EnhancementResult<T> enhancedNullability(T $receiver) {
        return new EnhancementResult<T>($receiver, ENHANCED_NULLABILITY_ANNOTATIONS);
    }

    private static final <T> EnhancementResult<T> enhancedMutability(T $receiver) {
        return new EnhancementResult<T>($receiver, ENHANCED_MUTABILITY_ANNOTATIONS);
    }

    private static final EnhancementResult<ClassifierDescriptor> enhanceMutability(@NotNull ClassifierDescriptor $receiver, JavaTypeQualifiers qualifiers, TypeComponentPosition position) {
        if (!TypeEnhancementKt.shouldEnhance(position)) {
            return TypeEnhancementKt.noChange($receiver);
        }
        if (!($receiver instanceof ClassDescriptor)) {
            return TypeEnhancementKt.noChange($receiver);
        }
        JavaToKotlinClassMap mapping = JavaToKotlinClassMap.INSTANCE;
        MutabilityQualifier mutabilityQualifier = qualifiers.getMutability();
        if (Intrinsics.areEqual((Object)mutabilityQualifier, (Object)MutabilityQualifier.READ_ONLY)) {
            if (Intrinsics.areEqual((Object)position, (Object)TypeComponentPosition.FLEXIBLE_LOWER) && mapping.isMutable((ClassDescriptor)$receiver)) {
                return TypeEnhancementKt.enhancedMutability(mapping.convertMutableToReadOnly((ClassDescriptor)$receiver));
            }
        } else if (Intrinsics.areEqual((Object)mutabilityQualifier, (Object)MutabilityQualifier.MUTABLE) && Intrinsics.areEqual((Object)position, (Object)TypeComponentPosition.FLEXIBLE_UPPER) && mapping.isReadOnly((ClassDescriptor)$receiver)) {
            return TypeEnhancementKt.enhancedMutability(mapping.convertReadOnlyToMutable((ClassDescriptor)$receiver));
        }
        return TypeEnhancementKt.noChange($receiver);
    }

    private static final EnhancementResult<Boolean> getEnhancedNullability(@NotNull KotlinType $receiver, JavaTypeQualifiers qualifiers, TypeComponentPosition position) {
        if (!TypeEnhancementKt.shouldEnhance(position)) {
            return TypeEnhancementKt.noChange($receiver.isMarkedNullable());
        }
        NullabilityQualifier nullabilityQualifier = qualifiers.getNullability();
        return Intrinsics.areEqual((Object)nullabilityQualifier, (Object)NullabilityQualifier.NULLABLE) ? TypeEnhancementKt.enhancedNullability(true) : (Intrinsics.areEqual((Object)nullabilityQualifier, (Object)NullabilityQualifier.NOT_NULL) ? TypeEnhancementKt.enhancedNullability(false) : TypeEnhancementKt.noChange($receiver.isMarkedNullable()));
    }

    static {
        FqName fqName2 = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION");
        ENHANCED_NULLABILITY_ANNOTATIONS = new EnhancedTypeAnnotations(fqName2);
        FqName fqName3 = JvmAnnotationNames.ENHANCED_MUTABILITY_ANNOTATION;
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "JvmAnnotationNames.ENHANCED_MUTABILITY_ANNOTATION");
        ENHANCED_MUTABILITY_ANNOTATIONS = new EnhancedTypeAnnotations(fqName3);
    }
}

