/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.load.kotlin;

import net.lomeli.lomlib.repack.kotlin.Unit;
import net.lomeli.lomlib.repack.kotlin._Assertions;
import net.lomeli.lomlib.repack.kotlin.jvm.internal.Intrinsics;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializedDescriptorResolver;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinarySourceElement;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.name.ClassId;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.serialization.ClassData;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.serialization.ClassDataWithSource;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataFinder;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.serialization.jvm.JvmProtoBufUtil;
import net.lomeli.lomlib.repack.org.jetbrains.annotations.NotNull;
import net.lomeli.lomlib.repack.org.jetbrains.annotations.Nullable;

public final class JavaClassDataFinder
implements ClassDataFinder {
    private final KotlinClassFinder kotlinClassFinder;
    private final DeserializedDescriptorResolver deserializedDescriptorResolver;

    @Override
    @Nullable
    public ClassDataWithSource findClassData(@NotNull ClassId classId) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        KotlinJvmBinaryClass kotlinJvmBinaryClass = this.kotlinClassFinder.findKotlinClass(classId);
        if (kotlinJvmBinaryClass == null) {
            return null;
        }
        KotlinJvmBinaryClass kotlinJvmBinaryClass2 = kotlinJvmBinaryClass;
        boolean bl = Intrinsics.areEqual(kotlinJvmBinaryClass2.getClassId(), classId);
        if (_Assertions.ENABLED) {
            if (!bl) {
                String string = "Class with incorrect id found: expected " + classId + ", actual " + kotlinJvmBinaryClass2.getClassId();
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        String[] stringArray = this.deserializedDescriptorResolver.readData$kotlin_core(kotlinJvmBinaryClass2, DeserializedDescriptorResolver.Companion.getKOTLIN_CLASS$kotlin_core());
        if (stringArray == null) {
            return null;
        }
        String[] data = stringArray;
        String[] stringArray2 = kotlinJvmBinaryClass2.getClassHeader().getStrings();
        if (stringArray2 == null) {
            String string = "String table not found in " + kotlinJvmBinaryClass2;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        String[] strings = stringArray2;
        ClassData classData = JvmProtoBufUtil.readClassDataFrom(data, strings);
        return new ClassDataWithSource(classData, new KotlinJvmBinarySourceElement(kotlinJvmBinaryClass2));
    }

    public JavaClassDataFinder(@NotNull KotlinClassFinder kotlinClassFinder, @NotNull DeserializedDescriptorResolver deserializedDescriptorResolver) {
        Intrinsics.checkParameterIsNotNull(kotlinClassFinder, "net.lomeli.lomlib.repack.kotlinClassFinder");
        Intrinsics.checkParameterIsNotNull(deserializedDescriptorResolver, "deserializedDescriptorResolver");
        this.kotlinClassFinder = kotlinClassFinder;
        this.deserializedDescriptorResolver = deserializedDescriptorResolver;
    }
}

