/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import net.lomeli.lomlib.repack.kotlin.collections.CollectionsKt;
import net.lomeli.lomlib.repack.kotlin.jvm.internal.Intrinsics;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProvider;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.name.ClassId;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.name.FqName;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.serialization.ClassDataWithSource;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataFinder;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedPackageFragment;
import net.lomeli.lomlib.repack.org.jetbrains.annotations.NotNull;
import net.lomeli.lomlib.repack.org.jetbrains.annotations.Nullable;

public final class DeserializedClassDataFinder
implements ClassDataFinder {
    private final PackageFragmentProvider packageFragmentProvider;

    @Override
    @Nullable
    public ClassDataWithSource findClassData(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "classId.packageFqName");
        PackageFragmentDescriptor packageFragmentDescriptor = CollectionsKt.singleOrNull(this.packageFragmentProvider.getPackageFragments(fqName2));
        if (!(packageFragmentDescriptor instanceof DeserializedPackageFragment)) {
            packageFragmentDescriptor = null;
        }
        DeserializedPackageFragment deserializedPackageFragment = (DeserializedPackageFragment)packageFragmentDescriptor;
        if (deserializedPackageFragment == null) {
            return null;
        }
        DeserializedPackageFragment packageFragment = deserializedPackageFragment;
        return packageFragment.getClassDataFinder().findClassData(classId);
    }

    public DeserializedClassDataFinder(@NotNull PackageFragmentProvider packageFragmentProvider) {
        Intrinsics.checkParameterIsNotNull(packageFragmentProvider, "packageFragmentProvider");
        this.packageFragmentProvider = packageFragmentProvider;
    }
}

